/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.network;

import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.endertech.minecraft.mods.adchimneys.world.Events;
import com.endertech.minecraft.mods.adchimneys.world.SmokeLocations;
import com.endertech.minecraft.mods.adchimneys.world.WorldData;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class SmokePosMsg
extends ForgeNetMsg<SmokePosMsg> {
    public BlockPos pos;
    public float amount;
    public float intencity;
    public float scale;
    public ColorARGB color;

    public SmokePosMsg() {
    }

    public SmokePosMsg(BlockPos pos, Smoke smoke) {
        this.pos = pos;
        this.amount = smoke.getAmount();
        this.intencity = smoke.getIntensity();
        this.scale = smoke.getScale();
        this.color = smoke.getFirstColorOrDefault();
    }

    public SmokePosMsg create() {
        return new SmokePosMsg();
    }

    public void sendToAllAround(ServerLevelAccessor world, BlockPos pos, int radius) {
        AdChimneys.getInstance().getConnection().sendToAllAround((Object)this, world, pos, radius);
    }

    public void handle(Level world, Player player) {
        Smoke smoke = new Smoke(this.amount, this.intencity, this.scale, this.color);
        SmokeLocations locations = WorldData.getData((LevelAccessor)world).getSmokeLocations();
        Smoke existedSmoke = locations.get(this.pos);
        if (existedSmoke != null && existedSmoke.getLifeTime().lessThan(Events.serverUpdateTime.getInterval())) {
            smoke = smoke.combine(existedSmoke);
        }
        locations.add(this.pos, smoke);
    }
}

