/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.smoke;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.INBTSerializable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;

public class Smoke
implements INBTSerializable<Smoke> {
    public static final float MIN_SCALE = 1.0f;
    public static ForgeConfigSpec.ConfigValue<Integer> defaultColor;
    public static ForgeConfigSpec.ConfigValue<Integer> maxAmount;
    public static ForgeConfigSpec.ConfigValue<Double> maxIntensity;
    public static ForgeConfigSpec.ConfigValue<Double> maxScale;
    public static ForgeConfigSpec.ConfigValue<Boolean> canCollide;
    public static ForgeConfigSpec.ConfigValue<Double> coloringFactor;
    public static ForgeConfigSpec.ConfigValue<Boolean> colorize;
    public static ForgeConfigSpec.ConfigValue<Integer> maxRenderDistance;
    public static ForgeConfigSpec.ConfigValue<Integer> maxRenderedParticlesAmount;
    public static ForgeConfigSpec.ConfigValue<Boolean> emitWithoutChimney;
    public static ForgeConfigSpec.ConfigValue<Boolean> retroParticles;
    public static ForgeConfigSpec.ConfigValue<Boolean> disableVanillaCampfireSmoke;
    private final CommonTime.Stamp creationTime;
    private final float amount;
    private final float intensity;
    private final float scale;
    private final List<ColorARGB> colors = new ArrayList<ColorARGB>();
    protected static ColorARGB defaultColorARGB;

    public static Smoke getNone() {
        return new Smoke();
    }

    public static ColorARGB getDefaultColor() {
        if (defaultColor == null || ((Integer)defaultColor.get()).intValue() == ColorARGB.DEFAULT.getARGB()) {
            if ((retroParticles == null || !((Boolean)retroParticles.get()).booleanValue()) && defaultColorARGB.equals((Object)ColorARGB.DEFAULT)) {
                defaultColorARGB = ColorARGB.from((Color)Color.WHITE);
            }
        } else if (((Integer)defaultColor.get()).intValue() != defaultColorARGB.getARGB()) {
            defaultColorARGB = ColorARGB.from((int)((Integer)defaultColor.get()));
        }
        return defaultColorARGB;
    }

    public static boolean canPassThrough(BlockGetter world, BlockPos pos, Direction from, Direction to) {
        BlockState state = world.m_8055_(pos);
        return !state.m_60783_(world, pos, from) && !state.m_60783_(world, pos, to);
    }

    public Smoke() {
        this(null, 0.0f, 0.0f, 1.0f);
    }

    public Smoke(@Nullable UnitConfig config, Smoke smoke) {
        this(config, smoke.getAmount(), smoke.getIntensity(), smoke.getScale());
        this.colors.addAll(smoke.colors);
    }

    public Smoke(float amount, float intensity, float scale) {
        this(null, amount, intensity, scale);
    }

    public Smoke(float amount, float intensity, float scale, ColorARGB color) {
        this(null, amount, intensity, scale, color);
    }

    public Smoke(@Nullable UnitConfig config, float amount, float intensity, float scale) {
        this(config, amount, intensity, scale, null);
    }

    public Smoke(@Nullable UnitConfig config, float amount, float intensity, float scale, @Nullable ColorARGB color) {
        String category = this.getClass().getSimpleName();
        this.amount = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"amount", (float)amount, (FloatBounds)new FloatBounds(Float.valueOf(0.0f), Float.valueOf(((Integer)maxAmount.get()).floatValue())), (String)"Defines particles amount");
        this.intensity = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"intensity", (float)intensity, (FloatBounds)new FloatBounds(Float.valueOf(0.0f), Float.valueOf(((Double)maxIntensity.get()).floatValue())), (String)"Defines smoke blow out distance.");
        this.scale = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"scale", (float)scale, (FloatBounds)new FloatBounds(Float.valueOf(1.0f), Float.valueOf(((Double)maxScale.get()).floatValue())), (String)"Defines smoke particles scale.");
        this.addColor(color);
        this.creationTime = CommonTime.Stamp.now();
    }

    public Smoke combine(Smoke smoke) {
        if (smoke == null) {
            smoke = new Smoke();
        }
        Smoke combined = new Smoke(null, this.getAmount() + smoke.getAmount(), this.getIntensity() + smoke.getIntensity(), Math.max(this.getScale(), smoke.getScale()));
        combined.colors.addAll(this.colors);
        combined.colors.addAll(smoke.colors);
        return combined;
    }

    protected boolean addColor(ColorARGB color) {
        if (color == null || color.equals((Object)Smoke.getDefaultColor()) || color.isCompletelyTransparent()) {
            return false;
        }
        return this.colors.add(color);
    }

    public List<ColorARGB> getAllColors() {
        return Collections.unmodifiableList(this.colors);
    }

    public ColorARGB pickColor() {
        ColorARGB defaultColor = Smoke.getDefaultColor();
        if (colorize == null || !((Boolean)colorize.get()).booleanValue()) {
            return defaultColor;
        }
        int chance = CommonMath.Random.between((int)0, (int)255);
        ArrayList<ColorARGB> picked = new ArrayList<ColorARGB>();
        for (ColorARGB color : this.colors) {
            if (chance >= color.getAlpha().value) continue;
            picked.add(color);
        }
        return Optional.ofNullable((ColorARGB)CommonMath.Random.from(picked)).orElse(defaultColor);
    }

    public ColorARGB getFirstColorOrDefault() {
        return this.colors.size() > 0 ? this.colors.get(0) : Smoke.getDefaultColor();
    }

    public boolean hasParticles() {
        return CommonMath.getRounded((float)this.getAmount()) > 0;
    }

    public Smoke transferThrough(float patency, ColorARGB addColor) {
        Smoke transfered = new Smoke(null, this.getAmount() * patency, this.getIntensity() * patency, (float)((double)this.getScale() * CommonMath.raiseToPower((double)patency, (double)0.1111111111111111)));
        transfered.colors.addAll(this.colors);
        transfered.addColor(addColor);
        return transfered;
    }

    public String toString() {
        return this.getClass().getSimpleName() + Args.group((Object[])new Object[]{Args.get((String)"amount", (Object)Float.valueOf(this.getAmount())), Args.get((String)"intensity", (Object)Float.valueOf(this.getIntensity())), Args.get((String)"scale", (Object)Float.valueOf(this.getScale())), this.getAllColors()});
    }

    public CommonTime.Stamp getCreationTime() {
        return this.creationTime;
    }

    public CommonTime.Interval getLifeTime() {
        return CommonTime.Interval.passedFrom((CommonTime.Stamp)this.getCreationTime());
    }

    public float getAmount() {
        return this.amount;
    }

    public float getIntensity() {
        return this.intensity;
    }

    public float getScale() {
        return this.scale;
    }

    public Smoke withAmount(float amount) {
        Smoke smoke = new Smoke(amount, this.getIntensity(), this.getScale());
        smoke.colors.addAll(this.colors);
        return smoke;
    }

    public Smoke devideInto(float amount) {
        Smoke smoke = new Smoke(this.getAmount() / amount, this.getIntensity() / amount, this.getScale());
        smoke.colors.addAll(this.colors);
        return smoke;
    }

    public Smoke readFrom(CompoundTag compound) {
        CompoundTag tag = compound.m_128469_("Smoke");
        float amount = tag.m_128457_("amount");
        float intensity = tag.m_128457_("intensity");
        float scale = tag.m_128457_("scale");
        int[] colors = tag.m_128465_("colors");
        Smoke smoke = new Smoke(amount, intensity, scale);
        for (int color : colors) {
            smoke.addColor(ColorARGB.from((int)color));
        }
        return smoke;
    }

    public CompoundTag writeTo(CompoundTag compound) {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("amount", this.getAmount());
        tag.m_128350_("intensity", this.getIntensity());
        tag.m_128350_("scale", this.getScale());
        int[] intColors = new int[this.colors.size()];
        for (int i = 0; i < intColors.length; ++i) {
            intColors[i] = this.colors.get(i).getARGB();
        }
        tag.m_128385_("colors", intColors);
        compound.m_128365_("Smoke", (Tag)tag);
        return compound;
    }

    static {
        defaultColorARGB = ColorARGB.DEFAULT;
    }
}

