/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.world;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.events.CampfireSmokeEvent;
import com.endertech.minecraft.forge.events.ChunkFullyLoadedEvent;
import com.endertech.minecraft.forge.events.RandomTickEvent;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.mods.adchimneys.particles.ModernSmokeParticle;
import com.endertech.minecraft.mods.adchimneys.particles.RetroSmokeParticle;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.endertech.minecraft.mods.adchimneys.world.SmokeLocations;
import com.endertech.minecraft.mods.adchimneys.world.WorldData;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Events {
    public static GameTime serverUpdateTime = GameTime.second();
    public static GameTime serverToClientUpdateTime = GameTime.second();
    public static GameTime clientUpdateTime = GameTime.quaterSecond();
    public static GameTime clientWaitForUpdateTime = GameTime.seconds((int)2);

    @SubscribeEvent
    public static void onRandomTick(RandomTickEvent.Block event) {
    }

    @SubscribeEvent
    public static void onBlockChanged(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor world = event.getWorld();
        if (GameWorld.isServerSide((LevelReader)world)) {
            WorldData.getData(world).updateSmokeEmitterAt(event.getPos());
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkFullyLoadedEvent event) {
        ServerLevel level = event.getLevel();
        LevelChunk chunk = event.getChunk();
        WorldData data = WorldData.getData((LevelAccessor)level);
        for (BlockPos pos : chunk.m_5928_()) {
            data.addIfEmitter((LevelReader)level, pos);
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        LevelAccessor world = event.getWorld();
        if (world != null && GameWorld.isServerSide((LevelReader)world)) {
            WorldData data = WorldData.getData(world);
            SmokeLocations smokeLocations = data.getSmokeLocations();
            ChunkAccess chunk = event.getChunk();
            ChunkPos chunkPos = chunk.m_7697_();
            Iterator<Map.Entry<BlockPos, Smoke>> iterator = smokeLocations.getEntrySetIterator();
            while (iterator.hasNext()) {
                Map.Entry<BlockPos, Smoke> entry = iterator.next();
                BlockPos smokePos = entry.getKey();
                if (!chunkPos.equals((Object)new ChunkPos(smokePos))) continue;
                smokeLocations.remove(smokePos);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.side.isServer()) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Level world = event.world;
        if (serverUpdateTime.pastIn(world)) {
            WorldData data = WorldData.getData((LevelAccessor)world);
            Iterator<Map.Entry<BlockPos, Smoke>> iterator = data.getSmokeLocations().getEntrySetIterator();
            while (iterator.hasNext()) {
                Map.Entry<BlockPos, Smoke> entry = iterator.next();
                BlockPos pos = entry.getKey();
                Smoke smoke = entry.getValue();
                if (!smoke.getLifeTime().moreThan(serverToClientUpdateTime.getInterval())) continue;
                data.updateSmokeEmitterAt(pos);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Level world = event.player.f_19853_;
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.CLIENT && clientUpdateTime.pastIn(world)) {
            WorldData data = WorldData.getData((LevelAccessor)world);
            SmokeLocations locations = data.getSmokeLocations();
            Iterator<Map.Entry<BlockPos, Smoke>> iterator = locations.getEntrySetIterator();
            while (iterator.hasNext()) {
                Map.Entry<BlockPos, Smoke> entry = iterator.next();
                BlockPos pos = entry.getKey();
                Smoke smoke = entry.getValue();
                double distance = ForgeEntity.getCurPosition((Entity)Minecraft.m_91087_().m_91288_()).distance(Vect3d.from((BlockPos)pos));
                float totalParticlesAmount = locations.getTotalParticlesAmount();
                if (totalParticlesAmount > 0.0f && smoke.hasParticles() && smoke.getLifeTime().lessThan(clientWaitForUpdateTime.getInterval()) && distance <= (double)((Integer)Smoke.maxRenderDistance.get()).intValue() && (((Boolean)Smoke.emitWithoutChimney.get()).booleanValue() || GameWorld.SmokeContainers.isChimney((LevelReader)world, (BlockPos)pos))) {
                    float emissionFactor = locations.getParticlesReductionFactor();
                    float renderFactor = data.getParticlesReductionFactor();
                    IWind wind = GameWorld.getWindAt((Level)world, (BlockPos)pos);
                    float factor = Math.min(emissionFactor, renderFactor);
                    if (((Boolean)Smoke.retroParticles.get()).booleanValue()) {
                        RetroSmokeParticle.generate(world, wind, smoke, pos, factor);
                        continue;
                    }
                    ModernSmokeParticle.generate(world, wind, smoke, pos, factor);
                    continue;
                }
                locations.remove(pos);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        LevelAccessor world = event.getWorld();
        if (GameWorld.isServerSide((LevelReader)world)) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        LevelAccessor world = event.getWorld();
        WorldData.DATA_MAP.remove(world);
    }

    @SubscribeEvent
    public static void onCampfireSmokeSpawn(CampfireSmokeEvent event) {
        if (((Boolean)Smoke.disableVanillaCampfireSmoke.get()).booleanValue()) {
            event.setCanceled(true);
        }
    }
}

