/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.world;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;

public class SmokeLocations {
    protected Map<BlockPos, Smoke> map = new ConcurrentHashMap<BlockPos, Smoke>();
    private float totalParticlesAmount = 0.0f;

    public void add(BlockPos pos, Smoke smoke) {
        Smoke prevSmoke = this.map.put(pos.m_7949_(), smoke);
        if (prevSmoke != null) {
            this.totalParticlesAmount -= prevSmoke.getAmount();
        }
        this.totalParticlesAmount += smoke.getAmount();
    }

    public void clear() {
        this.totalParticlesAmount = 0.0f;
        this.map.clear();
    }

    public void remove(BlockPos pos) {
        Smoke prevSmoke = this.map.remove(pos);
        if (prevSmoke != null) {
            this.totalParticlesAmount -= prevSmoke.getAmount();
        }
    }

    public Iterator<Map.Entry<BlockPos, Smoke>> getEntrySetIterator() {
        return this.map.entrySet().iterator();
    }

    public float getTotalParticlesAmount() {
        return this.totalParticlesAmount;
    }

    public float getParticlesReductionFactor() {
        float factor = 0.0f;
        if (CommonMath.notZero((double)this.totalParticlesAmount)) {
            factor = (float)((Integer)Smoke.maxRenderedParticlesAmount.get()).intValue() / this.totalParticlesAmount;
        }
        return GameBounds.FACTOR.getFloatBounds().enclose(Float.valueOf(factor)).floatValue();
    }

    public Map<BlockPos, Smoke> getMap() {
        return Collections.unmodifiableMap(this.map);
    }

    @Nullable
    public Smoke get(BlockPos pos) {
        return this.map.get(pos);
    }
}

