/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.world;

import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.network.SmokePosMsg;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.endertech.minecraft.mods.adchimneys.world.Events;
import com.endertech.minecraft.mods.adchimneys.world.SmokeLocations;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;

public class WorldData {
    static final Map<LevelAccessor, WorldData> DATA_MAP = new ConcurrentHashMap<LevelAccessor, WorldData>();
    final SmokeLocations smokeLocations = new SmokeLocations();
    final LevelAccessor world;

    public WorldData(LevelAccessor world) {
        this.world = world;
    }

    @Nonnull
    public static WorldData getData(LevelAccessor world) {
        WorldData data = DATA_MAP.get(world);
        if (data == null) {
            data = new WorldData(world);
            DATA_MAP.put(world, data);
        }
        return data;
    }

    public float getParticlesReductionFactor() {
        float factor = 1.0f;
        int particlesCount = GameWorld.getData((LevelAccessor)this.getWorld()).smokeParticlesCount;
        if (particlesCount > (Integer)Smoke.maxRenderedParticlesAmount.get()) {
            factor = (float)((Integer)Smoke.maxRenderedParticlesAmount.get()).intValue() / (float)particlesCount;
        }
        return factor;
    }

    public void addIfEmitter(LevelReader reader, BlockPos pos) {
        AdChimneys.getInstance().emitters.get(reader, pos).ifPresent(emitter -> this.smokeLocations.add(pos, Smoke.getNone()));
    }

    public void updateSmokeEmitterAt(BlockPos emitterPos) {
        if (GameWorld.isClientSide((LevelReader)this.world)) {
            return;
        }
        if (emitterPos instanceof BlockPos.MutableBlockPos) {
            return;
        }
        if (!GameWorld.isBlockLoaded((LevelReader)this.world, (BlockPos)emitterPos)) {
            return;
        }
        Emitter emitter = AdChimneys.getInstance().emitters.get((LevelReader)this.world, emitterPos).orElse(null);
        Smoke emitterSmoke = this.getSmokeLocations().get(emitterPos);
        if (emitter != null) {
            if (emitterSmoke == null || emitterSmoke.getLifeTime().moreThan(Events.serverToClientUpdateTime.getInterval())) {
                Smoke outletSmoke;
                int count;
                emitterSmoke = emitter.getSmoke((LevelReader)this.world, emitterPos, true, true);
                ArrayList<BlockPos> outlets = new ArrayList<BlockPos>();
                int maxOutletsAmount = (int)emitterSmoke.getAmount();
                WorldSearch.VentPipe.PumpFunc addOutlets = (worldIn, posIn, maxAmount) -> {
                    outlets.add(posIn);
                    return 1;
                };
                Predicate<BlockPos> impassablePipe = pos -> !this.isPassablePipe((BlockPos)pos);
                WorldSearch.TileNeighbors neighbors = WorldSearch.TileNeighbors.from((LevelAccessor)this.world, (BlockPos)emitterPos, (Set)emitter.getRelatedBlocks());
                boolean anyChimneyConnected = false;
                List activeVents = neighbors.getActiveVents();
                if (!activeVents.isEmpty()) {
                    count = WorldSearch.VentPipe.pump((LevelAccessor)this.world, (List)activeVents, (int)maxOutletsAmount, GameWorld.SmokeContainers::isChimney, (WorldSearch.VentPipe.PumpFunc)addOutlets);
                    if (count > 0) {
                        anyChimneyConnected = true;
                    }
                    outlets.removeIf(impassablePipe);
                    if (outlets.isEmpty()) {
                        WorldSearch.VentPipe.pump((LevelAccessor)this.world, (List)activeVents, (int)maxOutletsAmount, (w, pos) -> this.isPassablePipe(pos), (WorldSearch.VentPipe.PumpFunc)addOutlets);
                    }
                }
                if (outlets.isEmpty()) {
                    List<BlockPos> topChimneys = WorldData.getTopChimneys(neighbors, emitter.getMaxGapLength());
                    if (!topChimneys.isEmpty()) {
                        anyChimneyConnected = true;
                    }
                    topChimneys.removeIf(impassablePipe);
                    outlets.addAll(topChimneys);
                }
                if (emitter.canEmitAside()) {
                    List sideChimneys = neighbors.getSideChimneys();
                    if (!sideChimneys.isEmpty()) {
                        anyChimneyConnected = true;
                    }
                    sideChimneys.removeIf(impassablePipe);
                    outlets.addAll(sideChimneys);
                    if (outlets.isEmpty()) {
                        count = WorldSearch.VentPipe.pump((LevelAccessor)this.world, (List)neighbors.getPassiveVents(), (int)maxOutletsAmount, GameWorld.SmokeContainers::isChimney, (WorldSearch.VentPipe.PumpFunc)addOutlets);
                        if (count > 0) {
                            anyChimneyConnected = true;
                        }
                        outlets.removeIf(impassablePipe);
                    }
                }
                if (outlets.isEmpty() && (anyChimneyConnected || emitter.emitWithoutChimney())) {
                    for (BlockPos pos2 : neighbors.getAboveBlocks()) {
                        if (!this.isPassablePipe(pos2)) continue;
                        outlets.add(pos2);
                    }
                    if (outlets.isEmpty()) {
                        outlets.add(emitterPos);
                    }
                }
                int outletsCount = Math.min(outlets.size(), maxOutletsAmount);
                this.getSmokeLocations().add(emitterPos, emitterSmoke);
                if (outletsCount > 0 && (outletSmoke = emitterSmoke.devideInto(outletsCount)).hasParticles()) {
                    int count2 = 1;
                    for (BlockPos pos3 : outlets) {
                        if (count2 <= outletsCount) {
                            if (this.world instanceof ServerLevelAccessor) {
                                new SmokePosMsg(pos3, outletSmoke).sendToAllAround((ServerLevelAccessor)this.world, pos3, (Integer)Smoke.maxRenderDistance.get());
                            }
                            ++count2;
                            continue;
                        }
                        break;
                    }
                }
            }
        } else if (emitterSmoke != null) {
            this.getSmokeLocations().remove(emitterPos);
        }
    }

    protected boolean isPassablePipe(BlockPos startPos) {
        if (GameWorld.SmokeContainers.isChimney((LevelReader)this.world, (BlockPos)startPos)) {
            startPos = GameWorld.SmokeContainers.getTopmostChimney((LevelReader)this.world, (BlockPos)startPos).m_7494_();
        }
        for (Direction direction : Direction.values()) {
            if (direction == Direction.DOWN || !Smoke.canPassThrough((BlockGetter)this.world, startPos, Direction.DOWN, direction) || !Smoke.canPassThrough((BlockGetter)this.world, startPos.m_142300_(direction), direction.m_122424_(), Direction.UP)) continue;
            return true;
        }
        return false;
    }

    protected static List<BlockPos> getTopChimneys(WorldSearch.TileNeighbors neighbors, int maxGapLength) {
        LevelAccessor world = neighbors.getWorld();
        ArrayList<BlockPos> chimneys = new ArrayList<BlockPos>();
        block0: for (BlockPos startPos : neighbors.getAboveBlocks()) {
            for (int i = 0; i <= maxGapLength; ++i) {
                BlockPos pos = startPos.m_6630_(i);
                if (GameWorld.SmokeContainers.isChimney((LevelReader)world, (BlockPos)pos)) {
                    chimneys.add(pos);
                    continue block0;
                }
                if (!GameWorld.isAirBlock((LevelReader)world, (BlockPos)pos)) continue block0;
            }
        }
        return chimneys;
    }

    public LevelAccessor getWorld() {
        return this.world;
    }

    public SmokeLocations getSmokeLocations() {
        return this.smokeLocations;
    }
}

