/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.items.EquipmentItem;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public abstract class GlassMeter
extends EquipmentItem {
    protected final Map<ItemStack, Entity> carriers = new ConcurrentHashMap<ItemStack, Entity>();
    private final ChatFormatting textFormatting;

    public GlassMeter(AbstractForgeMod mod, UnitConfig config, String name, Item.Properties props, int durability, EquipmentSlot equipSlot, ChatFormatting textFormating) {
        super(mod, config, name, props, durability, UnitId.from("#forge:glass_panes"), equipSlot, SoundEvents.f_11985_);
        this.textFormatting = textFormating;
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getPlayer();
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof GlassMeter && !player.f_20911_) {
            ((GlassMeter)item).onHit(stack, player);
        }
    }

    protected void onHit(ItemStack stack, Player player) {
        if (player instanceof ServerPlayer && GlassMeter.notBroken(stack)) {
            GlassMeter.damageItem(1, stack, false, player, damager -> {
                player.m_21166_(EquipmentSlot.MAINHAND);
                player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 1.0f);
            });
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        this.onHit(stack, player);
        return super.onLeftClickEntity(stack, player, entity);
    }

    public boolean onDroppedByPlayer(ItemStack stack, Player player) {
        this.onHit(stack, player);
        return super.onDroppedByPlayer(stack, player);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public ChatFormatting getTextFormatting() {
        return this.textFormatting;
    }

    public Component m_7626_(ItemStack stack) {
        return new TranslatableComponent(this.m_5671_(stack)).m_130940_(this.getTextFormatting());
    }
}

