/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.math;

import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import net.minecraft.world.level.Level;

public class GameTime {
    public static final int MILLISECONDS_IN_SERVER_TICK = 50;
    public static final CommonTime.IMessure SERVER_TICKS = () -> 50L;
    public static final int TICKS_PER_SECOND = 20;
    protected final CommonTime.Interval interval;
    protected final long ticks;
    protected final int shift;

    public static CommonTime.Interval fromServerTicks(long ticks) {
        return CommonTime.Interval.of(SERVER_TICKS, ticks);
    }

    public static long inServerTicks(CommonTime.Interval time) {
        long ticks = (long)time.in(SERVER_TICKS);
        return ticks;
    }

    protected GameTime(long ticks) {
        this.interval = GameTime.fromServerTicks(ticks);
        this.ticks = ticks;
        this.shift = CommonMath.RANDOM.nextInt();
    }

    public static GameTime second() {
        return GameTime.seconds(1);
    }

    public static GameTime halfSecond() {
        return GameTime.ticks(10L);
    }

    public static GameTime quaterSecond() {
        return GameTime.ticks(5L);
    }

    public static GameTime seconds(int seconds) {
        return GameTime.ticks((long)seconds * 20L);
    }

    public static GameTime seconds(float seconds) {
        int ticks = Math.round(seconds * 20.0f);
        return GameTime.ticks(ticks);
    }

    public static GameTime time(CommonTime.Interval time) {
        return GameTime.ticks(GameTime.inServerTicks(time));
    }

    public static GameTime ticks(long ticks) {
        return new GameTime(ticks);
    }

    public boolean pastIn(Level world) {
        if (this.ticks == 0L) {
            return true;
        }
        long time = world.m_46467_();
        long result = (time += (long)this.shift) % this.ticks;
        return result == 0L;
    }

    public CommonTime.Interval getInterval() {
        return this.interval;
    }

    public GameTime mult(double factor) {
        return GameTime.time(this.getInterval().mult(factor));
    }
}

