/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.core.IPostInit;
import com.endertech.minecraft.forge.units.IForgeUnit;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class UnitsInit<T>
implements IPostInit {
    private final AbstractForgeMod mod;
    private final Set<T> units = new HashSet<T>();

    public UnitsInit(AbstractForgeMod mod) {
        this.mod = mod;
        mod.runDuringPostInit(this::onPostInit);
    }

    public <U extends T> U addNew(U unit) {
        this.units.add(unit);
        if (unit instanceof IHaveConfig) {
            ((IHaveConfig)unit).saveConfig();
        }
        return unit;
    }

    protected void remove(T unit) {
        this.units.remove(unit);
    }

    protected void removeAll() {
        this.units.clear();
    }

    @Override
    public void onPostInit() {
        for (T unit : this.units) {
            if (!(unit instanceof IPostInit)) continue;
            ((IPostInit)unit).onPostInit();
        }
    }

    public Set<T> getAll() {
        return Collections.unmodifiableSet(this.units);
    }

    public AbstractForgeMod getMod() {
        return this.mod;
    }

    public static Path getConfigsDir(AbstractForgeMod mod, Class<?> clazz) {
        return mod.getConfigsDir().resolve(clazz.getSimpleName());
    }

    public Path getConfigsDir() {
        return UnitsInit.getConfigsDir(this.getMod(), this.getClass());
    }

    public UnitConfig createConfigFor(Class<? extends T> clazz) {
        return UnitConfig.in(this.getConfigsDir(), IForgeUnit.getClassRegName(clazz));
    }
}

