/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeId {
    public static final BiomeId EMPTY = new BiomeId(Optional.empty());
    protected final Optional<ResourceKey<Biome>> key;

    protected BiomeId(Optional<ResourceKey<Biome>> registryKey) {
        this.key = registryKey;
    }

    public static BiomeId from(ResourceKey<Biome> registryKey) {
        return new BiomeId(Optional.of(registryKey));
    }

    public static BiomeId from(LevelAccessor world, BlockPos pos) {
        return new BiomeId(world.m_45837_(pos));
    }

    public static BiomeId from(ResourceLocation location) {
        Optional<ResourceKey<Biome>> registryKey = ForgeRegistries.BIOMES.getEntries().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().equals((Object)location)).findFirst().map(entry -> (ResourceKey)entry.getKey());
        return new BiomeId(registryKey);
    }

    public boolean isEmpty() {
        return !this.getKey().isPresent();
    }

    public Optional<ResourceKey<Biome>> getKey() {
        return this.key;
    }

    public Optional<ResourceLocation> getResourceLocation() {
        return this.getKey().map(key -> key.m_135782_());
    }

    public Optional<Biome> getBiome() {
        return this.getResourceLocation().map(key -> (Biome)ForgeRegistries.BIOMES.getValue(key));
    }

    public String toString() {
        return this.getResourceLocation().map(loc -> loc.toString()).orElse(super.toString());
    }

    public boolean equals(Object obj) {
        if (obj instanceof BiomeId) {
            return Objects.equals(this.getKey(), ((BiomeId)obj).getKey());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getKey());
    }
}

