/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.minecraft.forge.world.GameWorld;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class WorldSearch {

    public static class Column
    extends BlockChain {
        private static final List<Direction> DIRECTIONS = GameWorld.Directions.of().up().down().toList();
        private final BlockState validState;
        private BlockPos top;
        private BlockPos bottom;

        public static Column from(LevelAccessor world, BlockPos pos) {
            Column column = new Column(world, pos, world.m_141928_());
            column.build();
            return column;
        }

        protected Column(LevelAccessor world, BlockPos pos, int maxLength) {
            super(world, pos, maxLength);
            this.validState = world.m_8055_(pos);
            this.top = pos;
            this.bottom = pos;
        }

        @Override
        protected Collection<Direction> getDirections() {
            return DIRECTIONS;
        }

        @Override
        protected boolean isValidPath(BlockPos pos) {
            return this.isValidBlock(pos);
        }

        @Override
        protected boolean isValidBlock(BlockPos pos) {
            BlockState state = this.world.m_8055_(pos);
            return this.validState.m_60734_() == state.m_60734_();
        }

        @Override
        protected boolean onValidFound(BlockPos pos) {
            if (pos.m_123342_() > this.top.m_123342_()) {
                this.top = pos;
            }
            if (pos.m_123342_() < this.bottom.m_123342_()) {
                this.bottom = pos;
            }
            return true;
        }

        public BlockPos getTop() {
            return this.top;
        }

        public BlockPos getBottom() {
            return this.bottom;
        }
    }

    public static abstract class VentPipe
    extends BlockChain {
        public static final BlockChain.BlockFunc VALID_CHIMNEY_BLOCK = (world, pos) -> GameWorld.SmokeContainers.isChimney((LevelReader)world, pos);
        public static final BlockChain.BlockFunc VALID_CONDUCTOR_BLOCK = (world, pos) -> GameWorld.SmokeContainers.isVent((LevelReader)world, pos);
        private static List<Direction> DIRECTIONS = Lists.newArrayList((Object[])GameWorld.Directions.CLOCKWISE_HORIZONTALS);
        protected final int pumpsRequired;
        protected int pumpsCount;

        public VentPipe(LevelAccessor world, BlockPos startPos, int pumpsRequired) {
            super(world, startPos, (Integer)GameWorld.SmokeContainers.maxVentPipeLength.get());
            this.pumpsRequired = pumpsRequired;
        }

        public static int pump(LevelAccessor world, List<BlockPos> startPositions, int pumpsRequired, BlockChain.BlockFunc validOutlet, PumpFunc onPump) {
            return VentPipe.pump(world, startPositions, pumpsRequired, VALID_CONDUCTOR_BLOCK, validOutlet, onPump);
        }

        public static int pump(LevelAccessor world, List<BlockPos> startPositions, int pumpsRequired, final BlockChain.BlockFunc validVent, final BlockChain.BlockFunc validOutlet, final PumpFunc onPump) {
            int count = 0;
            if (pumpsRequired <= 0) {
                return count;
            }
            ArrayList<1> ventPipes = new ArrayList<1>();
            block0: for (BlockPos pos : startPositions) {
                for (VentPipe ventPipe : ventPipes) {
                    if (!ventPipe.getChain().contains(pos)) continue;
                    continue block0;
                }
                VentPipe pipe = new VentPipe(world, pos, pumpsRequired){

                    @Override
                    protected boolean isValidPath(BlockPos pos) {
                        return validVent.apply(this.getWorld(), pos);
                    }

                    @Override
                    protected boolean isValidBlock(BlockPos pos) {
                        return validOutlet.apply(this.getWorld(), pos);
                    }

                    @Override
                    protected int onPump(BlockPos pos, int maxAmount) {
                        return onPump.apply(this.getWorld(), pos, maxAmount);
                    }
                };
                ventPipes.add(pipe);
                if ((count += pipe.pump().getPumpsCount()) < pumpsRequired) continue;
                return count;
            }
            return count;
        }

        public VentPipe pump() {
            this.pumpsCount = 0;
            super.build();
            return this;
        }

        @Override
        protected Collection<Direction> getDirections() {
            return DIRECTIONS;
        }

        @Override
        protected boolean isValidPath(BlockPos pos) {
            return GameWorld.SmokeContainers.isVent((LevelReader)this.world, pos);
        }

        @Override
        protected boolean onValidFound(BlockPos pos) {
            if (this.pumpsCount >= this.pumpsRequired) {
                return false;
            }
            this.pumpsCount += this.onPump(pos, this.pumpsRequired - this.pumpsCount);
            return this.pumpsCount < this.pumpsRequired;
        }

        public int getPumpsCount() {
            return this.pumpsCount;
        }

        protected abstract int onPump(BlockPos var1, int var2);

        @FunctionalInterface
        public static interface PumpFunc {
            public int apply(LevelAccessor var1, BlockPos var2, int var3);
        }
    }

    public static class TileNeighbors
    extends BlockChain {
        protected final List<BlockPos> aboveBlocks = new ArrayList<BlockPos>();
        protected final List<BlockPos> sideBlocks = new ArrayList<BlockPos>();
        protected final List<BlockPos> underBlocks = new ArrayList<BlockPos>();
        protected final Set<BlockState> relatedBlocks;
        protected BlockState masterState;

        protected TileNeighbors(LevelAccessor world, BlockPos startPos, int maxBlocksInTile, Set<BlockState> relatedBlocks) {
            super(world, startPos, maxBlocksInTile);
            this.relatedBlocks = relatedBlocks;
        }

        public static TileNeighbors from(BlockEntity tile, Set<BlockState> relatedBlocks) {
            TileNeighbors neighbours = new TileNeighbors((LevelAccessor)tile.m_58904_(), tile.m_58899_(), (Integer)GameWorld.SmokeContainers.maxBlocksInMultiblock.get(), relatedBlocks);
            neighbours.build();
            return neighbours;
        }

        public static TileNeighbors from(LevelAccessor world, BlockPos startPos, Set<BlockState> relatedBlocks) {
            TileNeighbors neighbours = new TileNeighbors(world, startPos, (Integer)GameWorld.SmokeContainers.maxBlocksInMultiblock.get(), relatedBlocks);
            neighbours.build();
            return neighbours;
        }

        @Override
        public void build() {
            this.masterState = this.world.m_8055_(this.startPos);
            this.aboveBlocks.clear();
            this.sideBlocks.clear();
            this.underBlocks.clear();
            super.build();
        }

        public boolean isMultiblockHollow(BlockPos pos) {
            int minSideLen = 3;
            int maxSideLen = this.maxLength / 9;
            if (maxSideLen < 3) {
                return false;
            }
            int maxHollowLen = maxSideLen - 2;
            block0: for (Direction facing : this.getDirections()) {
                for (int n = 1; n <= maxHollowLen; ++n) {
                    if (this.getChain().contains(pos.m_5484_(facing, n))) continue block0;
                }
                return false;
            }
            return true;
        }

        @Override
        protected boolean isValidPath(BlockPos pos) {
            if (this.lastUsedDirection == null) {
                return true;
            }
            BlockState state = this.world.m_8055_(pos);
            if (this.relatedBlocks.contains(state)) {
                return true;
            }
            BlockEntity tile = this.world.m_7702_(pos);
            return tile != null && this.masterState == state;
        }

        @Override
        protected boolean isValidBlock(BlockPos pos) {
            return !this.isValidPath(pos);
        }

        @Override
        protected boolean onValidFound(BlockPos pos) {
            if (this.lastUsedDirection != null) {
                switch (this.lastUsedDirection) {
                    case DOWN: {
                        this.underBlocks.add(pos);
                        break;
                    }
                    case UP: {
                        this.aboveBlocks.add(pos);
                        break;
                    }
                    default: {
                        this.sideBlocks.add(pos);
                    }
                }
            }
            return true;
        }

        public List<BlockPos> getAboveBlocks() {
            return this.aboveBlocks;
        }

        public List<BlockPos> getSideBlocks() {
            return this.sideBlocks;
        }

        public List<BlockPos> getUnderBlocks() {
            return this.underBlocks;
        }

        public List<BlockPos> getActiveVents() {
            ArrayList<BlockPos> activeVents = new ArrayList<BlockPos>();
            for (BlockPos pos : this.getUnderBlocks()) {
                if (GameWorld.SmokeContainers.isChimney((LevelReader)this.getWorld(), pos)) {
                    pos = GameWorld.SmokeContainers.getBottommostChimney((LevelReader)this.getWorld(), pos).m_7495_();
                }
                if (!GameWorld.SmokeContainers.isActivePump((LevelReader)this.getWorld(), pos)) continue;
                activeVents.addAll(GameWorld.SmokeContainers.getVentsAround((LevelReader)this.getWorld(), pos));
            }
            return activeVents;
        }

        public List<BlockPos> getTopChimneys() {
            ArrayList<BlockPos> chimneys = new ArrayList<BlockPos>();
            for (BlockPos pos : this.getAboveBlocks()) {
                if (!GameWorld.SmokeContainers.isChimney((LevelReader)this.getWorld(), pos)) continue;
                chimneys.add(pos);
            }
            return chimneys;
        }

        public List<BlockPos> getSideChimneys() {
            ArrayList<BlockPos> chimneys = new ArrayList<BlockPos>();
            for (BlockPos pos : this.getSideBlocks()) {
                if (!GameWorld.SmokeContainers.isChimney((LevelReader)this.getWorld(), pos)) continue;
                chimneys.add(pos);
            }
            return chimneys;
        }

        public List<BlockPos> getPassiveVents() {
            ArrayList<BlockPos> passiveVents = new ArrayList<BlockPos>();
            for (BlockPos pos : this.getSideBlocks()) {
                if (!GameWorld.SmokeContainers.isVent((LevelReader)this.getWorld(), pos)) continue;
                passiveVents.add(pos);
            }
            return passiveVents;
        }
    }

    public static abstract class BlockChain {
        private static final List<Direction> DIRECTIONS = ImmutableList.copyOf((Object[])Direction.values());
        protected final LevelAccessor world;
        protected final BlockPos startPos;
        protected final List<BlockPos> blockChain;
        protected final List<BlockPos> foundBlocks;
        protected final int maxLength;
        protected boolean breakSearch = false;
        @Nullable
        protected Direction lastUsedDirection = null;

        public BlockChain(LevelAccessor world, BlockPos startPos, int maxLength) {
            this.world = world;
            this.startPos = startPos;
            this.maxLength = maxLength;
            this.blockChain = new ArrayList<BlockPos>();
            this.foundBlocks = new ArrayList<BlockPos>();
        }

        public static BlockChain create(LevelAccessor world, BlockPos startPos, int maxLength, final BlockFunc validPath, final BlockFunc validBlock, final BlockFunc validFound) {
            BlockChain chain = new BlockChain(world, startPos, maxLength){

                @Override
                protected boolean onValidFound(BlockPos pos) {
                    return validFound.apply(this.world, pos);
                }

                @Override
                protected boolean isValidPath(BlockPos pos) {
                    return validPath.apply(this.world, pos);
                }

                @Override
                protected boolean isValidBlock(BlockPos pos) {
                    return validBlock.apply(this.world, pos);
                }
            };
            chain.build();
            return chain;
        }

        protected abstract boolean isValidPath(BlockPos var1);

        protected abstract boolean isValidBlock(BlockPos var1);

        protected abstract boolean onValidFound(BlockPos var1);

        public void build() {
            this.lastUsedDirection = null;
            this.breakSearch = false;
            this.blockChain.clear();
            this.foundBlocks.clear();
            this.search();
        }

        protected Collection<Direction> getDirections() {
            return DIRECTIONS;
        }

        public BlockPos getStartPos() {
            return this.startPos;
        }

        public LevelAccessor getWorld() {
            return this.world;
        }

        public List<BlockPos> getChain() {
            return this.blockChain;
        }

        public List<BlockPos> getFound() {
            return this.foundBlocks;
        }

        public int length() {
            return this.blockChain.size();
        }

        protected void search() {
            ArrayDeque<StackEntry> stack = new ArrayDeque<StackEntry>();
            stack.push(new StackEntry(this.startPos));
            while (!stack.isEmpty()) {
                if (this.length() >= this.maxLength) {
                    return;
                }
                StackEntry entry = (StackEntry)stack.peek();
                BlockPos pos = entry.getPos();
                if (!entry.isChecked()) {
                    if (!GameWorld.isBlockLoaded((LevelReader)this.world, pos)) {
                        stack.pop();
                        continue;
                    }
                    if (this.isValidBlock(pos) && !this.foundBlocks.contains(pos)) {
                        this.foundBlocks.add(pos);
                        boolean bl = this.breakSearch = !this.onValidFound(pos);
                    }
                    if (!this.isValidPath(pos) || this.blockChain.contains(pos)) {
                        stack.pop();
                        continue;
                    }
                    this.blockChain.add(pos);
                    entry.setChecked();
                }
                if (this.breakSearch) {
                    return;
                }
                Direction direction = entry.getNextDirection().orElse(null);
                if (direction != null) {
                    stack.push(new StackEntry(pos.m_142300_(direction)));
                    this.lastUsedDirection = direction;
                    continue;
                }
                stack.pop();
            }
        }

        @FunctionalInterface
        public static interface BlockFunc {
            public boolean apply(LevelAccessor var1, BlockPos var2);
        }

        protected class StackEntry {
            protected final BlockPos pos;
            protected Deque<Direction> directions;
            protected boolean checked = false;

            public StackEntry(BlockPos pos) {
                this.pos = pos;
            }

            public BlockPos getPos() {
                return this.pos;
            }

            public Optional<Direction> getNextDirection() {
                if (this.directions == null) {
                    this.directions = new ArrayDeque<Direction>(BlockChain.this.getDirections());
                }
                if (this.directions.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(this.directions.pop());
            }

            public boolean isChecked() {
                return this.checked;
            }

            public void setChecked() {
                this.checked = true;
            }
        }
    }
}

