/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.IPole;
import com.endertech.minecraft.forge.blocks.IPollutant;
import com.endertech.minecraft.forge.world.GameWorld;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.antlr.v4.runtime.misc.OrderedHashSet;

public class WorldSearch {

    public static abstract class VertCylinder
    extends BlockChain {
        protected final IntBounds heightBounds;
        protected final int maxRadius;

        protected VertCylinder(LevelAccessor level, BlockPos startPos, IntBounds heightBounds, int maxRadius) {
            super(level, startPos, Mth.m_14167_((float)((float)Math.PI * (float)Mth.m_144944_((int)maxRadius) * (float)(heightBounds.length() + 1))));
            this.heightBounds = heightBounds;
            this.maxRadius = maxRadius;
        }

        @Override
        protected Collection<Direction> getDirections() {
            return GameWorld.Directions.of().all().shuffle().toList();
        }

        @Override
        protected boolean isOutsideBounds(BlockPos pos) {
            if (!this.heightBounds.encloses(pos.m_123342_())) {
                return true;
            }
            int dx = pos.m_123341_() - this.startPos.m_123341_();
            int dz = pos.m_123343_() - this.startPos.m_123343_();
            if (Mth.m_144944_((int)dx) + Mth.m_144944_((int)dz) > Mth.m_144944_((int)this.maxRadius)) {
                return true;
            }
            return super.isOutsideBounds(pos);
        }
    }

    public static class Column
    extends BlockChain {
        private static final List<Direction> DIRECTIONS = GameWorld.Directions.of().up().down().toList();
        private final BlockState validState;
        private BlockPos top;
        private BlockPos bottom;

        public static Column from(LevelAccessor world, BlockPos pos) {
            Column column = new Column(world, pos, world.m_141928_());
            column.build();
            return column;
        }

        protected Column(LevelAccessor world, BlockPos pos, int maxLength) {
            super(world, pos, maxLength);
            this.validState = world.m_8055_(pos);
            this.top = pos;
            this.bottom = pos;
        }

        @Override
        protected Collection<Direction> getDirections() {
            return DIRECTIONS;
        }

        @Override
        protected boolean isValidPath(BlockPos pos) {
            return this.isValidBlock(pos);
        }

        @Override
        protected boolean isValidBlock(BlockPos pos) {
            BlockState state = this.world.m_8055_(pos);
            return this.validState.m_60734_() == state.m_60734_();
        }

        @Override
        protected boolean onValidFound(BlockPos pos) {
            if (pos.m_123342_() > this.top.m_123342_()) {
                this.top = pos;
            }
            if (pos.m_123342_() < this.bottom.m_123342_()) {
                this.bottom = pos;
            }
            return true;
        }

        public BlockPos getTop() {
            return this.top;
        }

        public BlockPos getBottom() {
            return this.bottom;
        }
    }

    public static abstract class VentPipe
    extends BlockChain {
        protected int count = 0;

        protected VentPipe(LevelAccessor level, BlockPos startPos) {
            super(level, startPos, (Integer)GameWorld.SmokeContainers.maxVentPipeLength.get() + 1);
        }

        public int getCount() {
            return this.count;
        }

        @Override
        protected Collection<Direction> getDirections() {
            return GameWorld.Directions.of().horizontals().shuffle().toList();
        }

        @Override
        protected boolean isValidPath(BlockPos pos) {
            return GameWorld.SmokeContainers.isVent((LevelReader)this.getWorld(), pos);
        }

        @Override
        public void build() {
            this.count = 0;
            super.build();
        }

        public static int pump(final LevelAccessor level, List<BlockPos> startPositions, int maxAmount, final BlockChain.BlockFunc validOutlet, final PumpFunc onPump) {
            int count = 0;
            if (count >= maxAmount) {
                return count;
            }
            ArrayList<1> ventPipes = new ArrayList<1>();
            block0: for (BlockPos pos : startPositions) {
                for (VentPipe ventPipe : ventPipes) {
                    if (!ventPipe.getChain().contains(pos)) continue;
                    continue block0;
                }
                Output pipe = new Output(level, pos, maxAmount){

                    @Override
                    protected boolean isValidOutlet(BlockPos pos) {
                        return validOutlet.apply(level, pos);
                    }

                    @Override
                    protected int onPump(BlockPos pos, int max) {
                        return onPump.apply(level, pos, max);
                    }
                };
                pipe.build();
                ventPipes.add(pipe);
                if ((count += pipe.getCount()) < maxAmount) continue;
                return count;
            }
            return count;
        }

        public static int suck(LevelAccessor level, BlockPos pumpPos) {
            return VentPipe.suck(level, pumpPos, pumpPos);
        }

        public static int suck(LevelAccessor level, BlockPos startPos, BlockPos pumpPos) {
            Input pipe = new Input(level, startPos, pumpPos);
            pipe.build();
            return pipe.getCount();
        }

        @FunctionalInterface
        public static interface PumpFunc {
            public int apply(LevelAccessor var1, BlockPos var2, int var3);
        }

        public static abstract class Output
        extends VentPipe {
            protected final int maxAmount;

            protected Output(LevelAccessor level, BlockPos startPos, int maxAmount) {
                super(level, startPos);
                this.maxAmount = maxAmount;
            }

            @Override
            protected boolean isValidBlock(BlockPos pos) {
                if (this.lastUsedDirection != null && this.getWorld().m_8055_(pos).m_60783_((BlockGetter)this.getWorld(), pos, this.lastUsedDirection.m_122424_())) {
                    return false;
                }
                return this.isValidOutlet(pos);
            }

            @Override
            protected boolean onValidFound(BlockPos pos) {
                if (this.count >= this.maxAmount) {
                    return false;
                }
                this.count += this.onPump(pos, this.maxAmount - this.count);
                return this.count < this.maxAmount;
            }

            protected abstract boolean isValidOutlet(BlockPos var1);

            protected abstract int onPump(BlockPos var1, int var2);
        }

        public static class Input
        extends VentPipe {
            protected final BlockPos pumpPos;

            protected Input(LevelAccessor level, BlockPos startPos, BlockPos pumpPos) {
                super(level, startPos);
                this.pumpPos = pumpPos;
            }

            @Override
            protected boolean isValidPath(BlockPos pos) {
                return super.isValidPath(pos) || this.getStartPos().equals((Object)pos) && GameWorld.SmokeContainers.isPump((LevelReader)this.getWorld(), pos);
            }

            @Override
            protected boolean isValidBlock(BlockPos pos) {
                return GameWorld.SmokeContainers.isVentOrPump((LevelReader)this.getWorld(), pos);
            }

            @Override
            protected boolean onValidFound(BlockPos foundPos) {
                ArrayList<Direction> directions = new ArrayList<Direction>();
                directions.add(Direction.DOWN);
                directions.addAll(GameWorld.Directions.of().horizontals().shuffle().toList());
                LevelAccessor level = this.getWorld();
                block0: for (Direction facing : directions) {
                    for (int dist = 1; !(dist > (Integer)GameWorld.SmokeContainers.ventReachDistance.get() || level.m_8055_(foundPos).m_60783_((BlockGetter)level, foundPos, facing) || facing == Direction.DOWN && dist > 1); ++dist) {
                        IPollutant pollutant;
                        BlockPos pos = foundPos.m_5484_(facing, dist);
                        BlockState state = level.m_8055_(pos);
                        if (state.m_60795_()) continue;
                        if (state.m_60783_((BlockGetter)level, pos, facing.m_122424_())) continue block0;
                        Block block = state.m_60734_();
                        if (block instanceof IPollutant && (pollutant = (IPollutant)block).getPollutantType() == IPollutant.Type.AIR) {
                            List<BlockPos> pumps = List.of(this.pumpPos);
                            int maxAmount = pollutant.getCarriedPollutionAmount(state);
                            this.count = GameWorld.SmokeContainers.pumpPollutionThrough(pumps, level, pollutant, maxAmount);
                            if (this.count > 0) {
                                pollutant.spend(level, pos, this.count);
                            }
                            return false;
                        }
                        if (state.m_60783_((BlockGetter)level, pos, facing)) continue block0;
                    }
                }
                return true;
            }
        }
    }

    public static class TileNeighbors
    extends BlockChain {
        protected final List<BlockPos> aboveBlocks = new ArrayList<BlockPos>();
        protected final List<BlockPos> sideBlocks = new ArrayList<BlockPos>();
        protected final List<BlockPos> underBlocks = new ArrayList<BlockPos>();
        protected final Set<BlockState> relatedBlocks;
        protected BlockState masterState;

        protected TileNeighbors(LevelAccessor world, BlockPos startPos, int maxBlocksInTile, Set<BlockState> relatedBlocks) {
            super(world, startPos, maxBlocksInTile);
            this.relatedBlocks = relatedBlocks;
        }

        public static TileNeighbors from(BlockEntity tile, Set<BlockState> relatedBlocks) {
            TileNeighbors neighbours = new TileNeighbors((LevelAccessor)tile.m_58904_(), tile.m_58899_(), (Integer)GameWorld.SmokeContainers.maxBlocksInMultiblock.get(), relatedBlocks);
            neighbours.build();
            return neighbours;
        }

        public static TileNeighbors from(LevelAccessor world, BlockPos startPos, Set<BlockState> relatedBlocks) {
            TileNeighbors neighbours = new TileNeighbors(world, startPos, (Integer)GameWorld.SmokeContainers.maxBlocksInMultiblock.get(), relatedBlocks);
            neighbours.build();
            return neighbours;
        }

        @Override
        public void build() {
            this.masterState = this.world.m_8055_(this.startPos);
            this.aboveBlocks.clear();
            this.sideBlocks.clear();
            this.underBlocks.clear();
            super.build();
        }

        public boolean isMultiblockHollow(BlockPos pos) {
            int minSideLen = 3;
            int maxSideLen = this.maxLength / 9;
            if (maxSideLen < 3) {
                return false;
            }
            int maxHollowLen = maxSideLen - 2;
            block0: for (Direction facing : this.getDirections()) {
                for (int n = 1; n <= maxHollowLen; ++n) {
                    if (this.getChain().contains(pos.m_5484_(facing, n))) continue block0;
                }
                return false;
            }
            return true;
        }

        @Override
        protected boolean isValidPath(BlockPos pos) {
            if (this.lastUsedDirection == null) {
                return true;
            }
            BlockState state = this.world.m_8055_(pos);
            if (this.relatedBlocks.contains(state)) {
                return true;
            }
            BlockEntity tile = this.world.m_7702_(pos);
            return tile != null && this.masterState == state;
        }

        @Override
        protected boolean isValidBlock(BlockPos pos) {
            return !this.isValidPath(pos);
        }

        @Override
        protected boolean onValidFound(BlockPos pos) {
            if (this.lastUsedDirection != null) {
                switch (this.lastUsedDirection) {
                    case DOWN: {
                        this.underBlocks.add(pos);
                        break;
                    }
                    case UP: {
                        this.aboveBlocks.add(pos);
                        break;
                    }
                    default: {
                        this.sideBlocks.add(pos);
                    }
                }
            }
            return true;
        }

        public List<BlockPos> getAboveBlocks() {
            return this.aboveBlocks;
        }

        public List<BlockPos> getSideBlocks() {
            return this.sideBlocks;
        }

        public List<BlockPos> getUnderBlocks() {
            return this.underBlocks;
        }

        public List<BlockPos> getTopActivePumps(int maxGapLength) {
            ArrayList<BlockPos> startPositions = new ArrayList<BlockPos>();
            startPositions.addAll(this.getTopPipeOutlets(true, GameWorld.SmokeContainers::isVentOrPumpOrChimney));
            startPositions.addAll(this.getAboveBlocks(GameWorld.SmokeContainers::isVentOrPumpOrChimney, maxGapLength));
            return GameWorld.SmokeContainers.getClosestActiveExhaustPumps(this.getWorld(), startPositions);
        }

        public List<BlockPos> getSideActivePumps() {
            return GameWorld.SmokeContainers.getClosestActiveExhaustPumps(this.getWorld(), GameWorld.SmokeContainers.getOnly((LevelReader)this.getWorld(), this.getSideBlocks(), GameWorld.SmokeContainers::isVentOrPump));
        }

        public List<BlockPos> getBottomActivePumps() {
            return this.getUnderBlocks().stream().map(pos -> GameWorld.SmokeContainers.getConnectedActiveReversedPump((LevelReader)this.getWorld(), pos)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        }

        public List<BlockPos> getAboveBlocks(BiPredicate<LevelReader, BlockPos> filter, int maxGapLength) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            block0: for (BlockPos startPos : this.getAboveBlocks()) {
                for (int i = 0; i <= maxGapLength; ++i) {
                    BlockPos pos = startPos.m_6630_(i);
                    if (filter.test((LevelReader)this.getWorld(), pos)) {
                        blocks.add(pos);
                        continue block0;
                    }
                    if (!GameWorld.SmokeContainers.canPassThrough((BlockGetter)this.getWorld(), pos, Direction.DOWN, Direction.UP)) continue block0;
                }
            }
            return blocks;
        }

        public List<BlockPos> getTopPassableChimneys(int maxGapLength) {
            return this.getAboveBlocks((lev, pos) -> GameWorld.SmokeContainers.isChimney(lev, pos) && GameWorld.SmokeContainers.hasWayOut(lev, pos), maxGapLength);
        }

        public List<BlockPos> getTopPipeOutlets(boolean onlyWithHopper, BiPredicate<LevelReader, BlockPos> filter) {
            LevelAccessor level = this.getWorld();
            return this.getAboveBlocks(GameWorld.SmokeContainers::isPipe, 0).stream().map(pos -> GameWorld.SmokeContainers.getTopmostPipe((LevelReader)level, pos)).map(pos -> GameWorld.SmokeContainers.getConnectedHopper((LevelReader)level, pos).orElse((BlockPos)pos)).filter(pos -> !onlyWithHopper || GameWorld.SmokeContainers.isHopper((LevelReader)level, pos)).map(pos -> pos.m_7494_()).filter(pos -> filter.test((LevelReader)level, (BlockPos)pos)).collect(Collectors.toList());
        }

        @Deprecated
        public List<BlockPos> getTopChimneys() {
            ArrayList<BlockPos> chimneys = new ArrayList<BlockPos>();
            for (BlockPos pos : this.getAboveBlocks()) {
                if (!GameWorld.SmokeContainers.isChimney((LevelReader)this.getWorld(), pos)) continue;
                chimneys.add(pos);
            }
            return chimneys;
        }

        @Deprecated
        public List<BlockPos> getSideChimneys() {
            ArrayList<BlockPos> chimneys = new ArrayList<BlockPos>();
            for (BlockPos pos : this.getSideBlocks()) {
                if (!GameWorld.SmokeContainers.isChimney((LevelReader)this.getWorld(), pos)) continue;
                chimneys.add(pos);
            }
            return chimneys;
        }

        @Deprecated
        public List<BlockPos> getPassiveVents() {
            ArrayList<BlockPos> passiveVents = new ArrayList<BlockPos>();
            for (BlockPos pos : this.getSideBlocks()) {
                if (!GameWorld.SmokeContainers.isVent((LevelReader)this.getWorld(), pos)) continue;
                passiveVents.add(pos);
            }
            return passiveVents;
        }

        @Deprecated
        public List<BlockPos> getActivePumps() {
            LevelAccessor level = this.getWorld();
            ArrayList<BlockPos> activePumps = new ArrayList<BlockPos>();
            for (BlockPos pos : this.getUnderBlocks()) {
                Block block;
                if (GameWorld.SmokeContainers.isChimney((LevelReader)level, pos)) {
                    pos = GameWorld.SmokeContainers.getBottommostChimney((LevelReader)level, pos).m_7495_();
                }
                if (level.m_8055_(pos).m_60734_() instanceof HopperBlock && (block = level.m_8055_(pos = pos.m_7495_()).m_60734_()) instanceof IPole) {
                    IPole pole = (IPole)block;
                    pos = pole.getBottom((LevelReader)level, pos).m_7495_();
                }
                if (!GameWorld.SmokeContainers.isActivePump((LevelReader)level, pos)) continue;
                activePumps.add(pos);
            }
            return activePumps;
        }

        @Deprecated
        public List<BlockPos> getActiveVents() {
            ArrayList<BlockPos> activeVents = new ArrayList<BlockPos>();
            for (BlockPos pos : this.getActivePumps()) {
                activeVents.addAll(GameWorld.SmokeContainers.getVentsAround((LevelReader)this.getWorld(), pos));
            }
            return activeVents;
        }
    }

    public static abstract class BlockChain {
        private static final List<Direction> DIRECTIONS = ImmutableList.copyOf((Object[])Direction.values());
        protected final LevelAccessor world;
        protected final BlockPos startPos;
        protected final OrderedHashSet<BlockPos> blockChain;
        protected final OrderedHashSet<BlockPos> foundBlocks;
        protected final int maxLength;
        protected boolean breakSearch = false;
        @Nullable
        protected Direction lastUsedDirection = null;

        public BlockChain(LevelAccessor level, BlockPos startPos, int maxLength) {
            this.world = level;
            this.startPos = startPos;
            this.maxLength = maxLength;
            this.blockChain = new OrderedHashSet();
            this.foundBlocks = new OrderedHashSet();
        }

        public static BlockChain simple(LevelAccessor level, BlockPos startPos, int maxLength, final Supplier<Collection<Direction>> directions, final BlockFunc validPath, final BlockFunc validBlock, final BlockFunc validFound) {
            BlockChain chain = new BlockChain(level, startPos, maxLength){

                @Override
                protected Collection<Direction> getDirections() {
                    return (Collection)directions.get();
                }

                @Override
                protected boolean onValidFound(BlockPos pos) {
                    return validFound.apply(this.world, pos);
                }

                @Override
                protected boolean isValidPath(BlockPos pos) {
                    return validPath.apply(this.world, pos);
                }

                @Override
                protected boolean isValidBlock(BlockPos pos) {
                    return validBlock.apply(this.world, pos);
                }
            };
            chain.build();
            return chain;
        }

        protected abstract boolean isValidPath(BlockPos var1);

        protected abstract boolean isValidBlock(BlockPos var1);

        protected abstract boolean onValidFound(BlockPos var1);

        public void build() {
            this.lastUsedDirection = null;
            this.breakSearch = false;
            this.blockChain.clear();
            this.foundBlocks.clear();
            this.search();
        }

        protected boolean isOutsideBounds(BlockPos pos) {
            return this.getWorld().m_151570_(pos) || !GameWorld.isBlockLoaded((LevelReader)this.getWorld(), pos);
        }

        protected Collection<Direction> getDirections() {
            return DIRECTIONS;
        }

        public BlockPos getStartPos() {
            return this.startPos;
        }

        public LevelAccessor getWorld() {
            return this.world;
        }

        public List<BlockPos> getChain() {
            return this.blockChain.elements();
        }

        public List<BlockPos> getFound() {
            return this.foundBlocks.elements();
        }

        public int length() {
            return this.getChain().size();
        }

        protected void search() {
            ArrayDeque<StackEntry> stack = new ArrayDeque<StackEntry>();
            stack.push(new StackEntry(this.startPos));
            while (!stack.isEmpty()) {
                if (this.length() >= this.maxLength) {
                    return;
                }
                StackEntry entry = (StackEntry)stack.peek();
                BlockPos pos = entry.getPos();
                if (!entry.isChecked()) {
                    if (this.isOutsideBounds(pos)) {
                        stack.pop();
                        continue;
                    }
                    if (this.isValidBlock(pos) && !this.foundBlocks.contains((Object)pos)) {
                        this.foundBlocks.add((Object)pos);
                        boolean bl = this.breakSearch = !this.onValidFound(pos);
                    }
                    if (!this.isValidPath(pos) || this.blockChain.contains((Object)pos)) {
                        stack.pop();
                        continue;
                    }
                    this.blockChain.add((Object)pos);
                    entry.setChecked();
                }
                if (this.breakSearch) {
                    return;
                }
                Direction direction = entry.getNextDirection().orElse(null);
                if (direction != null) {
                    stack.push(new StackEntry(pos.m_142300_(direction)));
                    this.lastUsedDirection = direction;
                    continue;
                }
                stack.pop();
            }
        }

        @FunctionalInterface
        public static interface BlockFunc {
            public boolean apply(LevelAccessor var1, BlockPos var2);
        }

        protected class StackEntry {
            protected final BlockPos pos;
            protected Deque<Direction> directions;
            protected boolean checked = false;

            public StackEntry(BlockPos pos) {
                this.pos = pos;
            }

            public BlockPos getPos() {
                return this.pos;
            }

            public Optional<Direction> getNextDirection() {
                if (this.directions == null) {
                    this.directions = new ArrayDeque<Direction>(BlockChain.this.getDirections());
                }
                if (this.directions.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(this.directions.pop());
            }

            public boolean isChecked() {
                return this.checked;
            }

            public void setChecked() {
                this.checked = true;
            }
        }
    }
}

