/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.init;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.EmittersInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adchimneys.compat.Minecraft;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import com.endertech.minecraft.mods.adchimneys.smoke.EmitterWithRandomColor;
import com.endertech.minecraft.mods.adchimneys.smoke.ISmokeEmitter;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;

public class Emitters
extends EmittersInit<Emitter, BuiltInEmitters> {
    public Emitters(AbstractForgeMod mod) {
        super(mod, BuiltInEmitters.class);
    }

    public Supplier<Emitter> createCustomUnitFrom(UnitConfig config, String name) {
        UnitId id = UnitId.from((Path)config.getConfigFile().toPath());
        return () -> new Emitter(config, (Emitter.Properties<?>)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().id(id)).smoke(2, 1.0f))));
    }

    public Supplier<Emitter> createDefaultUnitFrom(UnitConfig config, BuiltInEmitters e) {
        Emitter.Properties props = (Emitter.Properties)((Object)e.props.get());
        return () -> props.factory.orElse(Emitter::new).apply(config, props);
    }

    public Optional<Emitter> get(LevelReader reader, BlockPos pos) {
        BlockState state;
        Block block;
        if (reader.m_46805_(pos) && (block = (state = reader.m_8055_(pos)).m_60734_()) instanceof ISmokeEmitter) {
            return Optional.of(((ISmokeEmitter)block).getEmitter(reader, pos));
        }
        return super.get(reader, pos);
    }

    static enum BuiltInEmitters implements IForgeEnum
    {
        betterfurnacesreforged$iron_furnace(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)),
        betterfurnacesreforged$gold_furnace(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.2f)),
        betterfurnacesreforged$diamond_furnace(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.4f)),
        betterfurnacesreforged$netherhot_furnace(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(4, 2.0f)),
        betterfurnacesreforged$extreme_furnace(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(8, 4.0f)),
        betterfurnacesreforged$extreme_forge(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(8, 4.0f)),
        brickfurnace$brick_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(295063357)),
        brickfurnace$brick_blast_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f)))).color(290795557)),
        brickfurnace$brick_smoker(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 0.5f)))).color(295195714)),
        car$blast_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Emitter.Properties)Emitter.Properties.with().id("car:blastfurnace")).statePowered()).smoke(2, 1.5f)))).color(0x11B4B4B4)),
        ceramics$kiln(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(298084176)),
        charcoal_pit$bloomeryy(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f)),
        charcoal_pit$blast_furnace(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f)),
        charcoal_pit$distillery(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)),
        charcoal_pit$steam_press(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)),
        clayworks$kiln(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).notEmitWithoutChimney()))).smoke(2, 1.0f)),
        crossroads$firebox(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)))).color(287515431)),
        environmental$kiln(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(291981363)),
        furnacemk2$furnacemk2(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)),
        jumbofurnace$jumbo_furnace(() -> (Emitter.Properties)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().metadata("[lit=true, x=1, y=1, z=0]")).smoke(3, 1.5f)))).color(0x11808080).relatedBlocks(new String[]{"jumbofurnace:jumbo_furnace:*"})),
        immersiveengineering$alloy_smelter(() -> (Emitter.Properties)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().metadata("[active=true, multiblockslave=false]")).smoke(3, 1.2f)))).color(293159744).relatedBlocks(new String[]{"immersiveengineering:alloy_smelter:[multiblockslave=true]"})),
        immersiveengineering$coke_oven(() -> (Emitter.Properties)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().metadata("[active=true, multiblockslave=false]")).smoke(3, 1.5f)))).color(0x11333333).relatedBlocks(new String[]{"immersiveengineering:coke_oven:[multiblockslave=true]"})),
        immersiveengineering$blast_furnace(() -> (Emitter.Properties)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().metadata("[active=true, multiblockslave=false]")).smoke(3, 1.5f)))).color(291450657).relatedBlocks(new String[]{"immersiveengineering:blast_furnace:[multiblockslave=true]"})),
        immersiveengineering$advanced_blast_furnace(() -> (Emitter.Properties)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().metadata("[active=true, multiblockslave=false]")).smoke(3, 1.5f)))).color(291450657)))).notEmitAside().relatedBlocks(new String[]{"immersiveengineering:advanced_blast_furnace:[multiblockslave=true]"})),
        immersiveengineering$diesel_generator(() -> (Emitter.Properties)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Emitter.Properties)Emitter.Properties.with().metadata("[multiblockslave=false]")).activeTag("active")).smoke(2, 1.0f)))).color(0x11353535)))).notEmitWithoutChimney().relatedBlocks(new String[]{"immersiveengineering:diesel_generator:[multiblockslave=true]"})),
        industrialforegoing$biofuel_generator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().activeTag("progressBar/Tick")).smoke(2, 1.0f)))).color(293816094)),
        industrialforegoing$pitiful_generator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().activeTag("progressBar/Tick")).smoke(2, 1.0f)))).color(291257388)),
        ironfurnaces$iron_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(0x11727272)),
        ironfurnaces$silver_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f)))).color(0x11818D8D)),
        ironfurnaces$copper_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f)))).color(300061756)),
        ironfurnaces$gold_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f)))).color(301382435)),
        ironfurnaces$diamond_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(3, 2.0f)))).color(289201634)),
        ironfurnaces$emerald_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(3, 2.0f)))).color(287359535)),
        ironfurnaces$obsidian_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(3, 2.0f)))).color(287512370)),
        ironfurnaces$crystal_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(3, 2.5f)))).color(287553270)),
        ironfurnaces$netherite_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(4, 4.0f)))).color(287579679)),
        ironfurnaces$million_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(0x11FFFFFF)))).customFactory(EmitterWithRandomColor::new)),
        mekanism$fuelwood_heater(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)))).color(293232211)),
        mekanismgenerators$gas_burning_generator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)))).color(289291585)),
        mekanismgenerators$bio_generator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 0.5f)))).color(289291585)),
        mekanismgenerators$heat_generator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.5f)))).color(289291585)),
        minecraft$campfire(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().id("campfire:[lit=true, signal_fire=false]")).customFactory(Minecraft.Campfire::new)))).smoke(1, 0.1f)))).color(0xFF6600)))).maxGapLength(2)),
        minecraft$campfire_signal(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().id("campfire:[lit=true, signal_fire=true]")).customFactory(Minecraft.Campfire::new)))).smoke(2, 0.5f)))).color(-1140890112)))).maxGapLength(2)),
        minecraft$soul_campfire(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().id("soul_campfire:[lit=true, signal_fire=false]")).customFactory(Minecraft.Campfire::new)))).smoke(1, 0.1f)))).color(8188661)))).maxGapLength(2)),
        minecraft$soul_campfire_signal(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().id("soul_campfire:[lit=true, signal_fire=true]")).customFactory(Minecraft.Campfire::new)))).smoke(2, 0.5f)))).color(-1149439243)))).maxGapLength(2)),
        minecraft$furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(0x11808080)),
        minecraft$blast_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f)))).color(289291585)),
        minecraft$smoker(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 0.5f)))).color(291851819)),
        mysticalagriculture$basic_reprocessor(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().activeTag("FuelLeft")).smoke(2, 1.0f)))).color(297515705)),
        mysticalagriculture$inferium_reprocessor(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().activeTag("FuelLeft")).smoke(2, 1.0f)))).color(294825216)),
        mysticalagriculture$inferium_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(294825216)),
        mysticalagriculture$prudentium_reprocessor(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().activeTag("FuelLeft")).smoke(2, 1.2f)))).color(285258540)),
        mysticalagriculture$prudentium_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.2f)))).color(285258540)),
        mysticalagriculture$tertium_reprocessor(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().activeTag("FuelLeft")).smoke(2, 1.4f)))).color(299520512)),
        mysticalagriculture$tertium_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.4f)))).color(299520512)),
        mysticalagriculture$imperium_reprocessor(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().activeTag("FuelLeft")).smoke(2, 1.6f)))).color(285248752)),
        mysticalagriculture$imperium_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.6f)))).color(285248752)),
        mysticalagriculture$supremium_reprocessor(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().activeTag("FuelLeft")).smoke(2, 1.8f)))).color(299237376)),
        mysticalagriculture$supremium_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.8f)))).color(299237376)),
        pneumaticcraft$air_compressor(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.with().activeProperty("on")))).smoke(2, 1.0f)))).color(0x11808080)),
        pneumaticcraft$advanced_air_compressor(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.with().activeProperty("on")))).smoke(2, 1.0f)))).color(0x11484848)),
        pneumaticcraft$liquid_compressor(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.with().activeProperty("on")))).smoke(2, 1.0f)))).color(0x11808080)),
        pneumaticcraft$advanced_liquid_compressor(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)Emitter.Properties.with().activeProperty("on")))).smoke(2, 1.0f)))).color(0x11484848)),
        quark$blackstone_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(289093702)),
        quark$deepslate_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(0x11686868)),
        rftoolspower$blazing_generator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().metadata("[working=true]")).smoke(2, 1.0f)))).color(0x11787878)),
        rftoolspower$coal_generator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Emitter.Properties)Emitter.Properties.with().id("rftoolspower:coalgenerator")).stateLit()).smoke(2, 1.0f)))).color(0x11787878)),
        silents_mechanisms$coal_generator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(3, 1.5f)))).color(0x11707070)),
        silents_mechanisms$lava_generator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 0.5f)))).color(585140798)),
        silents_mechanisms$diesel_generator(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.5f)))).color(299558467)),
        simplekiln$kiln(() -> ((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)),
        steampowered$cast_iron_burner(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(0x11444444)),
        steampowered$bronze_burner(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(298297460)),
        steampowered$steel_burner(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateLit()).smoke(2, 1.0f)))).color(0x11898989)),
        tconstruct$seared_melter(() -> (Emitter.Properties)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Emitter.Properties)Emitter.Properties.with().stateActive()).activeTag("fuel")).notEmitWithoutChimney()))).smoke(2, 1.0f)))).color(290079297).relatedBlocks(new String[]{"#tconstruct:fuel_tanks"})),
        tconstruct$foundry_controller(() -> (Emitter.Properties)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Emitter.Properties)Emitter.Properties.with().stateActive()).activeTag("fuel")).notEmitWithoutChimney()))).smoke(2, 1.0f)))).color(289024806).relatedBlocks(new String[]{"#tconstruct:foundry/wall", "#tconstruct:foundry/floor"})),
        tconstruct$smeltery_controller(() -> (Emitter.Properties)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Object)((Object)((Emitter.Properties)((Emitter.Properties)Emitter.Properties.with().stateActive()).activeTag("fuel")).notEmitWithoutChimney()))).smoke(2, 1.0f)))).color(290079297).relatedBlocks(new String[]{"#tconstruct:smeltery/wall", "#tconstruct:smeltery/floor"})),
        thermal$dynamo_stirling(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)))).color(291067735)),
        thermal$dynamo_compression(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)))).color(297588455)),
        thermal$dynamo_magmatic(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)))).color(295742885)),
        thermal$machine_furnace(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)))).color(296993474)),
        thermal$machine_smelter(() -> ((Emitter.Properties)((Object)((Object)((Emitter.Properties)Emitter.Properties.with().stateActive()).smoke(2, 1.0f)))).color(296993474));

        final Lazy<Emitter.Properties<?>> props = Lazy.of(() -> (Emitter.Properties)((Emitter.Properties)((Object)((Object)props.get()))).emptyToEnumId(this, true));

        private BuiltInEmitters(Supplier<Emitter.Properties<?>> props) {
        }
    }
}

