/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.world;

import com.endertech.minecraft.forge.blocks.IPole;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.events.CampfireSmokeEvent;
import com.endertech.minecraft.forge.events.ChunkFullyLoadedEvent;
import com.endertech.minecraft.forge.events.RandomTickEvent;
import com.endertech.minecraft.forge.tiles.ChameleonBlockTile;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adchimneys.items.Paintbrush;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.endertech.minecraft.mods.adchimneys.world.WorldData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Events {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() == InteractionHand.MAIN_HAND && !event.getPlayer().m_6144_() && Paintbrush.in(event.getPlayer(), InteractionHand.OFF_HAND) && event.getWorld().m_7702_(event.getPos()) instanceof ChameleonBlockTile) {
            boolean placeBlock;
            Block block = Block.m_49814_((Item)event.getPlayer().m_21205_().m_41720_());
            boolean bl = placeBlock = block instanceof ISmokeContainer || block instanceof IPole;
            if (!placeBlock) {
                event.setUseItem(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void onRandomTick(RandomTickEvent.Block event) {
    }

    @SubscribeEvent
    public static void onBlockChanged(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor level = event.getWorld();
        if (GameWorld.isServerSide((LevelReader)level)) {
            WorldData.getData(level).getSmokeLocations().updateSmokeSourceAt(event.getPos());
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkFullyLoadedEvent event) {
        ServerLevel level = event.getLevel();
        LevelChunk chunk = event.getChunk();
        WorldData data = WorldData.getData((LevelAccessor)level);
        for (BlockPos pos : chunk.m_5928_()) {
            data.getSmokeLocations().updateSmokeSourceAt(pos);
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        LevelAccessor world = event.getWorld();
        if (world != null && GameWorld.isServerSide((LevelReader)world)) {
            WorldData data = WorldData.getData(world);
            data.getSmokeLocations().removeAllFor(event.getChunk());
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side.isServer()) {
            Level level = event.world;
            WorldData.getData((LevelAccessor)level).getSmokeLocations().onServerTick();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        ClientLevel level;
        if (event.phase == TickEvent.Phase.END && (level = Minecraft.m_91087_().f_91073_) != null) {
            WorldData.getData((LevelAccessor)level).getSmokeLocations().onClientTick();
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        LevelAccessor world = event.getWorld();
        if (GameWorld.isServerSide((LevelReader)world)) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        LevelAccessor world = event.getWorld();
        WorldData.DATA_MAP.remove(world);
    }

    @SubscribeEvent
    public static void onCampfireSmokeSpawn(CampfireSmokeEvent event) {
        if (((Boolean)Smoke.replaceVanillaCampfireSmoke.get()).booleanValue()) {
            event.setCanceled(true);
        }
    }
}

