/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.data;

import com.endertech.minecraft.forge.blocks.IWaterLoggable;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.blocks.Chimney;
import com.endertech.minecraft.mods.adchimneys.blocks.Container;
import com.endertech.minecraft.mods.adchimneys.init.Blocks;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ModBlockStates
extends BlockStateProvider {
    public ModBlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "adchimneys", exFileHelper);
    }

    protected void registerContainer(RegistryObject<? extends Container> container, String texture) {
        this.getVariantBuilder((Block)container.get()).forAllStatesExcept(state -> this.configuredModel(container.getId().toString(), ((Container)((Object)((Object)container.get()))).getType().getName(), texture), new Property[]{IWaterLoggable.WATERLOGGED});
    }

    protected void registerChimney(RegistryObject<Chimney> chimney, String texture) {
        String name = chimney.getId().toString();
        String parent = "chimney";
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)chimney.get()).part().modelFile(this.baseModel(name, "chimney", "", texture)).addModel()).end();
        this.multipartSides(builder, this.baseModel(name, "chimney", "side", texture), false);
        this.multipartCorners(builder, this.baseModel(name, "chimney", "corner", texture), false);
        this.multipartSides(builder, this.baseModel(name, "chimney", "top_side", texture), true);
        this.baseModel(name, "chimney", "inventory", texture);
    }

    protected ModelFile baseModel(String name, String parent, String suffix, String texture) {
        return this.baseModel(Names.registry().join(new String[]{name, suffix}), Names.registry().join(new String[]{parent, suffix}), new String[]{texture});
    }

    protected ModelFile baseModel(String name, String parent, String[] textures) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("base/" + parent));
        for (int i = 0; i < textures.length; ++i) {
            if (i == 0) {
                model.texture("particle", textures[i]);
            }
            model.texture(String.valueOf(i), textures[i]);
        }
        return model;
    }

    protected ConfiguredModel[] configuredModel(String name, String parent, String ... textures) {
        return ConfiguredModel.builder().modelFile(this.baseModel(name, parent, textures)).build();
    }

    protected MultiPartBlockStateBuilder.PartBuilder rotatedPart(MultiPartBlockStateBuilder builder, ModelFile model, Direction direction) {
        return (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(model).rotationY(((int)direction.m_122435_() + 180) % 360).uvLock(true).addModel();
    }

    protected void multipartSides(MultiPartBlockStateBuilder builder, ModelFile model, boolean onlyTop) {
        Chimney.SIDES.forEach((dir, value) -> {
            if (dir.m_122434_().m_122479_()) {
                MultiPartBlockStateBuilder.PartBuilder part = this.rotatedPart(builder, model, (Direction)dir);
                if (onlyTop) {
                    part.condition(Chimney.PART, (Comparable[])new Chimney.Part[]{Chimney.Part.TOP});
                }
                part.condition((Property)value, (Comparable[])new Boolean[]{true});
            }
        });
    }

    protected Direction prevDirection(Direction current) {
        Direction[] directions = GameWorld.Directions.CLOCKWISE_HORIZONTALS;
        for (int i = 0; i < directions.length; ++i) {
            if (directions[i] != current) continue;
            if (--i < 0) {
                i += directions.length;
            }
            return directions[i];
        }
        return current;
    }

    protected void multipartCorners(MultiPartBlockStateBuilder builder, ModelFile model, boolean onlyTop) {
        Chimney.SIDES.forEach((dir, value) -> {
            if (dir.m_122434_().m_122479_()) {
                MultiPartBlockStateBuilder.PartBuilder part = this.rotatedPart(builder, model, (Direction)dir);
                if (onlyTop) {
                    part.nestedGroup().condition(Chimney.PART, (Comparable[])new Chimney.Part[]{Chimney.Part.TOP});
                }
                part.nestedGroup().useOr().condition((Property)value, (Comparable[])new Boolean[]{true}).condition((Property)Chimney.SIDES.get(this.prevDirection((Direction)dir)), (Comparable[])new Boolean[]{true});
            }
        });
    }

    protected void registerStatesAndModels() {
        Blocks blocks = AdChimneys.getInstance().blocks;
        this.registerChimney(blocks.stone_chimney, "minecraft:block/cobblestone");
        this.registerChimney(blocks.metal_chimney, "minecraft:block/iron_block");
        this.registerChimney(blocks.glass_chimney, "minecraft:block/glass");
        this.registerContainer(blocks.stone_vent, "minecraft:block/cobblestone");
        this.registerContainer(blocks.metal_vent, "minecraft:block/iron_block");
        this.registerContainer(blocks.stone_pump, "minecraft:block/cobblestone");
        this.registerContainer(blocks.metal_pump, "minecraft:block/iron_block");
        this.getVariantBuilder((Block)blocks.pipe.get()).forAllStatesExcept(state -> this.configuredModel("pipe", "pipe", new String[0]), new Property[]{IWaterLoggable.WATERLOGGED});
    }
}

