/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.world;

import com.endertech.minecraft.forge.events.CampfireSmokeEvent;
import com.endertech.minecraft.forge.events.ChunkFullyLoadedEvent;
import com.endertech.minecraft.forge.events.RandomTickEvent;
import com.endertech.minecraft.forge.tiles.ChameleonBlockTile;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adchimneys.items.Paintbrush;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.endertech.minecraft.mods.adchimneys.world.WorldData;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Events {
    @SubscribeEvent
    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() == InteractionHand.MAIN_HAND && Paintbrush.in(event.getEntity(), InteractionHand.OFF_HAND) && !event.getEntity().m_6047_() && event.getLevel().m_7702_(event.getPos()) instanceof ChameleonBlockTile) {
            event.setUseItem(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onRandomTick(RandomTickEvent.Block event) {
    }

    @SubscribeEvent
    public static void onBlockChanged(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor level = event.getLevel();
        if (GameWorld.isServerSide((LevelReader)level)) {
            WorldData.getData(level).getSmokeLocations().updateSmokeSourceAt(event.getPos());
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkFullyLoadedEvent event) {
        ServerLevel level = event.getLevel();
        LevelChunk chunk = event.getChunk();
        WorldData data = WorldData.getData((LevelAccessor)level);
        for (BlockPos pos : chunk.m_5928_()) {
            data.getSmokeLocations().updateSmokeSourceAt(pos);
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        LevelAccessor world = event.getLevel();
        if (world != null && GameWorld.isServerSide((LevelReader)world)) {
            WorldData data = WorldData.getData(world);
            data.getSmokeLocations().removeAllFor(event.getChunk());
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side.isServer()) {
            Level level = event.level;
            WorldData.getData((LevelAccessor)level).getSmokeLocations().onServerTick();
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.CLIENT) {
            Level level = event.player.f_19853_;
            WorldData.getData((LevelAccessor)level).getSmokeLocations().onClientTick();
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor level = event.getLevel();
        if (GameWorld.isServerSide((LevelReader)level)) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        LevelAccessor world = event.getLevel();
        WorldData.DATA_MAP.remove(world);
    }

    @SubscribeEvent
    public static void onCampfireSmokeSpawn(CampfireSmokeEvent event) {
        if (((Boolean)Smoke.disableVanillaCampfireSmoke.get()).booleanValue()) {
            event.setCanceled(true);
        }
    }
}

