/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.common.FloatBounds;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetContainerContents;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseLootTableProvider
extends LootTableProvider {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final Map<Block, LootTable.Builder> blockLootTables = new ConcurrentHashMap<Block, LootTable.Builder>();
    protected final Map<ResourceLocation, LootTable> customLootTables = new ConcurrentHashMap<ResourceLocation, LootTable>();
    protected final PackOutput.PathProvider f_236267_;

    public BaseLootTableProvider(PackOutput packOutput) {
        super(packOutput, Set.of(), VanillaLootTableProvider.m_247452_((PackOutput)packOutput).getTables());
        this.f_236267_ = packOutput.m_245269_(PackOutput.Target.DATA_PACK, "loot_tables");
    }

    protected abstract void addTables();

    protected LootPool.Builder blockPool(String name, Block block) {
        return LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block));
    }

    protected void addBlock(String name, Block block, BlockEntityType<?> type) {
        this.addBlockPool(block, this.blockPool(name, block).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("Info", "BlockEntityTag.Info", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("Inventory", "BlockEntityTag.Inventory", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("Energy", "BlockEntityTag.Energy", CopyNbtFunction.MergeStrategy.REPLACE)).m_79078_((LootItemFunction.Builder)SetContainerContents.m_193036_(type).m_80930_((LootPoolEntryContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)new ResourceLocation("minecraft", "contents")))));
    }

    protected void addBlock(RegistryObject<? extends Block> block) {
        this.addBlock(block.getId().m_135815_(), (Block)block.get());
    }

    protected void addBlock(String name, Block block) {
        this.addBlockPool(block, this.blockPool(name, block));
    }

    protected void addBlockPool(Block block, LootPool.Builder pool) {
        this.blockLootTables.put(block, LootTable.m_79147_().m_79161_(pool));
    }

    protected void addBlockSilkTouch(String name, Block block, Item lootItem, FloatBounds count) {
        this.addBlockPool(block, LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.m_79579_((ItemLike)block).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))), LootItem.m_79579_((ItemLike)lootItem).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)count.getMin().floatValue(), (float)count.getMax().floatValue()))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)1)).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_())})));
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addTables();
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        this.blockLootTables.forEach((block, builder) -> tables.put(block.m_60589_(), builder.m_79165_(LootContextParamSets.f_81421_).m_79167_()));
        this.customLootTables.forEach(tables::put);
        return this.writeTables(cache, tables);
    }

    protected CompletableFuture<?> writeTables(CachedOutput cache, Map<ResourceLocation, LootTable> tables) {
        return CompletableFuture.allOf((CompletableFuture[])tables.entrySet().stream().map(entry -> {
            Path path = this.f_236267_.m_245731_((ResourceLocation)entry.getKey());
            LootTable lootTable = (LootTable)entry.getValue();
            return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)LootTables.m_79200_((LootTable)lootTable), (Path)path);
        }).toArray(CompletableFuture[]::new));
    }
}

