/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.math;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.world.GameWorld;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;

public class AABBHelper {
    public static final AABB ZERO = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final AABB BLOCK = ForgeBlock.FULL_BLOCK_AABB;
    public static final int BLOCK_SIZE = 1;

    public static List<AABB> getEdges(float thickness) {
        float d0 = thickness;
        float d1 = 1.0f - thickness;
        AABB X = new AABB(0.0, 0.0, 0.0, 1.0, (double)d0, (double)d0);
        AABB Y = new AABB(0.0, 0.0, 0.0, (double)d0, 1.0, (double)d0);
        AABB Z = new AABB(0.0, 0.0, 0.0, (double)d0, (double)d0, 1.0);
        AABB[] AABB_X = new AABB[]{X.m_82386_(0.0, 0.0, 0.0), X.m_82386_(0.0, (double)d1, 0.0), X.m_82386_(0.0, 0.0, (double)d1), X.m_82386_(0.0, (double)d1, (double)d1)};
        AABB[] AABB_Y = new AABB[]{Y.m_82386_(0.0, 0.0, 0.0), Y.m_82386_((double)d1, 0.0, 0.0), Y.m_82386_(0.0, 0.0, (double)d1), Y.m_82386_((double)d1, 0.0, (double)d1)};
        AABB[] AABB_Z = new AABB[]{Z.m_82386_(0.0, 0.0, 0.0), Z.m_82386_(0.0, (double)d1, 0.0), Z.m_82386_((double)d1, 0.0, 0.0), Z.m_82386_((double)d1, (double)d1, 0.0)};
        ArrayList<AABB> edges = new ArrayList<AABB>();
        Collections.addAll(edges, AABB_X);
        Collections.addAll(edges, AABB_Y);
        Collections.addAll(edges, AABB_Z);
        return edges;
    }

    public static AABB getFace(float thickness, Direction facing) {
        float d0 = thickness;
        float d1 = 1.0f - thickness;
        switch (facing) {
            case DOWN: {
                return new AABB(0.0, 0.0, 0.0, 1.0, (double)d0, 1.0);
            }
            case UP: {
                return new AABB(0.0, (double)d1, 0.0, 1.0, 1.0, 1.0);
            }
            case EAST: {
                return new AABB((double)d1, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
            case NORTH: {
                return new AABB(0.0, 0.0, 0.0, 1.0, 1.0, (double)d0);
            }
            case SOUTH: {
                return new AABB(0.0, 0.0, (double)d1, 1.0, 1.0, 1.0);
            }
            case WEST: {
                return new AABB(0.0, 0.0, 0.0, (double)d0, 1.0, 1.0);
            }
        }
        return ZERO;
    }

    public static List<AABB> getFaces(float thickness, Direction ... facings) {
        ArrayList<AABB> list = new ArrayList<AABB>();
        for (Direction facing : facings) {
            list.add(AABBHelper.getFace(thickness, facing));
        }
        return list;
    }

    public static List<AABB> getWalls(float thickness) {
        return AABBHelper.getFaces(thickness, GameWorld.Directions.CLOCKWISE_HORIZONTALS);
    }

    public static boolean isFullBlockingPane(AABB aabb, Direction.Axis axis) {
        if (aabb == null) {
            return false;
        }
        switch (axis) {
            case X: {
                if (!(aabb.f_82292_ - aabb.f_82289_ >= 1.0) || !(aabb.f_82293_ - aabb.f_82290_ >= 1.0)) break;
                return true;
            }
            case Y: {
                if (!(aabb.f_82291_ - aabb.f_82288_ >= 1.0) || !(aabb.f_82293_ - aabb.f_82290_ >= 1.0)) break;
                return true;
            }
            case Z: {
                if (!(aabb.f_82292_ - aabb.f_82289_ >= 1.0) || !(aabb.f_82291_ - aabb.f_82288_ >= 1.0)) break;
                return true;
            }
        }
        return false;
    }

    public static boolean isFullBlockingFace(AABB aabb, Direction facing) {
        if (AABBHelper.isFullBlockingPane(aabb, facing.m_122434_())) {
            boolean neg = facing.m_122421_() == Direction.AxisDirection.NEGATIVE;
            switch (facing.m_122434_()) {
                case X: {
                    return neg ? aabb.f_82288_ == 0.0 : aabb.f_82291_ == 1.0;
                }
                case Y: {
                    return neg ? aabb.f_82289_ == 0.0 : aabb.f_82292_ == 1.0;
                }
                case Z: {
                    return neg ? aabb.f_82290_ == 0.0 : aabb.f_82293_ == 1.0;
                }
            }
        }
        return false;
    }
}

