/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.particles;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.forge.world.Wind;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.particles.AbstractSmokeParticle;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModernSmokeParticle {
    @OnlyIn(value=Dist.CLIENT)
    public static void generate(Level level, IWind wind, Smoke smoke, BlockPos pos, float factor) {
        level.m_46473_().m_6180_("generateModernSmokeParticles");
        int smokeAmount = Math.round(smoke.getAmount() * factor);
        FloatBounds dyBounds = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(0.6f));
        FloatBounds dxzBounds = FloatBounds.between((Float)Float.valueOf(0.125f), (Float)Float.valueOf(0.875f)).reduce(Float.valueOf(smoke.getScale() / 10.0f));
        boolean useVanillaParticles = (Boolean)Smoke.useVanillaParticles.get();
        Object data = useVanillaParticles ? ParticleTypes.f_123777_ : new Data(wind, smoke);
        double speedY = useVanillaParticles ? 0.07 : 0.0;
        for (int i = 0; i < smokeAmount; ++i) {
            double dx = dxzBounds.randomBetween().floatValue();
            double dy = dyBounds.randomBetween().floatValue();
            double dz = dxzBounds.randomBetween().floatValue();
            Vect3d smokePos = Vect3d.from((BlockPos)pos).move(dx, dy, dz);
            level.m_6485_((ParticleOptions)data, true, smokePos.x, smokePos.y, smokePos.z, 0.0, speedY, 0.0);
        }
        level.m_46473_().m_7238_();
    }

    public static class Data
    extends AbstractSmokeParticle.Data {
        public Data(IWind wind, Smoke smoke) {
            super(wind, smoke);
        }

        public ParticleType<?> m_6012_() {
            return (ParticleType)AdChimneys.getInstance().particles.modern.get();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Instance
    extends AbstractSmokeParticle.Instance {
        public Instance(ClientLevel world, IWind wind, Smoke smoke, Vect3d pos, Vect3d motion, float scale, SpriteSet sprite) {
            super(world, wind, smoke, pos, motion, scale, sprite);
            this.f_107225_ = this.f_107223_.m_188503_(50) + 80;
            this.m_6569_(1.5f * scale);
            this.m_107271_(0.9f);
            this.setColor(smoke.pickColor());
            this.f_107226_ = 3.0E-6f;
            this.f_107215_ = motion.x;
            this.f_107216_ = motion.y + (double)(this.f_107223_.m_188501_() / 500.0f);
            this.f_107217_ = motion.z;
        }

        @Override
        public ParticleRenderType m_7556_() {
            return ParticleRenderType.f_107431_;
        }

        public float m_5902_(float partialTicks) {
            float ageFactor = 4.0f * ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
            return Math.max(this.f_107663_, this.f_107663_ * ageFactor);
        }

        @Override
        public void m_5989_() {
            super.m_5989_();
            if (!this.inChimney) {
                this.f_107216_ *= 0.99;
            }
            if (this.f_107218_) {
                ++this.f_107224_;
                ++this.f_107224_;
            }
        }

        @Override
        public void updateAnimatedSprite() {
            if (this.f_107224_ == 1) {
                this.m_108335_(this.animatedSprite);
            }
            if (this.f_107224_ >= this.f_107225_ - 60 && this.f_107230_ > 0.01f) {
                this.f_107230_ -= 0.015f;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    extends AbstractSmokeParticle.Factory<Data> {
        public Factory(SpriteSet sprite) {
            super(sprite);
        }

        public Particle createParticle(Data data, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            double motionY = (double)data.smoke.getIntensity() / 10.0 * CommonMath.Random.between((double)0.5, (double)1.0);
            motionY = Math.max(motionY, 0.1);
            return new Instance(world, data.wind, data.smoke, Vect3d.from((double)x, (double)y, (double)z), Vect3d.from((double)0.0, (double)motionY, (double)0.0), data.smoke.getScale(), this.sprite);
        }
    }

    public static class Deserializer
    extends AbstractSmokeParticle.Deserializer<Data> {
        public Data fromCommand(ParticleType<Data> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            return new Data((IWind)Wind.NONE, Smoke.getNone());
        }

        public Data fromNetwork(ParticleType<Data> particleTypeIn, FriendlyByteBuf buffer) {
            return new Data((IWind)Wind.NONE, Smoke.getNone());
        }
    }
}

