/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.IPollutant;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.blocks.ITiledBlock;
import com.endertech.minecraft.forge.data.ForgeEnergy;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.tiles.ChameleonBlockTile;
import com.endertech.minecraft.forge.units.ITickableUnit;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.blocks.Container;
import com.endertech.minecraft.mods.adchimneys.blocks.Vent;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public class Pump
extends Container
implements ITiledBlock<Tile> {
    public static ForgeConfigSpec.ConfigValue<Boolean> invertedRedstoneSignal;
    public static ForgeConfigSpec.ConfigValue<Boolean> energyStorageEnabled;
    public static ForgeConfigSpec.ConfigValue<Integer> energyStorageCapacity;
    public static ForgeConfigSpec.ConfigValue<Integer> energyStorageConsumption;
    protected static final VoxelShape HOLES_TOP;
    protected static final VoxelShape SUPPORTS_VERT;
    protected static final VoxelShape SHAPE;
    protected static final VoxelShape SUPPORT_SHAPE;

    public Pump(Container.Properties<?> props) {
        super(props);
    }

    public Tile createTile(BlockPos pos, BlockState state) {
        return new Tile(pos, state);
    }

    public Class<Tile> getTileClass() {
        return Tile.class;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean isActive(BlockGetter level, BlockPos pos) {
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof Tile) {
            return ((Tile)tile).isActive();
        }
        return false;
    }

    public List<BlockPos> getClosestActiveExhaustPumps(LevelAccessor level, BlockPos pos) {
        return this.getTile((BlockGetter)level, pos).map(tile -> tile.getClosestActiveExhaustPumps(level, pos)).orElse(Collections.emptyList());
    }

    public ISmokeContainer.Type getType() {
        return ISmokeContainer.Type.PUMP;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return this.isActive(level, pos) ? 1 : super.getLightEmission(state, level, pos);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (this.isActive((BlockGetter)level, pos)) {
            this.spawnActiveStateParticles(level, pos);
        }
    }

    protected void spawnActiveStateParticles(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pos.m_121945_(direction);
            if (level.m_8055_(blockpos).m_60804_((BlockGetter)level, blockpos)) continue;
            Function<Direction.Axis, Double> delta = axis -> direction.m_122434_() == axis ? 0.5 + 0.5625 * (double)direction.m_122436_().m_123304_(axis) : level.m_213780_().m_188500_();
            level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)pos.m_123341_() + delta.apply(Direction.Axis.X), (double)pos.m_123342_() + delta.apply(Direction.Axis.Y), (double)pos.m_123343_() + delta.apply(Direction.Axis.Z), 0.0, 0.0, 0.0);
        }
    }

    static {
        HOLES_TOP = Shapes.m_83124_((VoxelShape)Pump.m_49796_((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)6.0), (VoxelShape[])new VoxelShape[]{Pump.m_49796_((double)3.0, (double)13.0, (double)10.0, (double)13.0, (double)16.0, (double)13.0), Pump.m_49796_((double)3.0, (double)13.0, (double)3.0, (double)6.0, (double)16.0, (double)13.0), Pump.m_49796_((double)10.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)});
        SUPPORTS_VERT = Shapes.m_83124_((VoxelShape)Pump.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), (VoxelShape[])new VoxelShape[0]);
        VoxelShape hopper = Shapes.m_83124_((VoxelShape)Pump.m_49796_((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Pump.m_49796_((double)4.0, (double)7.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), Pump.m_49796_((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0)});
        VoxelShape shape = Shapes.m_83148_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)Vent.HOLE_CENTER, (VoxelShape[])new VoxelShape[]{Vent.HOLES_X, Vent.HOLES_Z, Vent.HOLES_BOTTOM, HOLES_TOP}), (BooleanOp)BooleanOp.f_82685_);
        SHAPE = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)hopper);
        SUPPORT_SHAPE = Shapes.m_83124_((VoxelShape)SHAPE, (VoxelShape[])new VoxelShape[]{Vent.SUPPORTS_SIDE, SUPPORTS_VERT});
    }

    public static class Tile
    extends ChameleonBlockTile
    implements ITickableUnit {
        private final GameTime updateInterval = GameTime.second();
        protected final ForgeEnergy.Storage energyStorage;
        protected final LazyOptional<ForgeEnergy.Storage> energyStorageHolder;
        protected List<BlockPos> closestActiveExhaustPumps = null;

        public Tile(BlockPos pos, BlockState state) {
            super((BlockEntityType)AdChimneys.getInstance().tiles.pump.get(), pos, state);
            ForgeEnergy.StorageProps props = ForgeEnergy.StorageProps.create((boolean)((Boolean)energyStorageEnabled.get()), (int)((Integer)energyStorageCapacity.get()), (int)((Integer)energyStorageConsumption.get()));
            this.energyStorage = ForgeEnergy.Storage.with((ForgeEnergy.StorageProps)props);
            this.energyStorageHolder = LazyOptional.of(() -> this.energyStorage);
        }

        protected Optional<BlockPos> getHopperInput() {
            BlockPos pos;
            Level level = this.getWorldLevel();
            if (level != null && (pos = (BlockPos)GameWorld.SmokeContainers.getConnectedHopper((LevelReader)level, (BlockPos)this.m_58899_()).orElse(null)) != null) {
                if (GameWorld.SmokeContainers.isChimney((LevelReader)level, (BlockPos)(pos = pos.m_7494_()))) {
                    pos = GameWorld.SmokeContainers.getTopmostChimney((LevelReader)level, (BlockPos)pos).m_7494_();
                }
                return Optional.of(pos);
            }
            return Optional.empty();
        }

        @Nullable
        public Level getWorldLevel() {
            return this.m_58904_();
        }

        public boolean isActive() {
            Level level = this.getWorldLevel();
            if (level == null) {
                return false;
            }
            boolean powered = level.m_46753_(this.m_58899_());
            if (((Boolean)invertedRedstoneSignal.get()).booleanValue()) {
                boolean bl = powered = !powered;
            }
            if (this.energyStorage.isEnabled() && !this.energyStorage.hasEnoughEnergy()) {
                powered = false;
            }
            return powered;
        }

        public boolean exists() {
            return !this.m_58901_();
        }

        public GameTime getUpdateInterval() {
            return this.updateInterval;
        }

        public void onUpdate() {
            Level level = this.getWorldLevel();
            if (level != null && GameWorld.isServerSide((LevelReader)level) && this.isActive()) {
                Optional<BlockPos> inputPos;
                this.energyStorage.consumeEnergy();
                if (this.getUpdateInterval().mult(2).pastIn(level)) {
                    this.closestActiveExhaustPumps = null;
                    this.getClosestActiveExhaustPumps((LevelAccessor)level, this.m_58899_());
                }
                if ((inputPos = this.getHopperInput()).isPresent()) {
                    BlockPos pos = inputPos.get();
                    if (GameWorld.SmokeContainers.isVent((LevelReader)level, (BlockPos)pos)) {
                        WorldSearch.VentPipe.suck((LevelAccessor)level, (BlockPos)pos, (BlockPos)this.m_58899_());
                    } else if (this.getUpdateInterval().mult(3).pastIn(level)) {
                        this.suckPollutionViaHopper(pos);
                    }
                } else {
                    WorldSearch.VentPipe.suck((LevelAccessor)level, (BlockPos)this.m_58899_());
                }
            }
        }

        protected List<BlockPos> getClosestActiveExhaustPumps(LevelAccessor level, BlockPos pos) {
            if (this.closestActiveExhaustPumps == null) {
                List pumps = GameWorld.SmokeContainers.getClosestActiveExhaustPumps((LevelAccessor)level, (BlockPos)pos);
                this.closestActiveExhaustPumps = Collections.unmodifiableList(pumps);
            }
            return this.closestActiveExhaustPumps;
        }

        protected void suckPollutionViaHopper(BlockPos inputPos) {
            Level level = this.getWorldLevel();
            if (level == null || level.m_5776_()) {
                return;
            }
            if (level.m_8055_(inputPos).m_60783_((BlockGetter)level, inputPos, Direction.DOWN)) {
                return;
            }
            IntBounds height = IntBounds.between((Integer)inputPos.m_123342_(), (Integer)(inputPos.m_123342_() + 2));
            int maxRadius = GameWorld.SmokeContainers.isChimney((LevelReader)level, (BlockPos)inputPos.m_7495_()) ? 1 : GameWorld.SmokeContainers.getHopperSuctionRange((LevelReader)level, (BlockPos)inputPos.m_7495_());
            final BlockPos pumpPos = this.m_58899_();
            WorldSearch.VertCylinder searcher = new WorldSearch.VertCylinder((LevelAccessor)level, inputPos, height, maxRadius){

                protected boolean isValidPath(BlockPos pos) {
                    if (this.level.m_46859_(pos)) {
                        return true;
                    }
                    if (this.lastUsedDirection == null) {
                        return true;
                    }
                    BlockPos last = pos.m_121945_(this.lastUsedDirection.m_122424_());
                    return !this.level.m_8055_(last).m_60783_((BlockGetter)this.level, last, this.lastUsedDirection) && !this.level.m_8055_(pos).m_60783_((BlockGetter)this.level, pos, this.lastUsedDirection.m_122424_());
                }

                protected boolean isValidBlock(BlockPos pos) {
                    return this.level.m_8055_(pos).m_60734_() instanceof IPollutant;
                }

                protected boolean onValidFound(BlockPos pos) {
                    Block block = this.level.m_8055_(pos).m_60734_();
                    if (block instanceof IPollutant) {
                        IPollutant pollutant = (IPollutant)block;
                        int count = GameWorld.SmokeContainers.pumpPollutionThrough(List.of(pumpPos), (LevelAccessor)this.level, (IPollutant)pollutant, (int)1);
                        if (count > 0) {
                            pollutant.spend(this.level, pos, count);
                        }
                    }
                    return false;
                }
            };
            searcher.build();
        }

        public void m_7651_() {
            super.m_7651_();
            this.energyStorageHolder.invalidate();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            if (cap == CapabilityEnergy.ENERGY && this.energyStorage.isEnabled()) {
                return this.energyStorageHolder.cast();
            }
            return super.getCapability(cap, side);
        }

        public void readSharedData(CompoundTag compound) {
            super.readSharedData(compound);
            this.energyStorage.readFrom(compound);
        }

        public CompoundTag writeSharedData(CompoundTag compound) {
            super.writeSharedData(compound);
            this.energyStorage.writeTo(compound);
            return compound;
        }
    }
}

