/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.configs;

import com.endertech.common.CommonString;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class Parsers {

    public static class UnitId_OptInteger
    extends AbstractParser {
        protected final IntBounds bounds;
        protected final String delimiter;

        public UnitId_OptInteger(IntBounds bounds, String delimiter) {
            this.bounds = bounds;
            this.delimiter = delimiter;
        }

        public UnitId getId(CharSequence input) throws Exception {
            return this.getGroup("id", input).map(UnitId::from).filter(UnitId::notEmpty).orElseThrow(() -> new Exception("Invalid id"));
        }

        public Optional<Integer> getInteger(CharSequence input) throws Exception {
            Optional<Integer> value = this.getGroup("integer", input).map(String::trim).map(Integer::parseInt);
            if (value.isPresent()) {
                value.filter(this.bounds::encloses).orElseThrow(() -> new Exception("Integer value is out of " + this.bounds));
            }
            return value;
        }

        @Override
        protected String regex() {
            return "^" + this.grp("id", this.unit_id()) + this.grp_non(this.delim(this.delimiter) + this.grp("integer", this.integer()), true) + "$";
        }
    }

    public static abstract class AbstractParser {
        @Nullable
        protected Pattern pattern;

        protected abstract String regex();

        protected Matcher matcher(CharSequence input) {
            if (this.pattern == null) {
                this.pattern = Pattern.compile(this.regex());
            }
            return this.pattern.matcher(input);
        }

        protected Optional<String> getGroup(String name, CharSequence input) throws Exception {
            Matcher matcher = this.matcher(input);
            if (!matcher.matches()) {
                throw new Exception("No matches found. Invalid format");
            }
            return Optional.ofNullable(matcher.group(name));
        }

        public void logError(AbstractForgeMod mod, String what, CharSequence in, Exception exception) {
            this.logError(mod, null, what, in, exception);
        }

        public void logError(AbstractForgeMod mod, @Nullable UnitConfig config, String what, CharSequence in, Exception exception) {
            mod.getLogger().error("Unable to get " + what + " parsing " + CommonString.quoted(in.toString()) + (String)(config != null ? " in " + config.getConfigFile() : "") + " because of " + exception);
        }

        protected String grp(String name, String regex) {
            return "(?<" + name + ">" + regex + ")";
        }

        protected String grp_non(String regex, boolean optional) {
            return "(?:" + regex + ")" + (optional ? "?" : "");
        }

        protected String unit_id() {
            String id = StringUtils.removeEnd((String)UnitId.PATTERN.pattern(), (String)"$");
            return StringUtils.removeStart((String)id, (String)"^");
        }

        protected String delim(String delimiter) {
            return "\\s*" + delimiter + "\\s*";
        }

        protected String bool() {
            return "(?i)true|false";
        }

        protected String digits() {
            return "\\d+";
        }

        protected String integer() {
            return "-?\\d+";
        }
    }
}

