/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.particles;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.forge.world.Wind;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AbstractSmokeParticle {

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Instance
    extends TextureSheetParticle {
        private static final int MAX_HIT_AFTER_HIT_AMOUNT = 2;
        private static final double ON_HIT_MOTION_REDICTION = 0.7;
        protected boolean inChimney = false;
        protected int ticksInChimney = 0;
        protected final IWind wind;
        protected final SpriteSet animatedSprite;
        private int hitAfterHitCount = 0;

        public Instance(ClientLevel world, IWind wind, Smoke smoke, Vect3d pos, Vect3d motion, float scale, SpriteSet sprite) {
            super(world, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
            this.animatedSprite = sprite;
            this.wind = wind;
            this.m_108339_(sprite);
            this.f_107219_ = (Boolean)Smoke.canCollide.get();
            ++GameWorld.getData((LevelAccessor)world).smokeParticlesCount;
        }

        public abstract void updateAnimatedSprite();

        public void m_107274_() {
            --GameWorld.getData((LevelAccessor)this.f_107208_).smokeParticlesCount;
            super.m_107274_();
        }

        public Vect3d getPosition() {
            return Vect3d.from((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        }

        public Vect3d getMotion() {
            return Vect3d.from((double)this.f_107215_, (double)this.f_107216_, (double)this.f_107217_);
        }

        public void setMotion(Vect3d motion) {
            this.f_107215_ = motion.x;
            this.f_107216_ = motion.y;
            this.f_107217_ = motion.z;
        }

        public void setColor(ColorARGB color) {
            this.m_107253_(color.getRed().toFloat(), color.getGreen().toFloat(), color.getBlue().toFloat());
        }

        public void setPosition(Vect3d pos) {
            this.m_107264_(pos.x, pos.y, pos.z);
        }

        public BlockPos getBlockPos() {
            return BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        }

        protected void tryColorizeWith(ColorARGB color) {
            if (Smoke.colorize == null || !((Boolean)Smoke.colorize.get()).booleanValue()) {
                return;
            }
            float alpha = color.getAlpha().toFloat();
            if (CommonMath.Random.result((float)(alpha * ((Double)Smoke.coloringFactor.get()).floatValue()))) {
                this.setColor(color);
            }
        }

        public void m_5989_() {
            ISmokeContainer container;
            ISmokeContainer container2;
            this.f_107208_.m_46473_().m_6180_("smokeParticle.update");
            ++this.f_107224_;
            if (this.f_107224_ >= this.f_107225_) {
                this.m_107274_();
            }
            this.f_107209_ = this.f_107212_;
            this.f_107210_ = this.f_107213_;
            this.f_107211_ = this.f_107214_;
            BlockPos blockPos = this.getBlockPos();
            BlockState state = this.f_107208_.m_8055_(blockPos);
            Block block = state.m_60734_();
            boolean inSolidBlock = true;
            if (block instanceof ISmokeContainer && (container2 = (ISmokeContainer)block).isChimney()) {
                inSolidBlock = true;
            } else {
                for (Direction face : GameWorld.Directions.CLOCKWISE_HORIZONTALS) {
                    if (state.m_60783_((BlockGetter)this.f_107208_, blockPos, face)) continue;
                    inSolidBlock = false;
                    break;
                }
            }
            boolean canSeeSky = false;
            if (!inSolidBlock) {
                for (BlockPos pos : GameWorld.Positions.getAroundHoriz((BlockPos)blockPos, (boolean)true, (BlockPos[])new BlockPos[0])) {
                    if (!this.f_107208_.m_45527_(pos)) continue;
                    canSeeSky = true;
                    break;
                }
            }
            IWind wind = !inSolidBlock || canSeeSky ? this.wind : Wind.NONE;
            this.inChimney = false;
            if (block instanceof ISmokeContainer && (container = (ISmokeContainer)block).isChimney() && CommonMath.notZero((double)this.f_107216_) && this.f_107216_ > 0.0) {
                this.inChimney = true;
                ++this.ticksInChimney;
                --this.f_107224_;
            }
            this.updateAnimatedSprite();
            this.f_107216_ -= (double)this.f_107226_;
            Vect3d motion = this.getMotion().add(wind.getMotion());
            this.move(motion);
            this.f_107208_.m_46473_().m_7238_();
        }

        public void m_6257_(double dx, double dy, double dz) {
            this.move(Vect3d.from((double)dx, (double)dy, (double)dz));
        }

        public void move(Vect3d motion) {
            Vect3d nextPos = this.getPosition().add(motion);
            this.moveTo(nextPos);
        }

        private void moveTo(Vect3d nextPos) {
            if (this.f_107219_) {
                if (this.hitAfterHitCount > 2) {
                    this.m_107274_();
                    return;
                }
                Vect3d curPos = this.getPosition();
                BlockPos blockPos = nextPos.toBlockPos();
                BlockState blockState = this.f_107208_.m_8055_(blockPos);
                BlockHitResult hit = blockState.m_60812_((BlockGetter)this.f_107208_, blockPos).m_83220_(curPos.toVector3d(), nextPos.toVector3d(), blockPos);
                if (hit != null && !blockState.m_60783_((BlockGetter)this.f_107208_, blockPos, hit.m_82434_())) {
                    hit = null;
                }
                if (hit != null && hit.m_6662_() != HitResult.Type.MISS) {
                    ++this.hitAfterHitCount;
                    Direction.Axis axis = hit.m_82434_().m_122434_();
                    Vect3d hitLocation = Vect3d.from((Vec3)hit.m_82450_());
                    Vect3d bounceVec = nextPos.subtract(hitLocation);
                    switch (axis) {
                        case X: {
                            bounceVec = bounceVec.invertX();
                            this.f_107215_ = -this.f_107215_;
                            break;
                        }
                        case Z: {
                            bounceVec = bounceVec.invertZ();
                            this.f_107217_ = -this.f_107217_;
                            break;
                        }
                        case Y: {
                            bounceVec = bounceVec.invertY();
                            CommonMath.Angle angle = CommonMath.Angle.random();
                            double motion = this.f_107216_ * this.getOnHitMotionReduction();
                            motion = Math.max(motion, 0.1);
                            this.f_107215_ = angle.cos() * motion;
                            this.f_107217_ = angle.sin() * motion;
                            this.f_107216_ = 0.0;
                            this.f_107219_ = false;
                            this.f_107218_ = true;
                            break;
                        }
                        default: {
                            this.m_107274_();
                            return;
                        }
                    }
                    nextPos = hitLocation.add(bounceVec);
                    this.moveTo(nextPos);
                    return;
                }
            }
            this.hitAfterHitCount = 0;
            this.setPosition(nextPos);
        }

        protected double getOnHitMotionReduction() {
            return 0.7;
        }

        public abstract ParticleRenderType m_7556_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Factory<T extends ParticleOptions>
    implements ParticleProvider<T> {
        protected final SpriteSet sprite;

        public Factory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public abstract Particle m_6966_(T var1, ClientLevel var2, double var3, double var5, double var7, double var9, double var11, double var13);
    }

    public static abstract class Deserializer<T extends ParticleOptions>
    implements ParticleOptions.Deserializer<T> {
    }

    public static abstract class Data
    implements ParticleOptions {
        public final IWind wind;
        public final Smoke smoke;

        public Data(IWind wind, Smoke smoke) {
            this.wind = wind;
            this.smoke = smoke;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
        }

        public String m_5942_() {
            return BuiltInRegistries.f_257034_.m_7981_((Object)this.m_6012_()).toString();
        }
    }
}

