/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.client.ItemModel;
import com.endertech.minecraft.forge.client.RepaintableBlockModel;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.DataCollector;
import com.endertech.minecraft.forge.data.ForgeEnergy;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.mods.adchimneys.Commands;
import com.endertech.minecraft.mods.adchimneys.blocks.Container;
import com.endertech.minecraft.mods.adchimneys.blocks.Pipe;
import com.endertech.minecraft.mods.adchimneys.blocks.Pump;
import com.endertech.minecraft.mods.adchimneys.data.ModBlockStates;
import com.endertech.minecraft.mods.adchimneys.data.ModBlockTags;
import com.endertech.minecraft.mods.adchimneys.data.ModItemModels;
import com.endertech.minecraft.mods.adchimneys.data.ModItemTags;
import com.endertech.minecraft.mods.adchimneys.data.ModLanguageUS;
import com.endertech.minecraft.mods.adchimneys.data.ModLootTables;
import com.endertech.minecraft.mods.adchimneys.data.ModRecipes;
import com.endertech.minecraft.mods.adchimneys.init.Blocks;
import com.endertech.minecraft.mods.adchimneys.init.CreativeTabs;
import com.endertech.minecraft.mods.adchimneys.init.Emitters;
import com.endertech.minecraft.mods.adchimneys.init.Items;
import com.endertech.minecraft.mods.adchimneys.init.Particles;
import com.endertech.minecraft.mods.adchimneys.init.Tiles;
import com.endertech.minecraft.mods.adchimneys.network.SmokePosMsg;
import com.endertech.minecraft.mods.adchimneys.network.SmokeSourceUpdateMsg;
import com.endertech.minecraft.mods.adchimneys.particles.ModernSmokeParticle;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.MissingMappingsEvent;
import net.minecraftforge.registries.RegistryManager;

@Mod(value="adchimneys")
public class AdChimneys
extends AbstractForgeMod {
    public static final String ID = "adchimneys";
    private static AdChimneys instance;
    public final Emitters emitters;
    public final Blocks blocks;
    public final Items items;
    public final CreativeTabs tabs;
    public final Particles particles;
    public final Tiles tiles;

    public AdChimneys() {
        instance = this;
        this.blocks = new Blocks(this);
        this.items = new Items(this);
        this.tabs = new CreativeTabs(this);
        this.emitters = new Emitters(this);
        this.particles = new Particles(this);
        this.tiles = new Tiles(this);
        this.registerCommonConfig();
        this.registerClientConfig();
        this.getForgeEventBus().addListener(this::remapMissingUnits);
    }

    public static AdChimneys getInstance() {
        return instance;
    }

    public String getId() {
        return ID;
    }

    public void gatherData(DataCollector collector) {
        collector.addBlockAndItemTags(ModBlockTags::new, ModItemTags::new).addRecipes(ModRecipes::new).addLootTables(ModLootTables::new).addBlockStates(ModBlockStates::new).addItemModels(ModItemModels::new).addLanguageUS(ModLanguageUS::new);
    }

    public void commonInit() {
        this.registerNetMessage(SmokePosMsg::new);
        this.registerNetMessage(SmokeSourceUpdateMsg::new);
    }

    public void commonConfigInit(AbstractForgeMod.ConfigValueBuilder value) {
        value.push("Smoke");
        Smoke.defaultColor = value.comment("Default smoke color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)").define("defaultColor", Smoke.getDefaultColor());
        Smoke.maxAmount = value.comment("Maximum smoke particles amount per chimney").defineInRange("maxAmount", 16, IntBounds.between((Integer)1, (Integer)100));
        Smoke.maxIntensity = value.comment("Maximum smoke blow out distance").defineInRange("maxIntencity", 4.0f, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(20.0f)));
        Smoke.maxScale = value.comment("Maximum smoke particles scale").defineInRange("maxScale", 2.5f, FloatBounds.between((Float)Float.valueOf(1.0f), (Float)Float.valueOf(10.0f)));
        Smoke.maxRenderDistance = value.comment("Maximum smoke particles render distance").defineInRange("maxRenderDistance", 128, IntBounds.between((Integer)16, (Integer)256));
        Smoke.replaceVanillaCampfireSmoke = value.comment("Whether to replace vanilla smoke particles from a campfire or not").define("replaceVanillaCampfireSmoke", true);
        value.pop();
        value.shared("Painting");
        value.push("Pipe");
        Pipe.maxPipesAtOnce = value.comment("Number of pipes that can be placed(when holding pipe items in both hands) / broken(when crouching) at once").defineInRange("maxPipesAtOnce", 8, IntBounds.between((Integer)1, (Integer)128));
        value.pop();
        value.shared("Vent");
        value.push("Pump");
        Pump.invertedRedstoneSignal = value.comment("If set to True, the redstone signal will turn the pump off instead of turning it on").define("invertedRedstoneSignal", false);
        value.push("ForgeEnergy");
        Pump.energyStorageEnabled = value.comment("Whether Forge Energy is required or not").define("enabled", false);
        Pump.energyStorageCapacity = value.comment("Maximum amount of energy that can be held").defineInRange("capacity", 10000, ForgeEnergy.StorageProps.CAPACITY_BOUNDS);
        Pump.energyStorageConsumption = value.comment("Amount of energy consumed per operation or second").defineInRange("consumption", 50, ForgeEnergy.StorageProps.CONSUMPTION_BOUNDS);
        value.pop();
        value.pop();
    }

    public void clientConfigInit(AbstractForgeMod.ConfigValueBuilder value) {
        value.push("Smoke");
        Smoke.coloringFactor = value.comment("Affects probability of coloring smoke by chimneys").defineInRange("coloringFactor", 0.1f, GameBounds.FACTOR.getFloatBounds());
        Smoke.maxRenderedParticlesAmount = value.comment("Maximum smoke particles that can be rendered at scene.\nIf exceeded, smoke amount will be reduced proportionally for each rendered chimney").defineInRange("maxRenderedParticlesAmount", 800, IntBounds.between((Integer)0, (Integer)2000));
        Smoke.canCollide = value.comment("If true, smoke particles will collide with obstacles").define("canCollide", true);
        Smoke.emitWithoutChimney = value.comment("If true, all emitters will produce smoke even without connected chimneys").define("emitWithoutChimney", true);
        Smoke.useVanillaParticles = value.comment("Use vanilla smoke particles for compatibility with some mods.\nLimitations: no wind, no coloring, no collisions").define("useVanillaSmokeParticles", false);
        Smoke.colorize = value.comment("Whether to colorize smoke particles or not").define("colorize", true);
        value.pop();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        this.setRenderLayer((Block)this.blocks.stone_chimney.get(), RenderType.m_110457_());
        this.setRenderLayer((Block)this.blocks.metal_chimney.get(), RenderType.m_110457_());
        this.setRenderLayer((Block)this.blocks.glass_chimney.get(), RenderType.m_110466_());
        this.setRenderLayer((Block)this.blocks.stone_vent.get(), RenderType.m_110457_());
        this.setRenderLayer((Block)this.blocks.metal_vent.get(), RenderType.m_110457_());
        this.setRenderLayer((Block)this.blocks.stone_pump.get(), RenderType.m_110457_());
        this.setRenderLayer((Block)this.blocks.metal_pump.get(), RenderType.m_110457_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientReplaceModels(ItemModel.RegistryWrapper registry) {
        this.blocks.streamAll().filter(Container.class::isInstance).flatMap(block -> block.m_49965_().m_61056_().stream()).forEach(state -> registry.replaceModelOf(state, RepaintableBlockModel::new));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)this.particles.modern.get(), ModernSmokeParticle.Factory::new);
    }

    public void tagsUpdated() {
        this.runPostInitRunnables();
    }

    public void registerCommands(ServerCommand command, CommandBuildContext buildContext) {
        command.requires(ServerCommand.OpLevel.MODERATORS);
        command.task("list").executes(Commands::listEmitters, "emitters");
        command.task("identify").executes(Commands::identifyEmitter, "emitter").executes(Commands::identifyBlock, "block").executes(Commands::identifyTile, "tile");
        command.task("reload").executes(Commands::reloadEmitters, "emitters");
        command.task("stats").executes(Commands::showStats, new ServerCommand.Arg[0]);
        command.register();
    }

    public void remapMissingUnits(MissingMappingsEvent event) {
        this.remap(event, ForgeRegistries.Keys.BLOCKS);
        this.remap(event, ForgeRegistries.Keys.ITEMS);
    }

    private <T> void remap(MissingMappingsEvent event, ResourceKey<? extends Registry<T>> key) {
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(key);
        event.getMappings(key, ID).forEach(mapping -> {
            String name = mapping.getKey().m_135815_();
            for (String suffix : List.of("_chimney", "_vent", "_pump")) {
                if (!name.endsWith(suffix)) continue;
                ResourceLocation fixedName = this.getNamespace().location("stone" + suffix);
                Object target = registry.getValue(fixedName);
                if (target != null) {
                    mapping.remap(target);
                    continue;
                }
                mapping.warn();
            }
        });
    }
}

