/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.world;

import com.endertech.minecraft.forge.events.ChunkFullyLoadedEvent;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adchimneys.world.WorldData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Events {
    @SubscribeEvent
    public static void onBlockChanged(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor level = event.getLevel();
        if (GameWorld.isServerSide((LevelReader)level)) {
            WorldData.getData(level).getSmokeLocations().updateSmokeSourceAt(event.getPos());
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkFullyLoadedEvent event) {
        WorldData data = WorldData.getData((LevelAccessor)event.getLevel());
        data.getSmokeLocations().updateSmokeSourcesIn((ChunkAccess)event.getChunk());
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            WorldData data = WorldData.getData((LevelAccessor)level);
            data.getSmokeLocations().removeAllSmokeSourcesIn(event.getChunk());
        }
    }

    @SubscribeEvent
    public static void onChunkDataLoaded(ChunkDataEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            WorldData data = WorldData.getData(event.getLevel());
            data.getSmokeLocations().readSmokeSourceLocationsFrom(event.getChunk(), event.getData());
        }
    }

    @SubscribeEvent
    public static void onChunkDataSaved(ChunkDataEvent.Save event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            WorldData data = WorldData.getData(event.getLevel());
            data.getSmokeLocations().writeSmokeSourceLocationsTo(event.getChunk(), event.getData());
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side.isServer()) {
            Level level = event.level;
            WorldData.getData((LevelAccessor)level).getSmokeLocations().onServerTick();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        ClientLevel level;
        if (event.phase == TickEvent.Phase.END && (level = Minecraft.m_91087_().f_91073_) != null) {
            WorldData.getData((LevelAccessor)level).getSmokeLocations().onClientTick();
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor level = event.getLevel();
        if (GameWorld.isServerSide((LevelReader)level)) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        LevelAccessor world = event.getLevel();
        WorldData.DATA_MAP.remove(world);
    }
}

