/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wile.anthillinside.ModConfig;
import wile.anthillinside.ModContent;
import wile.anthillinside.blocks.RedAntHive;
import wile.anthillinside.libmc.detail.Auxiliaries;
import wile.anthillinside.libmc.detail.Networking;
import wile.anthillinside.libmc.detail.Overlay;

@Mod(value="anthillinside")
public class ModAnthillInside {
    public static final String MODID = "anthillinside";
    public static final String MODNAME = "Anthill Inside";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final ItemGroup ITEMGROUP = new ItemGroup("tabanthillinside"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ModContent.ANTS_ITEM);
        }
    };

    public ModAnthillInside() {
        Auxiliaries.init(MODID, LOGGER, ModConfig::getServerConfig);
        Auxiliaries.logGitVersion(MODNAME);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ForgeEvents::onConfigLoad);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ForgeEvents::onConfigReload);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ModConfig.COMMON_CONFIG_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(ForgeEvents::onBlockBroken);
    }

    public static final Logger logger() {
        return LOGGER;
    }

    private void onSetup(FMLCommonSetupEvent event) {
        Networking.init(MODID);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        Overlay.register();
        ModContent.registerTileEntityRenderers();
        ModContent.registerContainerGuis();
        ModContent.processContentClientSide();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static final class ForgeEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            ModContent.allBlocks().forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e));
        }

        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> event) {
            ModContent.allItems().forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e));
            ItemTags.createOptional((ResourceLocation)new ResourceLocation(ModAnthillInside.MODID, "fertilizers"));
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
            ModContent.allTileEntityTypes().forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e));
        }

        @SubscribeEvent
        public static void onRegisterEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
            ModContent.allEntityTypes().forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e));
        }

        @SubscribeEvent
        public static void onRegisterContainerTypes(RegistryEvent.Register<ContainerType<?>> event) {
            ModContent.allContainerTypes().forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e));
        }

        public static void onConfigLoad(ModConfig.Loading configEvent) {
            ModConfig.apply();
        }

        public static void onConfigReload(ModConfig.Reloading configEvent) {
            try {
                ModAnthillInside.logger().info("Config file changed {}", (Object)configEvent.getConfig().getFileName());
                ModConfig.apply();
            }
            catch (Throwable e) {
                ModAnthillInside.logger().error("Failed to load changed config: " + e.getMessage());
            }
        }

        public static void onBlockBroken(BlockEvent.BreakEvent event) {
            if (event.getState() == null || event.getPlayer() == null) {
                return;
            }
            RedAntHive.onGlobalPlayerBlockBrokenEvent(event.getState(), (IWorld)((ServerWorld)event.getWorld()), event.getPos(), event.getPlayer());
        }
    }
}

