/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside;

import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;
import wile.anthillinside.ModAnthillInside;
import wile.anthillinside.ModContent;
import wile.anthillinside.blocks.RedAntHive;
import wile.anthillinside.blocks.RedAntTrail;

public class ModConfig {
    private static final Logger LOGGER = ModAnthillInside.LOGGER;
    private static final String MODID = "anthillinside";
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_CONFIG_SPEC;
    private static final CompoundNBT server_config_;
    private static HashSet<String> optouts_;
    private static boolean with_experimental_features_;
    private static boolean with_config_logging_;

    public static final boolean isOptedOut(@Nullable Block block) {
        return ModConfig.isOptedOut(block.func_199767_j());
    }

    public static final boolean isOptedOut(@Nullable Item item) {
        return item != null && optouts_.contains(item.getRegistryName().func_110623_a());
    }

    public static boolean withExperimental() {
        return with_experimental_features_;
    }

    public static boolean withoutRecipes() {
        return false;
    }

    public static boolean withDebugLogging() {
        return with_experimental_features_ && with_config_logging_;
    }

    public static final CompoundNBT getServerConfig() {
        return server_config_;
    }

    private static final void updateOptouts() {
        int i;
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        String inc = ((String)ModConfig.COMMON.pattern_includes.get()).toLowerCase().replaceAll("anthillinside:", "").replaceAll("[^*_,a-z0-9]", "");
        if (ModConfig.COMMON.pattern_includes.get() != inc) {
            ModConfig.COMMON.pattern_includes.set((Object)inc);
        }
        String[] incl = inc.split(",");
        for (i = 0; i < incl.length; ++i) {
            incl[i] = incl[i].replaceAll("[*]", ".*?");
            if (incl[i].isEmpty()) continue;
            includes.add(incl[i]);
        }
        String exc = ((String)ModConfig.COMMON.pattern_excludes.get()).toLowerCase().replaceAll("anthillinside:", "").replaceAll("[^*_,a-z0-9]", "");
        String[] excl = exc.split(",");
        for (i = 0; i < excl.length; ++i) {
            excl[i] = excl[i].replaceAll("[*]", ".*?");
            if (excl[i].isEmpty()) continue;
            excludes.add(excl[i]);
        }
        if (!excludes.isEmpty()) {
            ModConfig.log("Config pattern excludes: '" + String.join((CharSequence)",", excludes) + "'");
        }
        if (!includes.isEmpty()) {
            ModConfig.log("Config pattern includes: '" + String.join((CharSequence)",", includes) + "'");
        }
        HashSet optouts = new HashSet();
        ModContent.getRegisteredItems().stream().filter(item -> {
            if (item == null) {
                return true;
            }
            try {
                String rn = item.getRegistryName().func_110623_a();
                try {
                    for (String e : includes) {
                        if (!rn.matches(e)) continue;
                        return false;
                    }
                    for (String e : excludes) {
                        if (!rn.matches(e)) continue;
                        return true;
                    }
                }
                catch (Throwable ex) {
                    LOGGER.error("optout include pattern failed, disabling.");
                    includes.clear();
                    excludes.clear();
                }
            }
            catch (Exception ex) {
                LOGGER.error("Exception evaluating the optout config: '" + ex.getMessage() + "'");
            }
            return false;
        }).forEach(e -> optouts.add(e.getRegistryName().func_110623_a()));
        ModContent.getRegisteredBlocks().stream().filter(e -> e == null || ModConfig.isOptedOut(e.func_199767_j())).forEach(e -> optouts.add(e.getRegistryName().func_110623_a()));
        optouts_ = optouts;
        String s = String.join((CharSequence)",", optouts_);
        server_config_.func_74778_a("optout", s);
        if (!s.isEmpty()) {
            ModConfig.log("Opt-outs:" + s);
        }
    }

    public static final void apply() {
        if (!COMMON_CONFIG_SPEC.isLoaded()) {
            return;
        }
        with_config_logging_ = (Boolean)ModConfig.COMMON.with_config_logging.get();
        with_experimental_features_ = (Boolean)ModConfig.COMMON.with_experimental.get();
        if (with_experimental_features_) {
            LOGGER.info("Config: EXPERIMENTAL FEATURES ENABLED.");
        }
        ModConfig.updateOptouts();
        RedAntTrail.on_config((Integer)ModConfig.COMMON.trail_speed_percent.get());
        RedAntHive.on_config((Integer)ModConfig.COMMON.hive_drop_chance_percent.get(), (Integer)ModConfig.COMMON.hive_processing_speed_percent.get(), (Integer)ModConfig.COMMON.hive_sugar_boost_time_s.get(), (Integer)ModConfig.COMMON.hive_growth_period_s.get(), (Integer)ModConfig.COMMON.hive_animal_feeding_speed_percent.get(), 16, 3, (Integer)ModConfig.COMMON.hive_farming_speed_percent.get());
    }

    public static final void log(String config_message) {
        if (!with_config_logging_) {
            return;
        }
        LOGGER.info(config_message);
    }

    static {
        Pair common_ = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_CONFIG_SPEC = (ForgeConfigSpec)common_.getRight();
        COMMON = (CommonConfig)common_.getLeft();
        server_config_ = new CompoundNBT();
        optouts_ = new HashSet();
        with_experimental_features_ = false;
        with_config_logging_ = false;
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.ConfigValue<String> pattern_excludes;
        public final ForgeConfigSpec.ConfigValue<String> pattern_includes;
        public final ForgeConfigSpec.BooleanValue with_experimental;
        public final ForgeConfigSpec.BooleanValue with_config_logging;
        public final ForgeConfigSpec.IntValue trail_speed_percent;
        public final ForgeConfigSpec.IntValue hive_drop_chance_percent;
        public final ForgeConfigSpec.IntValue hive_processing_speed_percent;
        public final ForgeConfigSpec.IntValue hive_sugar_boost_time_s;
        public final ForgeConfigSpec.IntValue hive_growth_period_s;
        public final ForgeConfigSpec.IntValue hive_animal_feeding_speed_percent;
        public final ForgeConfigSpec.IntValue hive_farming_speed_percent;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings affecting the logical server side.").push("server");
            builder.comment("Opt-out settings").push("optout");
            this.pattern_excludes = builder.translation("anthillinside.config.pattern_excludes").comment("Opt-out any block by its registry name ('*' wildcard matching, comma separated list, whitespaces ignored. You must match the whole name, means maybe add '*' also at the begin and end. Example: '*wood*,*steel*' excludes everything that has 'wood' or 'steel' in the registry name. The matching result is also traced in the log file. ").define("pattern_excludes", (Object)"");
            this.pattern_includes = builder.translation("anthillinside.config.pattern_includes").comment("Prevent blocks from being opt'ed by registry name ('*' wildcard matching, comma separated list, whitespaces ignored. Evaluated before all other opt-out checks. You must match the whole name, means maybe add '*' also at the begin and end. Example: '*wood*,*steel*' includes everything that has 'wood' or 'steel' in the registry name.The matching result is also traced in the log file.").define("pattern_includes", (Object)"");
            builder.pop();
            builder.comment("Miscellaneous settings").push("miscellaneous");
            this.with_experimental = builder.translation("anthillinside.config.with_experimental").comment("Enables experimental features. Use at own risk.").define("with_experimental", false);
            this.with_config_logging = builder.translation("anthillinside.config.with_config_logging").comment("Enable detailed logging of the config values and resulting calculations in each mod feature config.").define("with_config_logging", false);
            builder.pop();
            builder.comment("Tweak settings").push("tweaks");
            this.trail_speed_percent = builder.translation("anthillinside.config.trail_speed_percent").comment("Sets how fast the Red Ant Trail conveys items.").defineInRange("trail_speed_percent", 100, 50, 125);
            this.hive_drop_chance_percent = builder.translation("anthillinside.config.hive_drop_chance_percent").comment("Sets how probable it is that a Red Ant Hive drops when manually mining Redstone Ore.").defineInRange("hive_drop_chance_percent", 3, 1, 20);
            this.hive_processing_speed_percent = builder.translation("anthillinside.config.hive_processing_speed_percent").comment("Sets how fast the ant processing part of work process is (in percent).").defineInRange("hive_processing_speed_percent", 100, 50, 150);
            this.hive_sugar_boost_time_s = builder.translation("anthillinside.config.hive_sugar_boost_time_s").comment("Sets how long the Red Sugar boost lasts (in seconds).").defineInRange("hive_sugar_boost_time_s", 5, 1, 60);
            this.hive_growth_period_s = builder.translation("anthillinside.config.hive_growth_period_s").comment("Sets how long it takes (seconds, in average) to generate one new ant in a hive.").defineInRange("hive_growth_period_s", 120, 60, 600);
            this.hive_animal_feeding_speed_percent = builder.translation("anthillinside.config.hive_animal_feeding_speed_percent").comment("Tunes the internal delay between animals are fed. The value 0 disables animal feeding.").defineInRange("hive_animal_feeding_speed_percent", 100, 0, 150);
            this.hive_farming_speed_percent = builder.translation("anthillinside.config.hive_farming_speed_percent").comment("Tunes the internal delay between harvesting crops. The value 0 disables harvesting.").defineInRange("hive_farming_speed_percent", 100, 0, 150);
            builder.pop();
        }
    }
}

