/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.Rarity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Logger;
import wile.anthillinside.ModAnthillInside;
import wile.anthillinside.blocks.RedAntHive;
import wile.anthillinside.blocks.RedAntTrail;
import wile.anthillinside.items.AntsItem;
import wile.anthillinside.items.RedSugarItem;
import wile.anthillinside.libmc.blocks.StandardBlocks;
import wile.anthillinside.libmc.detail.Auxiliaries;

public class ModContent {
    private static final Logger LOGGER = ModAnthillInside.LOGGER;
    private static final String MODID = "anthillinside";
    public static final RedAntHive.RedAntHiveBlock HIVE_BLOCK = (RedAntHive.RedAntHiveBlock)new RedAntHive.RedAntHiveBlock(41L, AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185851_d), new AxisAlignedBB[]{Auxiliaries.getPixeledAABB(1.0, 1.0, 0.0, 15.0, 15.0, 1.0), Auxiliaries.getPixeledAABB(0.0, 0.0, 1.0, 16.0, 16.0, 16.0)}).setRegistryName(new ResourceLocation("anthillinside", "hive"));
    public static final RedAntTrail.RedAntTrailBlock TRAIL_BLOCK = (RedAntTrail.RedAntTrailBlock)new RedAntTrail.RedAntTrailBlock(52L, AbstractBlock.Properties.func_200949_a((Material)Material.field_151594_q, (MaterialColor)MaterialColor.field_151650_B).func_200948_a(0.1f, 3.0f).func_200947_a(SoundType.field_222472_s).func_200942_a().func_226896_b_().func_235827_a_((s, w, p, e) -> false).func_226898_c_(1.2f).func_200944_c()).setRegistryName(new ResourceLocation("anthillinside", "trail"));
    private static final Block[] modBlocks = new Block[]{HIVE_BLOCK, TRAIL_BLOCK};
    public static final RedSugarItem RED_SUGAR_ITEM = (RedSugarItem)new RedSugarItem(ModContent.default_item_properties().func_208103_a(Rarity.UNCOMMON)).setRegistryName("anthillinside", "red_sugar");
    public static final AntsItem ANTS_ITEM = (AntsItem)new AntsItem(TRAIL_BLOCK, ModContent.default_item_properties().func_208103_a(Rarity.UNCOMMON)).setRegistryName("anthillinside", "ants");
    private static final Item[] modItems = new Item[]{RED_SUGAR_ITEM, ANTS_ITEM};
    public static final TileEntityType<?> TET_HIVE = (TileEntityType)TileEntityType.Builder.func_223042_a(RedAntHive.RedAntHiveTileEntity::new, (Block[])new Block[]{HIVE_BLOCK}).func_206865_a(null).setRegistryName("anthillinside", "te_hive");
    private static final TileEntityType<?>[] tile_entity_types = new TileEntityType[]{TET_HIVE};
    private static final EntityType<?>[] entity_types = new EntityType[0];
    public static final ContainerType<RedAntHive.RedAntHiveContainer> CT_HIVE = new ContainerType(RedAntHive.RedAntHiveContainer::new);
    private static final ContainerType<?>[] container_types;
    private static final List<Item> registeredItems;

    private static Item.Properties default_item_properties() {
        return new Item.Properties().func_200916_a(ModAnthillInside.ITEMGROUP);
    }

    public static List<Block> allBlocks() {
        return Arrays.asList(modBlocks);
    }

    public static List<Item> allItems() {
        if (!registeredItems.isEmpty()) {
            return registeredItems;
        }
        HashMap<ResourceLocation, Object> items = new HashMap<ResourceLocation, Object>();
        for (Item item : modItems) {
            items.put(item.getRegistryName(), item);
        }
        for (Item item : modBlocks) {
            BlockItem item2;
            ResourceLocation rl = item.getRegistryName();
            if (rl == null || items.containsValue(item2 = item instanceof StandardBlocks.IBlockItemFactory ? ((StandardBlocks.IBlockItemFactory)item).getBlockItem((Block)item, new Item.Properties().func_200916_a(ModAnthillInside.ITEMGROUP)) : new BlockItem((Block)item, new Item.Properties().func_200916_a(ModAnthillInside.ITEMGROUP))) || items.containsKey(item2.getRegistryName())) continue;
            items.put(rl, item2.setRegistryName(rl));
        }
        registeredItems.addAll(items.values());
        return registeredItems;
    }

    public static List<EntityType<?>> allEntityTypes() {
        return Arrays.asList(entity_types);
    }

    public static List<ContainerType<?>> allContainerTypes() {
        return Arrays.asList(container_types);
    }

    public static List<TileEntityType<?>> allTileEntityTypes() {
        return Arrays.asList(tile_entity_types);
    }

    public static boolean isExperimentalBlock(Block block) {
        return false;
    }

    @Nonnull
    public static List<Block> getRegisteredBlocks() {
        return Collections.unmodifiableList(Arrays.asList(modBlocks));
    }

    @Nonnull
    public static List<Item> getRegisteredItems() {
        return Collections.unmodifiableList(Arrays.asList(modItems));
    }

    public static final void registerContainerGuis() {
        ScreenManager.func_216911_a(CT_HIVE, RedAntHive.RedAntHiveGui::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final void registerTileEntityRenderers() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final void processContentClientSide() {
        for (Block block : ModContent.getRegisteredBlocks()) {
            if (!(block instanceof StandardBlocks.IStandardBlock)) continue;
            switch (((StandardBlocks.IStandardBlock)block).getRenderTypeHint()) {
                case CUTOUT: {
                    RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228643_e_());
                    break;
                }
                case CUTOUT_MIPPED: {
                    RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228641_d_());
                    break;
                }
                case TRANSLUCENT: {
                    RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228645_f_());
                    break;
                }
                case TRANSLUCENT_NO_CRUMBLING: {
                    RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228647_g_());
                    break;
                }
            }
        }
    }

    static {
        CT_HIVE.setRegistryName(MODID, "ct_hive");
        container_types = new ContainerType[]{CT_HIVE};
        registeredItems = new ArrayList<Item>();
    }
}

