/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside.blocks;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.TieredItem;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntArray;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import wile.anthillinside.ModConfig;
import wile.anthillinside.ModContent;
import wile.anthillinside.blocks.RedAntTrail;
import wile.anthillinside.libmc.blocks.StandardBlocks;
import wile.anthillinside.libmc.detail.Auxiliaries;
import wile.anthillinside.libmc.detail.Crafting;
import wile.anthillinside.libmc.detail.Inventories;
import wile.anthillinside.libmc.detail.Networking;
import wile.anthillinside.libmc.detail.ToolActions;
import wile.anthillinside.libmc.detail.TooltipDisplay;
import wile.anthillinside.libmc.ui.Containers;
import wile.anthillinside.libmc.ui.Guis;
import wile.anthillinside.libmc.util.IntegralBitSet;

public class RedAntHive {
    private static final Item ANTS_ITEM = ModContent.ANTS_ITEM;
    private static final Item RED_SUGAR_ITEM = ModContent.RED_SUGAR_ITEM;
    private static int hive_drop_probability_percent = 3;
    private static int sugar_boost_time_s = 5;
    private static int hive_growth_latency_s = 120;
    private static int normal_processing_speed_ant_count_percent = 100;
    private static int animal_feeding_speed_percent = 100;
    private static int animal_feeding_entity_limit = 16;
    private static int animal_feeding_xz_radius = 3;
    private static int farming_speed_percent = 100;
    private static int brewing_fuel_efficiency_percent = 75;
    private static final HashMap<Item, Object> processing_command_item_mapping = new HashMap();

    public static void on_config(int ore_minining_spawn_probability_percent, int ant_speed_scaler_percent, int sugar_time_s, int growth_latency_s, int feeding_speed_factor_percent, int feeding_entity_limit, int feeding_xz_radius, int farming_speed_factor_percent) {
        hive_drop_probability_percent = MathHelper.func_76125_a((int)ore_minining_spawn_probability_percent, (int)1, (int)99);
        normal_processing_speed_ant_count_percent = MathHelper.func_76125_a((int)ant_speed_scaler_percent, (int)10, (int)190);
        sugar_boost_time_s = MathHelper.func_76125_a((int)sugar_time_s, (int)1, (int)60);
        hive_growth_latency_s = MathHelper.func_76125_a((int)growth_latency_s, (int)10, (int)600);
        animal_feeding_speed_percent = MathHelper.func_76125_a((int)feeding_speed_factor_percent, (int)0, (int)200);
        animal_feeding_entity_limit = MathHelper.func_76125_a((int)feeding_entity_limit, (int)3, (int)64);
        animal_feeding_xz_radius = MathHelper.func_76125_a((int)feeding_xz_radius, (int)1, (int)5);
        farming_speed_percent = farming_speed_factor_percent < 10 ? 0 : Math.min(farming_speed_factor_percent, 200);
        processing_command_item_mapping.clear();
        processing_command_item_mapping.put(Items.field_221734_cc, IRecipeType.field_222149_a);
        processing_command_item_mapping.put(Items.field_221738_ce, IRecipeType.field_222150_b);
        processing_command_item_mapping.put(Items.field_222102_pI, IRecipeType.field_222151_c);
        processing_command_item_mapping.put(Items.field_222101_pH, IRecipeType.field_222152_d);
        processing_command_item_mapping.put(Items.field_221862_eo, new ProcessingHandler(Items.field_221862_eo, (te, done) -> ((RedAntHiveTileEntity)te).processHopper(), te -> false));
        processing_command_item_mapping.put(Items.field_222035_iX, new ProcessingHandler(Items.field_222035_iX, (te, done) -> ((RedAntHiveTileEntity)te).processComposter(), te -> ((RedAntHiveTileEntity)te).itemPassThroughComposter()));
        processing_command_item_mapping.put(Items.field_151097_aZ, new ProcessingHandler(Items.field_151097_aZ, (te, done) -> ((RedAntHiveTileEntity)te).processShears(), te -> ((RedAntHiveTileEntity)te).processHopper()));
        processing_command_item_mapping.put(Items.field_222088_mr, new ProcessingHandler(Items.field_222088_mr, (te, done) -> ((RedAntHiveTileEntity)te).processBrewing(done), te -> ((RedAntHiveTileEntity)te).itemPassThroughBrewing()));
        processing_command_item_mapping.put(Items.field_222105_pL, new ProcessingHandler(Items.field_222105_pL, (te, done) -> ((RedAntHiveTileEntity)te).processGrindstone(done), te -> ((RedAntHiveTileEntity)te).itemPassThroughGrindstone()));
        if (animal_feeding_speed_percent > 0) {
            processing_command_item_mapping.put(Items.field_151015_O, new ProcessingHandler(Items.field_151015_O, (te, done) -> ((RedAntHiveTileEntity)te).processAnimalFood(Items.field_151015_O), te -> ((RedAntHiveTileEntity)te).itemPassThroughExcept(Items.field_151015_O)));
            processing_command_item_mapping.put(Items.field_151014_N, new ProcessingHandler(Items.field_151014_N, (te, done) -> ((RedAntHiveTileEntity)te).processAnimalFood(Items.field_151014_N), te -> ((RedAntHiveTileEntity)te).itemPassThroughExcept(Items.field_151014_N)));
            processing_command_item_mapping.put(Items.field_151172_bF, new ProcessingHandler(Items.field_151172_bF, (te, done) -> ((RedAntHiveTileEntity)te).processAnimalFood(Items.field_151172_bF), te -> ((RedAntHiveTileEntity)te).itemPassThroughExcept(Items.field_151172_bF)));
        }
        if (farming_speed_percent > 0) {
            processing_command_item_mapping.put(Items.field_151018_J, new ProcessingHandler(Items.field_151018_J, (te, done) -> ((RedAntHiveTileEntity)te).processFarming(Items.field_151018_J), te -> ((RedAntHiveTileEntity)te).itemPassThroughExcept(Items.field_196106_bc)));
            processing_command_item_mapping.put(Items.field_151019_K, new ProcessingHandler(Items.field_151019_K, (te, done) -> ((RedAntHiveTileEntity)te).processFarming(Items.field_151019_K), te -> ((RedAntHiveTileEntity)te).itemPassThroughExcept(Items.field_196106_bc)));
            processing_command_item_mapping.put(Items.field_151012_L, new ProcessingHandler(Items.field_151012_L, (te, done) -> ((RedAntHiveTileEntity)te).processFarming(Items.field_151012_L), te -> ((RedAntHiveTileEntity)te).itemPassThroughExcept(Items.field_196106_bc)));
            processing_command_item_mapping.put(Items.field_234758_kU_, new ProcessingHandler(Items.field_234758_kU_, (te, done) -> ((RedAntHiveTileEntity)te).processFarming(Items.field_234758_kU_), te -> ((RedAntHiveTileEntity)te).itemPassThroughExcept(Items.field_196106_bc)));
        }
        ModConfig.log("Hive:drop-probability:" + hive_drop_probability_percent + "%ant-speed-scaler:" + normal_processing_speed_ant_count_percent + "%growth-time:" + hive_growth_latency_s + "ssugar-time:" + sugar_boost_time_s + "s");
        ModConfig.log("Animals:feeding-speed:" + animal_feeding_speed_percent + "%entity-limit:" + animal_feeding_entity_limit + "xz-radius:" + animal_feeding_xz_radius + "blk");
        ModConfig.log("Crop farming:havesting-speed:" + farming_speed_percent + "%");
        ModConfig.log("Ctrl-Items:" + processing_command_item_mapping.keySet().stream().map(e -> e.getRegistryName().func_110623_a()).collect(Collectors.joining(",")));
    }

    public static void onGlobalPlayerBlockBrokenEvent(BlockState state, IWorld iworld, BlockPos pos, PlayerEntity player) {
        if (!state.func_203425_a(Blocks.field_150450_ax) || iworld.func_201670_d() || !(iworld instanceof World)) {
            return;
        }
        if (iworld.func_201674_k().nextInt(100) >= hive_drop_probability_percent) {
            return;
        }
        World world = (World)iworld;
        Inventories.dropStack(world, Vector3d.func_237489_a_((Vector3i)pos), new ItemStack((IItemProvider)ModContent.HIVE_BLOCK.func_199767_j()));
        world.func_184133_a(null, pos, SoundEvents.field_187713_n, SoundCategory.BLOCKS, 1.0f, 1.4f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class RedAntHiveGui
    extends Guis.ContainerGui<RedAntHiveContainer> {
        protected final Guis.BackgroundImage gui_background_;
        protected final Guis.BackgroundImage grid_background_;
        protected final Guis.BackgroundImage result_background_;
        protected final Guis.BackgroundImage powered_indicator_;
        protected final Guis.BackgroundImage sugar_indicator_;
        protected final Guis.BackgroundImage norecipe_indicator_;
        protected final Guis.BackgroundImage noingredients_indicator_;
        protected final Guis.BackgroundImage nofuel_indicator_;
        protected final Guis.BackgroundImage noants_indicator_;
        protected final Guis.HorizontalProgressBar progress_bar_;
        protected final Guis.CheckBox left_filter_enable_;
        protected final Guis.CheckBox passthrough_enable_;
        protected final TooltipDisplay tooltip_ = new TooltipDisplay();
        protected final PlayerEntity player_;
        protected final RedAntHiveTileEntity.StateFlags state_flags_ = new RedAntHiveTileEntity.StateFlags(0);
        protected final ITextComponent EMPTY_TOOLTIP = new StringTextComponent("");
        protected final List<Item> command_items_with_process_bar = new ArrayList<Item>();
        protected final List<Item> command_items_grid_visible = new ArrayList<Item>();
        protected final List<Item> command_items_result_visible = new ArrayList<Item>();

        public RedAntHiveGui(RedAntHiveContainer container, PlayerInventory player_inventory, ITextComponent title) {
            super(container, player_inventory, title, new ResourceLocation("anthillinside", "textures/gui/hive_gui.png"));
            this.player_ = player_inventory.field_70458_d;
            this.field_146999_f = 176;
            this.field_147000_g = 222;
            this.gui_background_ = new Guis.BackgroundImage(this.background_image, this.field_146999_f, this.field_147000_g, new Guis.Coord2d(0, 0));
            this.grid_background_ = new Guis.BackgroundImage(this.background_image, 54, 54, new Guis.Coord2d(180, 71));
            this.result_background_ = new Guis.BackgroundImage(this.background_image, 22, 18, new Guis.Coord2d(206, 49));
            this.progress_bar_ = new Guis.HorizontalProgressBar(this.background_image, 40, 8, new Guis.Coord2d(180, 0), new Guis.Coord2d(180, 8));
            this.powered_indicator_ = new Guis.BackgroundImage(this.background_image, 9, 8, new Guis.Coord2d(181, 35));
            this.sugar_indicator_ = new Guis.BackgroundImage(this.background_image, 12, 12, new Guis.Coord2d(230, 19));
            this.noants_indicator_ = new Guis.BackgroundImage(this.background_image, 16, 16, new Guis.Coord2d(228, 32));
            this.norecipe_indicator_ = new Guis.BackgroundImage(this.background_image, 16, 16, new Guis.Coord2d(196, 17));
            this.noingredients_indicator_ = new Guis.BackgroundImage(this.background_image, 16, 16, new Guis.Coord2d(212, 17));
            this.nofuel_indicator_ = new Guis.BackgroundImage(this.background_image, 16, 16, new Guis.Coord2d(180, 17));
            this.left_filter_enable_ = new Guis.CheckBox(this.background_image, 5, 6, new Guis.Coord2d(182, 46), new Guis.Coord2d(182, 53)).onclick(box -> container.onGuiAction(box.checked() ? "input-filter-on" : "input-filter-off"));
            this.passthrough_enable_ = new Guis.CheckBox(this.background_image, 11, 6, new Guis.Coord2d(189, 46), new Guis.Coord2d(189, 53)).onclick(box -> container.onGuiAction(box.checked() ? "pass-through-on" : "pass-through-off"));
            this.command_items_with_process_bar.add(Items.field_221734_cc);
            this.command_items_with_process_bar.add(Items.field_221738_ce);
            this.command_items_with_process_bar.add(Items.field_222102_pI);
            this.command_items_with_process_bar.add(Items.field_222101_pH);
            this.command_items_with_process_bar.add(Items.field_222035_iX);
            this.command_items_with_process_bar.add(Items.field_222088_mr);
            this.command_items_with_process_bar.add(Items.field_151015_O);
            this.command_items_with_process_bar.add(Items.field_151014_N);
            this.command_items_with_process_bar.add(Items.field_151172_bF);
            this.command_items_with_process_bar.add(Items.field_151018_J);
            this.command_items_with_process_bar.add(Items.field_151019_K);
            this.command_items_with_process_bar.add(Items.field_151012_L);
            this.command_items_with_process_bar.add(Items.field_234758_kU_);
            this.command_items_with_process_bar.add(Items.field_222105_pL);
            this.command_items_result_visible.add(Items.field_221734_cc);
            this.command_items_result_visible.add(Items.field_221738_ce);
            this.command_items_result_visible.add(Items.field_222102_pI);
            this.command_items_result_visible.add(Items.field_222101_pH);
            this.command_items_result_visible.add(Items.field_222035_iX);
            this.command_items_result_visible.add(Items.field_222088_mr);
            this.command_items_result_visible.add(Items.field_222105_pL);
            this.command_items_grid_visible.add(Items.field_221734_cc);
            this.command_items_grid_visible.add(Items.field_221738_ce);
            this.command_items_grid_visible.add(Items.field_222102_pI);
            this.command_items_grid_visible.add(Items.field_222101_pH);
        }

        private void update() {
            RedAntHiveContainer container = (RedAntHiveContainer)this.func_212873_a_();
            this.state_flags_.value(container.field(0));
            ItemStack cmdstack = container.command_slot.func_75211_c();
            boolean show_process = !cmdstack.func_190926_b() && this.command_items_with_process_bar.contains(cmdstack.func_77973_b());
            this.grid_background_.field_230694_p_ = show_process && this.command_items_grid_visible.contains(cmdstack.func_77973_b()) || !container.grid_storage_slot_range_.func_191420_l();
            container.grid_slots.forEach(slot -> {
                slot.enabled = this.grid_background_.field_230694_p_;
            });
            this.progress_bar_.field_230693_o_ = this.progress_bar_.field_230694_p_ = show_process;
            boolean bl = this.result_background_.field_230694_p_ = show_process && this.command_items_result_visible.contains(cmdstack.func_77973_b());
            if (this.progress_bar_.field_230694_p_) {
                this.progress_bar_.setMaxProgress(container.field(1)).setProgress(container.field(2));
            }
            this.powered_indicator_.field_230694_p_ = this.state_flags_.powered();
            this.sugar_indicator_.field_230694_p_ = this.state_flags_.sugared();
            this.noants_indicator_.field_230694_p_ = this.state_flags_.noants();
            this.norecipe_indicator_.field_230694_p_ = this.state_flags_.norecipe() && !this.noants_indicator_.field_230694_p_;
            this.noingredients_indicator_.field_230694_p_ = this.state_flags_.noingr() && !this.noants_indicator_.field_230694_p_;
            this.nofuel_indicator_.field_230694_p_ = this.state_flags_.nofuel() && !this.noants_indicator_.field_230694_p_;
            this.left_filter_enable_.checked(this.state_flags_.filteredinsert());
            this.passthrough_enable_.checked(!this.state_flags_.nopassthrough());
        }

        public void func_231160_c_() {
            super.func_231160_c_();
            this.gui_background_.init((Screen)this, new Guis.Coord2d(0, 0)).show();
            this.grid_background_.init((Screen)this, new Guis.Coord2d(61, 71)).hide();
            this.result_background_.init((Screen)this, new Guis.Coord2d(87, 49)).hide();
            this.powered_indicator_.init((Screen)this, new Guis.Coord2d(153, 6)).hide();
            this.sugar_indicator_.init((Screen)this, new Guis.Coord2d(47, 20)).hide();
            this.norecipe_indicator_.init((Screen)this, new Guis.Coord2d(92, 50)).hide();
            this.noingredients_indicator_.init((Screen)this, new Guis.Coord2d(92, 50)).hide();
            this.nofuel_indicator_.init((Screen)this, new Guis.Coord2d(92, 50)).hide();
            this.noants_indicator_.init((Screen)this, new Guis.Coord2d(92, 50)).hide();
            this.func_230480_a_(this.progress_bar_.init((Screen)this, new Guis.Coord2d(69, 38)));
            this.func_230480_a_(this.left_filter_enable_.init((Screen)this, new Guis.Coord2d(20, 126)));
            this.func_230480_a_(this.passthrough_enable_.init((Screen)this, new Guis.Coord2d(28, 126)));
            this.left_filter_enable_.checked(this.state_flags_.filteredinsert());
            this.passthrough_enable_.checked(!this.state_flags_.nopassthrough());
            String prefix = ModContent.HIVE_BLOCK.func_149739_a() + ".tooltips.";
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            this.tooltip_.init(new TooltipDisplay.TipRange(x0 + 164, y0 + 6, 7, 9, () -> new TranslationTextComponent(prefix + "help")), new TooltipDisplay.TipRange(this.powered_indicator_.field_230690_l_, this.powered_indicator_.field_230691_m_, this.powered_indicator_.func_230998_h_(), this.powered_indicator_.getHeight(), () -> this.powered_indicator_.field_230694_p_ ? new TranslationTextComponent(prefix + "powered") : this.EMPTY_TOOLTIP), new TooltipDisplay.TipRange(this.sugar_indicator_.field_230690_l_, this.sugar_indicator_.field_230691_m_, this.sugar_indicator_.func_230998_h_(), this.sugar_indicator_.getHeight(), () -> this.sugar_indicator_.field_230694_p_ ? new TranslationTextComponent(prefix + "sugartrip") : this.EMPTY_TOOLTIP), new TooltipDisplay.TipRange(this.norecipe_indicator_.field_230690_l_, this.norecipe_indicator_.field_230691_m_, this.norecipe_indicator_.func_230998_h_(), this.norecipe_indicator_.getHeight(), () -> this.norecipe_indicator_.field_230694_p_ ? new TranslationTextComponent(prefix + "norecipe") : this.EMPTY_TOOLTIP), new TooltipDisplay.TipRange(this.noingredients_indicator_.field_230690_l_, this.noingredients_indicator_.field_230691_m_, this.noingredients_indicator_.func_230998_h_(), this.noingredients_indicator_.getHeight(), () -> this.noingredients_indicator_.field_230694_p_ ? new TranslationTextComponent(prefix + "noingredients") : this.EMPTY_TOOLTIP), new TooltipDisplay.TipRange(this.nofuel_indicator_.field_230690_l_, this.nofuel_indicator_.field_230691_m_, this.nofuel_indicator_.func_230998_h_(), this.nofuel_indicator_.getHeight(), () -> this.nofuel_indicator_.field_230694_p_ ? new TranslationTextComponent(prefix + "nofuel") : this.EMPTY_TOOLTIP), new TooltipDisplay.TipRange(this.noants_indicator_.field_230690_l_, this.noants_indicator_.field_230691_m_, this.noants_indicator_.func_230998_h_(), this.noants_indicator_.getHeight(), () -> this.noants_indicator_.field_230694_p_ ? new TranslationTextComponent(prefix + "noants") : this.EMPTY_TOOLTIP), new TooltipDisplay.TipRange(x0 + 12, y0 + 22, 8, 8, () -> new TranslationTextComponent(prefix + "inputside")), new TooltipDisplay.TipRange(x0 + 156, y0 + 112, 8, 8, () -> new TranslationTextComponent(prefix + "outputside")), new TooltipDisplay.TipRange(x0 + 28, y0 + 126, 11, 6, () -> new TranslationTextComponent(prefix + "passthroughlock")), new TooltipDisplay.TipRange(x0 + 20, y0 + 126, 5, 6, () -> new TranslationTextComponent(prefix + "insertionlock")), new TooltipDisplay.TipRange(x0 + 26, y0 + 18, 16, 16, () -> ((RedAntHiveContainer)this.func_212873_a_()).input_selection_slot.func_75216_d() ? this.EMPTY_TOOLTIP : new TranslationTextComponent(prefix + "inputselect")), new TooltipDisplay.TipRange(x0 + 134, y0 + 108, 16, 16, () -> ((RedAntHiveContainer)this.func_212873_a_()).output_selection_slot.func_75216_d() ? this.EMPTY_TOOLTIP : new TranslationTextComponent(prefix + "outputselect")), new TooltipDisplay.TipRange(x0 + 70, y0 + 50, 16, 16, () -> ((RedAntHiveContainer)this.func_212873_a_()).command_slot.func_75216_d() ? this.EMPTY_TOOLTIP : new TranslationTextComponent(prefix + "workselect")), new TooltipDisplay.TipRange(x0 + 62, y0 + 18, 52, 16, () -> ((RedAntHiveContainer)this.func_212873_a_()).ant_slot_range_.func_191420_l() ? new TranslationTextComponent(prefix + "antslots") : this.EMPTY_TOOLTIP)).delay(400);
            this.update();
        }

        public void func_231023_e_() {
            super.func_231023_e_();
            this.update();
        }

        public void func_230430_a_(MatrixStack mx, int mouseX, int mouseY, float partialTicks) {
            this.func_230446_a_(mx);
            super.func_230430_a_(mx, mouseX, mouseY, partialTicks);
            if (!this.tooltip_.render(mx, this, mouseX, mouseY)) {
                this.func_230459_a_(mx, mouseX, mouseY);
            }
        }

        protected void func_230451_b_(MatrixStack mx, int x, int y) {
            this.field_230712_o_.func_243248_b(mx, this.field_230704_d_, (float)this.field_238742_p_ + 1.0f, (float)this.field_238743_q_ + 1.0f, 0x303030);
        }

        protected void func_184098_a(Slot slot, int slotId, int button, ClickType type) {
            this.tooltip_.resetTimer();
            super.func_184098_a(slot, slotId, button, type);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
            this.tooltip_.resetTimer();
            return super.func_231044_a_(mouseX, mouseY, mouseButton);
        }

        protected void func_230450_a_(MatrixStack mx, float partialTicks, int mouseX, int mouseY) {
            Slot slot;
            int i;
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.getMinecraft().func_110434_K().func_110577_a(this.background_image);
            RedAntHiveContainer container = (RedAntHiveContainer)this.func_212873_a_();
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            int w = this.getXSize();
            int h = this.getYSize();
            this.gui_background_.draw(mx, (Screen)this);
            this.grid_background_.draw(mx, (Screen)this);
            this.result_background_.draw(mx, (Screen)this);
            this.powered_indicator_.draw(mx, (Screen)this);
            this.sugar_indicator_.draw(mx, (Screen)this);
            this.norecipe_indicator_.draw(mx, (Screen)this);
            this.noants_indicator_.draw(mx, (Screen)this);
            this.noingredients_indicator_.draw(mx, (Screen)this);
            this.nofuel_indicator_.draw(mx, (Screen)this);
            ItemStack stack = container.result_slot.func_75211_c();
            if (!stack.func_190926_b()) {
                this.renderItemTemplate(mx, stack, container.result_slot.field_75223_e, container.result_slot.field_75221_f);
            }
            for (i = 0; i < 3; ++i) {
                slot = container.func_75139_a(20 + i);
                if (!slot.func_75211_c().func_190926_b()) continue;
                this.renderItemTemplate(mx, new ItemStack((IItemProvider)ANTS_ITEM), slot.field_75223_e, slot.field_75221_f);
            }
            if (this.state_flags_.filteredinsert()) {
                for (i = 0; i < 10; ++i) {
                    ItemStack filter_stack;
                    slot = container.func_75139_a(0 + i);
                    if (!slot.func_75211_c().func_190926_b() || (filter_stack = container.left_filter_slot_range_.func_70301_a(i)).func_190926_b()) continue;
                    this.renderItemTemplate(mx, filter_stack, slot.field_75223_e, slot.field_75221_f);
                }
            }
            RenderSystem.disableBlend();
        }
    }

    public static class RedAntHiveContainer
    extends Container
    implements Networking.INetworkSynchronisableContainer {
        private final RedAntHiveTileEntity te_;
        private final PlayerEntity player_;
        private final IWorldPosCallable wpc_;
        private final IIntArray fields_;
        private final Inventories.InventoryRange inventory_;
        private final Inventories.InventoryRange left_storage_slot_range_;
        private final Inventories.InventoryRange left_filter_slot_range_;
        private final Inventories.InventoryRange right_storage_slot_range_;
        private final Inventories.InventoryRange player_inventory_range_;
        private final Inventories.InventoryRange grid_storage_slot_range_;
        private final Inventories.InventoryRange ant_slot_range_;
        public final Containers.StorageSlot command_slot;
        public final Containers.StorageSlot input_selection_slot;
        public final Containers.StorageSlot output_selection_slot;
        public final Containers.LockedSlot result_slot;
        public final List<Containers.StorageSlot> grid_slots;
        private final int storage_slot_count;

        public RedAntHiveContainer(int cid, PlayerInventory player_inventory) {
            this(cid, player_inventory, (IInventory)new Inventory(55), IWorldPosCallable.field_221489_a, (IIntArray)new IntArray(3));
        }

        private RedAntHiveContainer(int cid, PlayerInventory player_inventory, IInventory block_inventory, IWorldPosCallable wpc, IIntArray fields) {
            super(ModContent.CT_HIVE, cid);
            int ypos;
            int xpos;
            int x;
            int y;
            this.wpc_ = wpc;
            this.player_ = player_inventory.field_70458_d;
            this.fields_ = fields;
            this.player_inventory_range_ = Inventories.InventoryRange.fromPlayerInventory(this.player_);
            this.inventory_ = new Inventories.InventoryRange(block_inventory);
            this.inventory_.setValidator(RedAntHiveTileEntity.main_inventory_validator());
            this.left_storage_slot_range_ = new Inventories.InventoryRange(this.inventory_, 0, 10, 5);
            this.left_filter_slot_range_ = new Inventories.InventoryRange(this.inventory_, 45, 10, 5);
            this.right_storage_slot_range_ = new Inventories.InventoryRange(this.inventory_, 10, 10, 5);
            this.grid_storage_slot_range_ = new Inventories.InventoryRange(this.inventory_, 24, 9, 3);
            this.ant_slot_range_ = new Inventories.InventoryRange(this.inventory_, 20, 3, 1);
            this.te_ = this.wpc_.func_221484_a((w, p) -> {
                this.inventory_.func_174889_b(this.player_);
                TileEntity te = w.func_175625_s(p);
                return te instanceof RedAntHiveTileEntity ? (RedAntHiveTileEntity)te : null;
            }).orElse(null);
            int i = -1;
            for (y = 0; y < 5; ++y) {
                for (x = 0; x < 2; ++x) {
                    xpos = 8 + x * 18;
                    ypos = 36 + y * 18;
                    Containers.StorageSlot slot = new Containers.StorageSlot(this.inventory_, ++i, xpos, ypos);
                    int inventory_index = i;
                    if (this.te_ != null) {
                        slot.setSlotChangeNotifier((old_stack, new_stack) -> {
                            if (!old_stack.func_190926_b() || new_stack.func_190926_b()) {
                                return;
                            }
                            if (!this.te_.getStateFlags().filteredinsert() || inventory_index < 0 || inventory_index >= this.left_storage_slot_range_.size()) {
                                return;
                            }
                            ItemStack filter_stack = new_stack.func_77946_l();
                            filter_stack.func_190920_e(1);
                            this.left_filter_slot_range_.func_70299_a(inventory_index, filter_stack);
                            this.sync();
                        });
                    }
                    this.func_75146_a(slot);
                }
            }
            for (y = 0; y < 5; ++y) {
                for (x = 0; x < 2; ++x) {
                    xpos = 134 + x * 18;
                    ypos = 18 + y * 18;
                    this.func_75146_a(new Containers.StorageSlot(this.inventory_, ++i, xpos, ypos));
                }
            }
            for (y = 0; y < 1; ++y) {
                for (x = 0; x < 3; ++x) {
                    xpos = 62 + x * 18;
                    ypos = 18 + y * 18;
                    this.func_75146_a(new Containers.StorageSlot(this.inventory_, ++i, xpos, ypos));
                }
            }
            int xpos2 = 70;
            int ypos2 = 50;
            this.command_slot = new Containers.StorageSlot(this.inventory_, ++i, xpos2, ypos2).setSlotStackLimit(1);
            this.func_75146_a(this.command_slot);
            ArrayList<Containers.StorageSlot> slots = new ArrayList<Containers.StorageSlot>();
            for (int y2 = 0; y2 < 3; ++y2) {
                for (int x2 = 0; x2 < 3; ++x2) {
                    int xpos3 = 62 + x2 * 18;
                    int ypos3 = 72 + y2 * 18;
                    Containers.StorageSlot slot = new Containers.StorageSlot(this.inventory_, ++i, xpos3, ypos3).setSlotStackLimit(1);
                    slots.add(slot);
                    this.func_75146_a(slot);
                }
            }
            this.grid_slots = ImmutableList.copyOf(slots);
            xpos = 26;
            ypos2 = 18;
            this.input_selection_slot = new Containers.StorageSlot(this.inventory_, ++i, xpos, ypos2).setSlotStackLimit(1);
            this.func_75146_a(this.input_selection_slot);
            xpos = 134;
            ypos2 = 108;
            this.output_selection_slot = new Containers.StorageSlot(this.inventory_, ++i, xpos, ypos2).setSlotStackLimit(1);
            this.func_75146_a(this.output_selection_slot);
            xpos = 92;
            ypos2 = 50;
            this.result_slot = new Containers.LockedSlot(this.inventory_, ++i, xpos, ypos2);
            this.func_75146_a(this.result_slot);
            this.result_slot.enabled = false;
            this.storage_slot_count = i + 1;
            while (i < this.inventory_.func_70302_i_() - 1) {
                this.func_75146_a(new Containers.HiddenSlot(this.inventory_, ++i));
            }
            for (int x3 = 0; x3 < 9; ++x3) {
                this.func_75146_a(new Slot((IInventory)player_inventory, x3, 8 + x3 * 18, 198));
            }
            for (int y3 = 0; y3 < 3; ++y3) {
                for (x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)player_inventory, x + y3 * 9 + 9, 8 + x * 18, 140 + y3 * 18));
                }
            }
            this.func_216961_a(this.fields_);
        }

        public final int field(int index) {
            return this.fields_.func_221476_a(index);
        }

        private final void sync() {
            this.inventory_.func_70296_d();
            this.player_.field_71071_by.func_70296_d();
            this.func_75142_b();
        }

        public boolean func_75145_c(PlayerEntity player) {
            return this.inventory_.func_70300_a(player);
        }

        public void func_75134_a(PlayerEntity player) {
            super.func_75134_a(player);
            this.inventory_.func_174886_c(player);
        }

        public ItemStack func_82846_b(PlayerEntity player, int index) {
            int player_start_index = this.inventory_.func_70302_i_();
            Slot slot = this.func_75139_a(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slot_stack = slot.func_75211_c();
            ItemStack transferred = slot_stack.func_77946_l();
            if (index >= 0 && index < player_start_index) {
                if (!this.func_75135_a(slot_stack, player_start_index, player_start_index + 36, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= player_start_index && index <= player_start_index + 36) {
                if (slot_stack.func_77973_b() == ANTS_ITEM) {
                    if (!this.func_75135_a(slot_stack, 20, 23, false)) {
                        return ItemStack.field_190927_a;
                    }
                } else {
                    ItemStack remaining = this.left_storage_slot_range_.insert(slot_stack);
                    if (!remaining.func_190926_b()) {
                        remaining = this.right_storage_slot_range_.insert(remaining.func_77946_l());
                    }
                    if (remaining.func_190916_E() == slot_stack.func_190916_E()) {
                        return ItemStack.field_190927_a;
                    }
                    slot_stack.func_190920_e(remaining.func_190916_E());
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (slot_stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slot_stack.func_190916_E() == transferred.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slot_stack);
            return transferred;
        }

        public ItemStack func_184996_a(int slot, int dragType, ClickType clickType, PlayerEntity player) {
            if (this.te_ == null || slot < 0 || slot >= this.storage_slot_count || dragType != 0 || clickType != ClickType.PICKUP || this.func_75139_a(slot).func_75216_d() || !this.te_.getStateFlags().filteredinsert()) {
                return super.func_184996_a(slot, dragType, clickType, player);
            }
            int index = this.func_75139_a(slot).getSlotIndex() - this.left_storage_slot_range_.offset();
            if (index < 0 || index >= this.left_storage_slot_range_.size()) {
                return super.func_184996_a(slot, dragType, clickType, player);
            }
            ItemStack stack = super.func_184996_a(slot, dragType, clickType, player);
            if (!this.func_75139_a(slot).func_75216_d()) {
                this.left_filter_slot_range_.func_70299_a(index, ItemStack.field_190927_a);
                this.sync();
            }
            return stack;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(CompoundNBT nbt) {
            Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String key, int value) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a(key, value);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String message) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("action", message);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String message, CompoundNBT nbt) {
            nbt.func_74778_a("action", message);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
        }

        @Override
        public void onServerPacketReceived(int windowId, CompoundNBT nbt) {
        }

        @Override
        public void onClientPacketReceived(int windowId, PlayerEntity player, CompoundNBT nbt) {
            if (!nbt.func_74764_b("action")) {
                return;
            }
            boolean changed = false;
            int slotId = nbt.func_74764_b("slot") ? nbt.func_74762_e("slot") : -1;
            switch (nbt.func_74779_i("action")) {
                case "input-filter-on": {
                    this.te_.enableInsertionFilter(true);
                    changed = true;
                    break;
                }
                case "input-filter-off": {
                    this.te_.enableInsertionFilter(false);
                    changed = true;
                    break;
                }
                case "pass-through-on": {
                    this.te_.getStateFlags().nopassthrough(false);
                    changed = true;
                    break;
                }
                case "pass-through-off": {
                    this.te_.getStateFlags().nopassthrough(true);
                    changed = true;
                    break;
                }
            }
            if (changed) {
                this.inventory_.func_70296_d();
                player.field_71071_by.func_70296_d();
                this.func_75142_b();
            }
        }
    }

    public static class RedAntHiveTileEntity
    extends TileEntity
    implements ITickableTileEntity,
    INameable,
    INamedContainerProvider {
        public static final int LEFT_STORAGE_NUM_SLOTS = 10;
        public static final int LEFT_STORAGE_NUM_ROWS = 5;
        public static final int LEFT_STORAGE_START = 0;
        public static final int RIGHT_STORAGE_NUM_SLOTS = 10;
        public static final int RIGHT_STORAGE_NUM_ROWS = 5;
        public static final int RIGHT_STORAGE_START = 10;
        public static final int ANT_STORAGE_NUM_SLOTS = 3;
        public static final int ANT_STORAGE_NUM_ROWS = 1;
        public static final int ANT_STORAGE_START = 20;
        public static final int CMD_STORAGE_NUM_SLOTS = 1;
        public static final int CMD_STORAGE_NUM_ROWS = 1;
        public static final int CMD_STORAGE_START = 23;
        public static final int GRID_STORAGE_NUM_SLOTS = 9;
        public static final int GRID_STORAGE_NUM_ROWS = 3;
        public static final int GRID_STORAGE_START = 24;
        public static final int INP_STORAGE_NUM_SLOTS = 1;
        public static final int INP_STORAGE_NUM_ROWS = 1;
        public static final int INP_STORAGE_START = 33;
        public static final int OUT_STORAGE_NUM_SLOTS = 1;
        public static final int OUT_STORAGE_NUM_ROWS = 1;
        public static final int OUT_STORAGE_START = 34;
        public static final int CMD_RESULT_NUM_SLOTS = 1;
        public static final int CMD_RESULT_NUM_ROWS = 1;
        public static final int CMD_RESULT_START = 35;
        public static final int CMD_CACHE_NUM_SLOTS = 9;
        public static final int CMD_CACHE_NUM_ROWS = 3;
        public static final int CMD_CACHE_START = 36;
        public static final int LEFT_FILTER_NUM_SLOTS = 10;
        public static final int LEFT_FILTER_NUM_ROWS = 5;
        public static final int LEFT_FILTER_START = 45;
        public static final int NUM_MAIN_INVENTORY_SLOTS = 55;
        protected final Inventories.StorageInventory main_inventory_;
        protected final Inventories.InventoryRange left_storage_slot_range_;
        protected final Inventories.InventoryRange left_filter_slot_range_;
        protected final Inventories.InventoryRange right_storage_slot_range_;
        protected final Inventories.InventoryRange ant_storage_slot_range_;
        protected final Inventories.InventoryRange grid_storage_slot_range_;
        protected final Inventories.InventoryRange cache_slot_range_;
        protected LazyOptional<? extends IItemHandler> item_handler_;
        public static final int NUM_OF_FIELDS = 3;
        public static final int TICK_INTERVAL = 8;
        public static final int SLOW_INTERVAL = 2;
        private StateFlags state_flags_ = new StateFlags(0);
        private String last_recipe_ = "";
        private int colony_growth_progress_ = 0;
        private int sugar_ticks_ = 0;
        private boolean can_use_sugar_ = false;
        private int ant_count_ = 0;
        private double ant_speed_ = 0.0;
        private double progress_ = 0.0;
        private int max_progress_ = 0;
        private int universal_task_index_ = 0;
        private int fuel_left_ = 0;
        private int tick_timer_ = 0;
        private int slow_timer_ = 0;
        private int input_side_redstone_pulse_time_left_ = 0;
        private int output_side_redstone_pulse_time_left_ = 0;
        private final Map<UUID, Long> entity_handling_cooldowns_ = new HashMap<UUID, Long>();
        protected final IIntArray fields = new IntArray(3){

            public int func_221476_a(int id) {
                switch (id) {
                    case 0: {
                        return state_flags_.int_value();
                    }
                    case 1: {
                        return max_progress_;
                    }
                    case 2: {
                        return (int)progress_;
                    }
                }
                return 0;
            }

            public void func_221477_a(int id, int value) {
                switch (id) {
                    case 0: {
                        state_flags_.value(value);
                        return;
                    }
                    case 1: {
                        max_progress_ = Math.max(value, 0);
                        return;
                    }
                    case 2: {
                        progress_ = MathHelper.func_76125_a((int)value, (int)0, (int)max_progress_);
                        return;
                    }
                }
            }
        };

        public static final BiPredicate<Integer, ItemStack> main_inventory_validator() {
            return (index, stack) -> {
                if (stack.func_77973_b() == ModContent.HIVE_BLOCK.func_199767_j()) {
                    return false;
                }
                if (index >= 20 && index < 23) {
                    return stack.func_77973_b() == ANTS_ITEM;
                }
                if (index >= 23 && index < 24) {
                    return processing_command_item_mapping.containsKey(stack.func_77973_b());
                }
                if (index >= 24 && index < 33) {
                    return stack.func_77973_b() != ANTS_ITEM;
                }
                if (index >= 33 && index < 34) {
                    return stack.func_77973_b() == Items.field_221862_eo;
                }
                if (index >= 34 && index < 35) {
                    return stack.func_77973_b() == Items.field_221862_eo || stack.func_77973_b() == Items.field_221874_eu || stack.func_77973_b() == Items.field_221656_ap;
                }
                return index < 35 || index >= 36;
            };
        }

        public RedAntHiveTileEntity() {
            this(ModContent.TET_HIVE);
        }

        public RedAntHiveTileEntity(TileEntityType<?> te_type) {
            super(te_type);
            this.main_inventory_ = new Inventories.StorageInventory(this, 55).setValidator(RedAntHiveTileEntity.main_inventory_validator());
            this.left_storage_slot_range_ = new Inventories.InventoryRange(this.main_inventory_, 0, 10, 5);
            this.right_storage_slot_range_ = new Inventories.InventoryRange(this.main_inventory_, 10, 10, 5);
            this.ant_storage_slot_range_ = new Inventories.InventoryRange(this.main_inventory_, 20, 3, 1);
            this.grid_storage_slot_range_ = new Inventories.InventoryRange(this.main_inventory_, 24, 9, 3).setMaxStackSize(1);
            this.cache_slot_range_ = new Inventories.InventoryRange(this.main_inventory_, 36, 9, 3);
            this.left_filter_slot_range_ = new Inventories.InventoryRange(this.main_inventory_, 45, 10, 5).setMaxStackSize(1);
            this.item_handler_ = Inventories.MappedItemHandler.createGenericHandler(this.main_inventory_, (slot, stack) -> slot >= this.right_storage_slot_range_.offset() && slot < this.right_storage_slot_range_.offset() + this.right_storage_slot_range_.size(), (slot, stack) -> slot >= this.left_storage_slot_range_.offset() && slot < this.left_storage_slot_range_.offset() + this.left_storage_slot_range_.size() && this.insertionAllowed(this.left_storage_slot_range_.offset() + slot, (ItemStack)stack));
            this.state_flags_.nopassthrough(true);
        }

        public CompoundNBT clear_getnbt() {
            CompoundNBT nbt = new CompoundNBT();
            if (!this.main_inventory_.func_191420_l()) {
                this.writenbt(nbt, false);
            } else {
                this.main_inventory_.func_174888_l();
            }
            return nbt;
        }

        public void readnbt(CompoundNBT nbt, boolean update_packet) {
            this.main_inventory_.load(nbt);
            this.state_flags_.value(nbt.func_74763_f("state_flags"));
            this.progress_ = nbt.func_74769_h("progress");
            this.max_progress_ = nbt.func_74762_e("max_progress");
            this.colony_growth_progress_ = nbt.func_74762_e("colony_growth_progress");
            this.sugar_ticks_ = nbt.func_74762_e("sugar_ticks");
            this.fuel_left_ = nbt.func_74762_e("fuel_left");
            this.last_recipe_ = nbt.func_74779_i("last_recipe");
        }

        protected void writenbt(CompoundNBT nbt, boolean update_packet) {
            this.main_inventory_.save(nbt);
            nbt.func_74772_a("state_flags", this.state_flags_.value());
            nbt.func_74780_a("progress", this.progress_);
            nbt.func_74768_a("max_progress", this.max_progress_);
            nbt.func_74768_a("colony_growth_progress", this.colony_growth_progress_);
            nbt.func_74768_a("sugar_ticks", this.sugar_ticks_);
            nbt.func_74768_a("fuel_left", this.fuel_left_);
            nbt.func_74778_a("last_recipe", this.last_recipe_);
        }

        public void block_updated() {
            this.tick_timer_ = Math.min(this.tick_timer_, 2);
        }

        public int comparatorValue() {
            return 0;
        }

        public void func_230337_a_(BlockState state, CompoundNBT nbt) {
            super.func_230337_a_(state, nbt);
            this.readnbt(nbt, false);
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt, false);
            return nbt;
        }

        public void func_145843_s() {
            super.func_145843_s();
            this.item_handler_.invalidate();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.item_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        public ITextComponent func_200200_C_() {
            Block block = this.func_195044_w().func_177230_c();
            return block != null ? new TranslationTextComponent(block.func_149739_a()) : new StringTextComponent("Hive");
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_200201_e() {
            return this.func_200200_C_();
        }

        public ITextComponent func_145748_c_() {
            return super.func_145748_c_();
        }

        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
            return new RedAntHiveContainer(id, inventory, this.main_inventory_, IWorldPosCallable.func_221488_a((World)this.field_145850_b, (BlockPos)this.field_174879_c), this.fields);
        }

        public void func_73660_a() {
            BlockState state;
            if (this.field_145850_b.func_201670_d() || --this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 8;
            if (this.slow_timer_++ >= 2) {
                this.slow_timer_ = 0;
            }
            if ((state = this.updateBlockstate()) == null || !(state.func_177230_c() instanceof RedAntHiveBlock)) {
                return;
            }
            if (!this.checkColony()) {
                return;
            }
            boolean dirty = false;
            dirty |= this.checkItemOutput();
            dirty |= this.checkWorkProcess();
            if (dirty |= this.checkItemInput()) {
                this.func_70296_d();
            }
        }

        public int getRedstonePower(BlockState state, Direction redstone_side, boolean strong) {
            if (strong) {
                return 0;
            }
            if (this.input_side_redstone_pulse_time_left_ > 0 && redstone_side == state.func_177229_b((Property)RedAntHiveBlock.FACING)) {
                return 15;
            }
            if (this.output_side_redstone_pulse_time_left_ > 0 && redstone_side == ((Direction)state.func_177229_b((Property)RedAntHiveBlock.FACING)).func_176734_d()) {
                return 15;
            }
            return 0;
        }

        protected StateFlags getStateFlags() {
            return this.state_flags_;
        }

        protected boolean isSlowTimerTick() {
            return this.slow_timer_ == 0;
        }

        protected boolean isProcessing() {
            return this.progress_ > 0.0 && this.max_progress_ > 0;
        }

        @Nullable
        BlockState updateBlockstate() {
            BlockState state = this.func_195044_w();
            this.state_flags_.powered(this.func_145831_w().func_175640_z(this.func_174877_v()));
            return state;
        }

        protected void setResultSlot(ItemStack stack) {
            this.main_inventory_.func_70299_a(35, stack);
        }

        protected ItemStack getResultSlot() {
            return this.main_inventory_.func_70301_a(35);
        }

        protected void setCommandSlot(ItemStack stack) {
            this.main_inventory_.func_70299_a(23, stack);
        }

        protected ItemStack getCommandSlot() {
            return this.main_inventory_.func_70301_a(23);
        }

        protected void setInputControlSlot(ItemStack stack) {
            this.main_inventory_.func_70299_a(33, stack);
        }

        protected ItemStack getInputControlSlot() {
            return this.main_inventory_.func_70301_a(33);
        }

        protected void setOutputControlSlot(ItemStack stack) {
            this.main_inventory_.func_70299_a(34, stack);
        }

        protected ItemStack getOutputControlSlot() {
            return this.main_inventory_.func_70301_a(34);
        }

        protected boolean insertionAllowed(int index, ItemStack stack) {
            if (!this.state_flags_.filteredinsert()) {
                return true;
            }
            if (this.left_filter_slot_range_.func_70301_a(index).func_190926_b()) {
                return true;
            }
            return this.left_filter_slot_range_.func_70301_a(index).func_77973_b() == stack.func_77973_b();
        }

        protected ItemStack insertLeft(ItemStack stack) {
            if (!this.state_flags_.filteredinsert()) {
                return this.left_storage_slot_range_.insert(stack);
            }
            ItemStack remaining = stack.func_77946_l();
            for (int i = 0; i < this.left_storage_slot_range_.func_70302_i_() && (this.left_storage_slot_range_.func_70301_a(i).func_190926_b() && !this.left_filter_slot_range_.func_70301_a(i).func_190926_b() && this.left_filter_slot_range_.func_70301_a(i).func_77973_b() != stack.func_77973_b() || !(remaining = this.left_storage_slot_range_.insert(i, remaining)).func_190926_b()); ++i) {
            }
            return remaining;
        }

        public void enableInsertionFilter(boolean enable) {
            this.state_flags_.filteredinsert(enable);
            if (!enable) {
                this.left_filter_slot_range_.func_174888_l();
            } else {
                for (int i = 0; i < this.left_filter_slot_range_.size(); ++i) {
                    ItemStack stack = this.left_storage_slot_range_.func_70301_a(i);
                    if (stack.func_190926_b()) {
                        this.left_filter_slot_range_.func_70299_a(i, ItemStack.field_190927_a);
                        continue;
                    }
                    stack = stack.func_77946_l();
                    stack.func_190920_e(1);
                    this.left_filter_slot_range_.func_70299_a(i, stack);
                }
            }
            this.func_70296_d();
        }

        private AxisAlignedBB workingRange(int xz_radius, int y_height, int y_offset) {
            Direction facing = ((Direction)this.func_195044_w().func_177229_b((Property)RedAntHiveBlock.FACING)).func_176734_d();
            AxisAlignedBB aabb = new AxisAlignedBB((double)(-xz_radius), (double)y_offset, (double)(-xz_radius), (double)(xz_radius + 1), (double)(y_offset + y_height), (double)(xz_radius + 1));
            aabb = facing == Direction.UP ? aabb.func_186670_a(this.func_174877_v().func_177984_a()) : (facing == Direction.DOWN ? aabb.func_186670_a(this.func_174877_v().func_177979_c(y_height)) : aabb.func_186670_a(this.func_174877_v().func_177967_a(facing, xz_radius + 1)));
            return aabb;
        }

        private boolean entityCooldownExpired(UUID uuid) {
            long t = this.entity_handling_cooldowns_.getOrDefault(uuid, 0L);
            if (t <= this.func_145831_w().func_82737_E()) {
                this.entity_handling_cooldowns_.remove(uuid);
                return true;
            }
            return false;
        }

        private void entityCooldown(UUID uuid, int time) {
            long t = this.func_145831_w().func_82737_E();
            this.entity_handling_cooldowns_.put(uuid, t + (long)time);
            if (this.entity_handling_cooldowns_.size() < 128) {
                return;
            }
            this.entity_handling_cooldowns_.keySet().forEach(k -> {
                if (this.entity_handling_cooldowns_.getOrDefault(k, 0L) >= t) {
                    return;
                }
                this.entity_handling_cooldowns_.remove(k);
            });
        }

        private boolean checkColony() {
            int max_ants = this.ant_storage_slot_range_.size() * this.ant_storage_slot_range_.func_70297_j_();
            this.ant_count_ = this.ant_storage_slot_range_.stream().filter(e -> e.func_77973_b() == ANTS_ITEM).mapToInt(ItemStack::func_190916_E).sum();
            this.state_flags_.noants(this.ant_count_ == 0);
            this.sugar_ticks_ = Math.max(this.sugar_ticks_ - 8, 0);
            boolean bl = this.can_use_sugar_ = this.sugar_ticks_ <= 0 && (this.ant_count_ < max_ants || this.isProcessing());
            if (this.can_use_sugar_ && !this.left_storage_slot_range_.extract(new ItemStack((IItemProvider)RED_SUGAR_ITEM, 1)).func_190926_b()) {
                this.sugar_ticks_ = 20 * sugar_boost_time_s;
            }
            this.state_flags_.sugared(this.sugar_ticks_ > 0);
            this.colony_growth_progress_ += 8 * (this.sugar_ticks_ > 0 ? 3 : 1);
            if (this.colony_growth_progress_ >= 20 * hive_growth_latency_s) {
                this.colony_growth_progress_ = 0;
                this.ant_storage_slot_range_.insert(new ItemStack((IItemProvider)ANTS_ITEM));
            }
            if (this.ant_count_ == 0) {
                if (this.progress_ > 0.0) {
                    this.progress_ -= 8.0;
                }
                return false;
            }
            this.ant_speed_ = (this.state_flags_.sugared() ? 2.0 : 1.0) * ((double)this.ant_count_ / (double)max_ants * (0.01 * (double)normal_processing_speed_ant_count_percent));
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean checkItemOutput() {
            BlockPos output_position;
            Direction output_facing;
            int outstack_size;
            block13: {
                BlockState state;
                if (this.output_side_redstone_pulse_time_left_ > 0 && (this.output_side_redstone_pulse_time_left_ -= 8) <= 0) {
                    this.output_side_redstone_pulse_time_left_ = 0;
                    this.field_145850_b.func_190524_a(this.func_174877_v().func_177972_a((Direction)this.func_195044_w().func_177229_b((Property)RedAntHiveBlock.FACING)), this.func_195044_w().func_177230_c(), this.func_174877_v());
                }
                if (this.state_flags_.powered()) {
                    return false;
                }
                if (this.getOutputControlSlot().func_190926_b()) {
                    return false;
                }
                outstack_size = 1 + this.ant_count_ / 96;
                Item control_item = this.getOutputControlSlot().func_77973_b();
                output_facing = (Direction)this.func_195044_w().func_177229_b((Property)RedAntHiveBlock.FACING);
                output_position = this.func_174877_v().func_177972_a(output_facing);
                if (control_item == Items.field_221862_eo) {
                    if (Inventories.insertionPossible(this.func_145831_w(), output_position, output_facing.func_176734_d(), true)) {
                        break block13;
                    } else {
                        BlockState trail_state = this.func_145831_w().func_180495_p(output_position);
                        if (!trail_state.func_203425_a((Block)ModContent.TRAIL_BLOCK)) {
                            return false;
                        }
                        if (output_facing == trail_state.func_177229_b((Property)RedAntTrail.RedAntTrailBlock.HORIZONTAL_FACING)) return false;
                        if (output_facing == Direction.DOWN && ((Boolean)trail_state.func_177229_b((Property)RedAntTrail.RedAntTrailBlock.UP)).booleanValue()) {
                            return false;
                        }
                        Inventories.dropStack(this.func_145831_w(), Vector3d.func_237489_a_((Vector3i)output_position).func_72441_c(0.0, -0.4, 0.0), this.right_storage_slot_range_.extract(1), new Vector3d(0.0, -0.2, 0.0), 0.1, 0.1);
                        return true;
                    }
                }
                if (control_item != Items.field_221874_eu) {
                    if (control_item != Items.field_221656_ap) return false;
                }
                if ((state = this.func_145831_w().func_180495_p(output_position)).func_235785_r_((IBlockReader)this.func_145831_w(), output_position)) {
                    return false;
                }
                ItemStack stack = this.right_storage_slot_range_.extract(1, true);
                if (control_item == Items.field_221656_ap) {
                    Vector3d drop_pos = Vector3d.func_237489_a_((Vector3i)output_position).func_178787_e(Vector3d.func_237491_b_((Vector3i)output_facing.func_176734_d().func_176730_m()).func_186678_a(0.3));
                    Vector3d speed = Vector3d.func_237491_b_((Vector3i)output_facing.func_176730_m()).func_186678_a(0.6);
                    Inventories.dropStack(this.func_145831_w(), drop_pos, stack, speed, 0.1, 0.2);
                    return false;
                }
                Vector3d drop_pos = Vector3d.func_237489_a_((Vector3i)output_position).func_178787_e(Vector3d.func_237491_b_((Vector3i)output_facing.func_176734_d().func_176730_m()).func_186678_a(0.1));
                Vector3d speed = Vector3d.func_237491_b_((Vector3i)output_facing.func_176730_m()).func_186678_a(0.05);
                Inventories.dropStack(this.func_145831_w(), drop_pos, stack, speed, 0.3, 0.02);
                return false;
            }
            for (int slot = 0; slot < this.right_storage_slot_range_.size(); ++slot) {
                ItemStack remaining;
                ItemStack ostack = this.right_storage_slot_range_.func_70301_a(slot);
                if (ostack.func_190926_b()) continue;
                ItemStack stack = ostack.func_77946_l();
                if (stack.func_190916_E() > outstack_size) {
                    stack.func_190920_e(outstack_size);
                }
                if ((remaining = Inventories.insert(this.func_145831_w(), output_position, output_facing.func_176734_d(), stack, false, true)).func_190916_E() == stack.func_190916_E()) continue;
                int n_inserted = stack.func_190916_E() - remaining.func_190916_E();
                this.right_storage_slot_range_.func_70301_a(slot).func_190918_g(n_inserted);
                return true;
            }
            if (!this.right_storage_slot_range_.func_191420_l()) return false;
            if (Inventories.itemhandler(this.func_145831_w(), output_position, output_facing.func_176734_d(), false) != null) return false;
            boolean notify = this.output_side_redstone_pulse_time_left_ <= 0;
            this.output_side_redstone_pulse_time_left_ = 15;
            if (!notify) return false;
            this.field_145850_b.func_190524_a(this.func_174877_v().func_177972_a(output_facing), this.func_195044_w().func_177230_c(), this.func_174877_v());
            return false;
        }

        private boolean checkItemInput() {
            Direction input_facing = ((Direction)this.func_195044_w().func_177229_b((Property)RedAntHiveBlock.FACING)).func_176734_d();
            if (this.input_side_redstone_pulse_time_left_ > 0 && (this.input_side_redstone_pulse_time_left_ -= 8) <= 0) {
                this.input_side_redstone_pulse_time_left_ = 0;
                this.field_145850_b.func_190524_a(this.func_174877_v().func_177972_a(input_facing), this.func_195044_w().func_177230_c(), this.func_174877_v());
            }
            if (this.getInputControlSlot().func_77973_b() != Items.field_221862_eo) {
                return false;
            }
            int instack_size = 1 + this.ant_count_ / 96;
            boolean filtered = this.state_flags_.filteredinsert();
            boolean dirty = false;
            IItemHandler ih = Inventories.itemhandler(this.func_145831_w(), this.func_174877_v().func_177972_a(input_facing), input_facing.func_176734_d(), true);
            if (ih != null) {
                for (int i = 0; i < this.left_storage_slot_range_.size(); ++i) {
                    ItemStack ref_stack = this.left_storage_slot_range_.func_70301_a(i);
                    if (ref_stack.func_190916_E() >= ref_stack.func_77976_d() || ref_stack.func_190916_E() >= this.left_storage_slot_range_.func_70297_j_()) continue;
                    if (ref_stack.func_190926_b()) {
                        ItemStack fetched;
                        if (filtered) {
                            ref_stack = this.left_filter_slot_range_.func_70301_a(i);
                        }
                        if ((fetched = Inventories.extract(ih, ref_stack.func_190926_b() ? null : ref_stack, instack_size, false)).func_190926_b()) continue;
                        this.insertLeft(fetched);
                        return true;
                    }
                    int limit = Math.min(instack_size, ref_stack.func_77976_d() - ref_stack.func_190916_E());
                    ItemStack fetched = Inventories.extract(ih, ref_stack, limit, false);
                    if (fetched.func_190926_b()) continue;
                    this.insertLeft(fetched);
                    return true;
                }
                if (Inventories.itemhandler(this.func_145831_w(), this.func_174877_v().func_177972_a(input_facing), input_facing.func_176734_d(), false) == null) {
                    boolean all_empty = true;
                    for (int i = 0; all_empty && i < ih.getSlots(); ++i) {
                        all_empty = ih.getStackInSlot(i).func_190926_b();
                    }
                    if (all_empty) {
                        boolean notify = this.input_side_redstone_pulse_time_left_ <= 0;
                        this.input_side_redstone_pulse_time_left_ = 15;
                        if (notify) {
                            this.field_145850_b.func_190524_a(this.func_174877_v().func_177972_a(input_facing), this.func_195044_w().func_177230_c(), this.func_174877_v());
                        }
                    }
                }
            }
            Vector3d dvec = Vector3d.func_237491_b_((Vector3i)input_facing.func_176730_m());
            AxisAlignedBB aabb = new AxisAlignedBB(this.func_174877_v()).func_186662_g(0.3).func_191194_a(dvec.func_186678_a(0.3)).func_216361_a(dvec.func_186678_a(1.0));
            List items = this.func_145831_w().func_175647_a(ItemEntity.class, aabb, e -> e.func_70089_S() && !e.func_92059_d().func_190926_b());
            for (ItemEntity ie : items) {
                ItemStack stack = ie.func_92059_d().func_77946_l();
                ItemStack remaining = this.insertLeft(stack);
                if (remaining.func_190916_E() == stack.func_190916_E()) continue;
                dirty = true;
                if (remaining.func_190926_b()) {
                    ie.func_70106_y();
                    continue;
                }
                ie.func_92058_a(remaining);
            }
            return dirty;
        }

        private boolean checkWorkProcess() {
            Object cat = processing_command_item_mapping.getOrDefault(this.getCommandSlot().func_77973_b(), null);
            if (cat == null) {
                this.max_progress_ = 0;
                this.progress_ = 0.0;
                this.last_recipe_ = "";
                this.fuel_left_ = 0;
                this.state_flags_.mask(28L, 0L);
                this.cache_slot_range_.move(this.left_storage_slot_range_);
                if (!this.getResultSlot().func_190926_b()) {
                    this.setResultSlot(ItemStack.field_190927_a);
                    this.entity_handling_cooldowns_.clear();
                    return true;
                }
                return false;
            }
            if (this.progress_ < 0.0) {
                this.progress_ = Math.min(0.0, this.progress_ + 8.0);
                if (this.progress_ < 0.0) {
                    return this.itemPassThrough(cat);
                }
                this.cache_slot_range_.move(this.right_storage_slot_range_);
                return true;
            }
            if (this.max_progress_ > 0 && this.progress_ < (double)this.max_progress_) {
                this.progress_ = Math.min((double)this.max_progress_, this.progress_ + (double)Math.max(8, (int)((1.0 + this.ant_speed_) * 8.0)));
                this.itemPassThrough(cat);
            } else {
                boolean is_done = this.progress_ >= (double)this.max_progress_ && this.max_progress_ > 0;
                this.state_flags_.mask(28L, 0L);
                this.max_progress_ = 0;
                this.progress_ = 0.0;
                if (cat instanceof IRecipeType) {
                    if (cat == IRecipeType.field_222149_a) {
                        this.processCrafting(cat, is_done);
                    } else if (cat == IRecipeType.field_222150_b || cat == IRecipeType.field_222151_c || cat == IRecipeType.field_222152_d) {
                        this.processFurnace(cat, is_done);
                    }
                } else if (cat instanceof ProcessingHandler) {
                    return ((ProcessingHandler)cat).handler.apply(this, is_done);
                }
            }
            return true;
        }

        private boolean itemPassThrough(Object type) {
            if (this.state_flags_.nopassthrough()) {
                return false;
            }
            if (!this.isSlowTimerTick()) {
                return false;
            }
            if (type == IRecipeType.field_222149_a) {
                return this.itemPassThroughCrafting((IRecipeType)type);
            }
            if (type == IRecipeType.field_222150_b || type == IRecipeType.field_222151_c || type == IRecipeType.field_222152_d) {
                return this.itemPassThroughFurnace((IRecipeType)type);
            }
            if (type instanceof ProcessingHandler) {
                return ((ProcessingHandler)type).passthrough_handler.apply(this);
            }
            return false;
        }

        private boolean itemPassThroughExcept(Item except) {
            return this.itemPassThroughExcept(Collections.singletonList(except));
        }

        private boolean itemPassThroughExcept(List<Item> except) {
            for (int i = 0; i < this.left_storage_slot_range_.size(); ++i) {
                ItemStack stack = this.left_storage_slot_range_.func_70301_a(i);
                if (stack.func_190926_b() || stack.func_77973_b() == RED_SUGAR_ITEM || except.contains(stack.func_77973_b()) || !this.left_storage_slot_range_.move(i, this.right_storage_slot_range_)) continue;
                return true;
            }
            return false;
        }

        private boolean processCrafting(IRecipeType<?> recipe_type, boolean is_done) {
            List last;
            this.progress_ = -40.0;
            if (is_done) {
                this.setResultSlot(ItemStack.field_190927_a);
                List<Object> crafting_recipes = !this.last_recipe_.isEmpty() ? Crafting.getCraftingRecipe(this.func_145831_w(), new ResourceLocation(this.last_recipe_)).map(Collections::singletonList).orElse(Collections.emptyList()) : Crafting.get3x3CraftingRecipes(this.func_145831_w(), this.cache_slot_range_);
                if (!crafting_recipes.isEmpty()) {
                    List<ItemStack> remaining = Crafting.get3x3RemainingItems(this.func_145831_w(), this.cache_slot_range_, (ICraftingRecipe)crafting_recipes.get(0));
                    ItemStack result = Crafting.get3x3CraftingResult(this.func_145831_w(), this.cache_slot_range_, (ICraftingRecipe)crafting_recipes.get(0));
                    this.cache_slot_range_.func_174888_l();
                    this.cache_slot_range_.insert(result);
                    for (ItemStack stack : remaining) {
                        if (stack.func_190926_b()) continue;
                        this.cache_slot_range_.insert(stack);
                    }
                    if (this.cache_slot_range_.move(this.right_storage_slot_range_)) {
                        this.progress_ = 0.0;
                        return true;
                    }
                }
                this.progress_ = -8.0;
                return true;
            }
            if (!this.cache_slot_range_.func_191420_l()) {
                return false;
            }
            List<Object> crafting_recipes = Crafting.get3x3CraftingRecipes(this.func_145831_w(), this.grid_storage_slot_range_);
            if (!crafting_recipes.isEmpty() && !this.last_recipe_.isEmpty() && !(last = Crafting.getCraftingRecipe(this.func_145831_w(), new ResourceLocation(this.last_recipe_)).map(Collections::singletonList).orElse(Collections.emptyList())).isEmpty() && crafting_recipes.contains(last.get(0))) {
                crafting_recipes = last;
            }
            if (crafting_recipes.isEmpty()) {
                this.state_flags_.norecipe(true);
                this.last_recipe_ = "";
                return false;
            }
            ICraftingRecipe selected_recipe = null;
            List<Object> selected_placement = Collections.emptyList();
            for (ICraftingRecipe recipe : crafting_recipes) {
                List<ItemStack> placement = Crafting.get3x3Placement(this.func_145831_w(), recipe, this.left_storage_slot_range_, this.grid_storage_slot_range_);
                if (placement.isEmpty()) continue;
                selected_recipe = recipe;
                selected_placement = placement;
                break;
            }
            if (selected_placement.isEmpty()) {
                this.state_flags_.noingr(true);
                return false;
            }
            this.cache_slot_range_.func_174888_l();
            for (int i = 0; i < selected_placement.size(); ++i) {
                this.cache_slot_range_.func_70299_a(i, this.left_storage_slot_range_.extract((ItemStack)selected_placement.get(i)));
            }
            this.setResultSlot(Crafting.get3x3CraftingResult(this.func_145831_w(), this.cache_slot_range_, selected_recipe));
            this.last_recipe_ = selected_recipe.func_199560_c().toString();
            this.progress_ = 0.0;
            this.max_progress_ = 60 + 4 * this.cache_slot_range_.stream().mapToInt(ItemStack::func_190916_E).sum();
            return true;
        }

        private boolean itemPassThroughCrafting(IRecipeType<?> recipe_type) {
            if (this.last_recipe_.isEmpty()) {
                return false;
            }
            ICraftingRecipe recipe = Crafting.getCraftingRecipe(this.func_145831_w(), new ResourceLocation(this.last_recipe_)).orElse(null);
            if (recipe == null) {
                return false;
            }
            List ingredients = recipe.func_192400_c().stream().filter(ing -> ing != Ingredient.field_193370_a).collect(Collectors.toList());
            if (ingredients.isEmpty()) {
                return false;
            }
            for (int i = 0; i < this.left_storage_slot_range_.size(); ++i) {
                ItemStack stack = this.left_storage_slot_range_.func_70301_a(i);
                if (stack.func_77973_b() == RED_SUGAR_ITEM || !ingredients.stream().noneMatch(ing -> ing.test(stack)) || !this.left_storage_slot_range_.move(i, this.right_storage_slot_range_)) continue;
                return true;
            }
            return false;
        }

        private boolean processFurnace(IRecipeType<?> recipe_type, boolean is_done) {
            this.last_recipe_ = "";
            this.progress_ = -40.0;
            if (is_done) {
                if (!this.getResultSlot().func_190926_b()) {
                    this.cache_slot_range_.func_70299_a(0, this.getResultSlot());
                    this.setResultSlot(ItemStack.field_190927_a);
                }
                this.cache_slot_range_.move(this.right_storage_slot_range_);
                if (this.cache_slot_range_.func_191420_l()) {
                    this.progress_ = 0.0;
                }
                this.state_flags_.nofuel(false);
                this.state_flags_.noingr(false);
                return true;
            }
            Inventories.InventoryRange input_slots = this.left_storage_slot_range_;
            List allowed_fuel = this.grid_storage_slot_range_.stream().filter(e -> !e.func_190926_b()).map(ItemStack::func_77973_b).collect(Collectors.toList());
            Tuple recipe_search = input_slots.find((slot, stack) -> {
                if (Crafting.isFuel(this.field_145850_b, stack)) {
                    return Optional.empty();
                }
                Optional<AbstractCookingRecipe> recipe = Crafting.getFurnaceRecipe(recipe_type, this.field_145850_b, stack);
                return recipe.map(r -> new Tuple(slot, r));
            }).orElse(null);
            if (recipe_search == null) {
                recipe_search = input_slots.find((slot, stack) -> {
                    if (!allowed_fuel.isEmpty() && !allowed_fuel.contains(stack.func_77973_b())) {
                        return Optional.empty();
                    }
                    Optional<AbstractCookingRecipe> recipe = Crafting.getFurnaceRecipe(recipe_type, this.field_145850_b, stack);
                    return recipe.map(r -> new Tuple(slot, r));
                }).orElse(null);
            }
            if (recipe_search == null) {
                this.state_flags_.noingr(true);
                return false;
            }
            AbstractCookingRecipe recipe = (AbstractCookingRecipe)recipe_search.func_76340_b();
            int smelting_input_slot = (Integer)recipe_search.func_76341_a();
            int fuel_time_needed = (int)Math.ceil((1.0 + this.ant_speed_) * (double)recipe.func_222137_e());
            int initial_fuel_left = this.fuel_left_;
            boolean enough_fuel = input_slots.iterate((slot, stack) -> {
                if (this.fuel_left_ >= fuel_time_needed) {
                    return true;
                }
                if (slot == smelting_input_slot || stack.func_190926_b()) {
                    return false;
                }
                int t = Crafting.getFuelBurntime(this.field_145850_b, stack);
                if (t <= 0) {
                    return false;
                }
                if (!allowed_fuel.isEmpty() && !allowed_fuel.contains(stack.func_77973_b())) {
                    return false;
                }
                while (stack.func_190916_E() > 0 && this.fuel_left_ < fuel_time_needed) {
                    ItemStack consumed = stack.func_77979_a(1);
                    Tuple<Integer, ItemStack> bt_and_rem = Crafting.consumeFuel(this.func_145831_w(), consumed);
                    this.fuel_left_ += ((Integer)bt_and_rem.func_76341_a()).intValue();
                    if (((ItemStack)bt_and_rem.func_76340_b()).func_190926_b()) continue;
                    ItemStack container_item = (ItemStack)bt_and_rem.func_76340_b();
                    if (stack.func_190926_b()) {
                        stack = container_item;
                        continue;
                    }
                    if (this.right_storage_slot_range_.insert(container_item).func_190926_b()) continue;
                    this.cache_slot_range_.insert(container_item);
                }
                if (stack.func_190926_b()) {
                    stack = ItemStack.field_190927_a;
                }
                input_slots.func_70299_a((int)slot, (ItemStack)stack);
                return false;
            });
            if (!enough_fuel) {
                this.state_flags_.nofuel(true);
                return this.fuel_left_ != initial_fuel_left;
            }
            if (this.fuel_left_ < fuel_time_needed) {
                return true;
            }
            this.state_flags_.nofuel(false);
            this.state_flags_.norecipe(false);
            this.setResultSlot(recipe.func_77571_b());
            this.fuel_left_ -= fuel_time_needed;
            this.max_progress_ = recipe.func_222137_e();
            this.last_recipe_ = recipe.func_199560_c().toString();
            this.progress_ = 0.0;
            this.cache_slot_range_.func_70299_a(0, input_slots.func_70301_a(smelting_input_slot).func_77979_a(1));
            return true;
        }

        private boolean itemPassThroughFurnace(IRecipeType<?> recipe_type) {
            List allowed_fuel = this.grid_storage_slot_range_.stream().filter(e -> !e.func_190926_b()).map(ItemStack::func_77973_b).collect(Collectors.toList());
            List unmatching_slots = this.left_storage_slot_range_.collect((slot, stack) -> {
                if (stack.func_190926_b() || stack.func_77973_b() == RED_SUGAR_ITEM) {
                    return Optional.empty();
                }
                if (Crafting.isFuel(this.field_145850_b, stack) && (allowed_fuel.isEmpty() || allowed_fuel.contains(stack.func_77973_b()))) {
                    return Optional.empty();
                }
                if (Crafting.getFurnaceRecipe(recipe_type, this.field_145850_b, stack).isPresent()) {
                    return Optional.empty();
                }
                return Optional.of(slot);
            });
            if (unmatching_slots.isEmpty()) {
                return false;
            }
            int picked_slot = (Integer)unmatching_slots.get(this.field_145850_b.func_201674_k().nextInt(unmatching_slots.size()));
            return this.left_storage_slot_range_.move(picked_slot, this.right_storage_slot_range_);
        }

        private boolean processComposter() {
            if (this.cache_slot_range_.func_191420_l()) {
                ItemStack bonemeal = new ItemStack((IItemProvider)Items.field_196106_bc);
                int processed = 0;
                for (ItemStack stack : this.left_storage_slot_range_) {
                    double chance;
                    if (stack.func_190926_b() || (chance = Crafting.getCompostingChance(stack)) <= 0.0) continue;
                    ++processed;
                    stack.func_190918_g(1);
                    if (this.func_145831_w().func_201674_k().nextDouble() * 7.0 > chance || this.right_storage_slot_range_.insert(bonemeal).func_190926_b()) continue;
                    this.cache_slot_range_.insert(bonemeal);
                }
                if (processed > 0) {
                    this.state_flags_.noingr(false);
                    this.progress_ = 0.0;
                    this.max_progress_ = 20 + processed * 10;
                    this.setResultSlot(bonemeal);
                    return true;
                }
            }
            this.setResultSlot(ItemStack.field_190927_a);
            this.progress_ = -40.0;
            this.state_flags_.noingr(true);
            return false;
        }

        private boolean itemPassThroughComposter() {
            if (!this.cache_slot_range_.func_191420_l()) {
                return false;
            }
            for (int i = 0; i < this.left_storage_slot_range_.size(); ++i) {
                ItemStack stack = this.left_storage_slot_range_.func_70301_a(i);
                if (stack.func_190926_b() || Crafting.getCompostingChance(stack) > 0.0 || stack.func_77973_b() == RED_SUGAR_ITEM || !this.left_storage_slot_range_.move(i, this.right_storage_slot_range_)) continue;
                return true;
            }
            return false;
        }

        private boolean processHopper() {
            this.progress_ = 0.0;
            this.max_progress_ = 8;
            return this.itemPassThroughExcept(Collections.emptyList());
        }

        private boolean processShears() {
            Direction input_facing = ((Direction)this.func_195044_w().func_177229_b((Property)RedAntHiveBlock.FACING)).func_176734_d();
            boolean snipped = ToolActions.shearPlant(this.func_145831_w(), this.func_174877_v().func_177972_a(input_facing));
            if (!snipped) {
                AxisAlignedBB aabb = new AxisAlignedBB(this.func_174877_v().func_177972_a(input_facing));
                snipped = ToolActions.shearEntities(this.func_145831_w(), aabb, 1);
            }
            if (snipped) {
                this.progress_ = 0.0;
                this.max_progress_ = 120;
            } else {
                this.progress_ = -40.0;
                this.max_progress_ = 0;
            }
            return false;
        }

        private boolean processAnimalFood(Item food) {
            if (animal_feeding_speed_percent <= 0) {
                this.progress_ = -40.0;
                this.max_progress_ = 0;
                return false;
            }
            this.progress_ = 0.0;
            this.max_progress_ = 20000 / animal_feeding_speed_percent;
            ItemStack kibble = new ItemStack((IItemProvider)food, 2);
            if (this.left_storage_slot_range_.stream().filter(s -> s.func_77969_a(kibble)).mapToInt(ItemStack::func_190916_E).sum() <= 0) {
                return false;
            }
            AxisAlignedBB aabb = this.workingRange(animal_feeding_xz_radius, 2, 0);
            List animals = this.func_145831_w().func_175647_a(AnimalEntity.class, aabb, a -> a.func_70089_S());
            double progress_delay = 1.0 / MathHelper.func_151237_a((double)(1.0 - Math.max((double)(animals.size() * animals.size()), 1.0) / Math.max((double)(animal_feeding_entity_limit * animal_feeding_entity_limit), 16.0)), (double)0.05, (double)1.0);
            Auxiliaries.logDebug("" + this.func_174877_v() + ": animals:" + animals.size() + "/" + animal_feeding_entity_limit + " feeding delay rate:" + progress_delay);
            if (animals.size() >= animal_feeding_entity_limit) {
                this.max_progress_ = (int)(600.0 * progress_delay);
                return false;
            }
            if ((animals = animals.stream().filter(a -> !a.func_70631_g_() && a.func_70877_b(kibble) && a.func_204701_dC() && !a.func_70880_s() && this.entityCooldownExpired(a.func_110124_au())).collect(Collectors.toList())).size() >= 2) {
                for (int i = 0; i < animals.size() - 1; ++i) {
                    for (int j = i + 1; j < animals.size(); ++j) {
                        if (((AnimalEntity)animals.get(i)).getClass() != ((AnimalEntity)animals.get(j)).getClass()) continue;
                        this.left_storage_slot_range_.extract(kibble);
                        ((AnimalEntity)animals.get(i)).func_146082_f((PlayerEntity)null);
                        ((AnimalEntity)animals.get(j)).func_146082_f((PlayerEntity)null);
                        int cooldown = (int)((double)(1200000 / animal_feeding_speed_percent) / progress_delay);
                        this.entityCooldown(((AnimalEntity)animals.get(i)).func_110124_au(), cooldown);
                        this.entityCooldown(((AnimalEntity)animals.get(j)).func_110124_au(), cooldown);
                        this.max_progress_ = (int)(600.0 * progress_delay);
                        return false;
                    }
                }
            }
            this.max_progress_ = (int)((double)this.max_progress_ * progress_delay);
            return false;
        }

        private boolean processFarming(Item hoe) {
            if (farming_speed_percent <= 0) {
                this.progress_ = -40.0;
                this.max_progress_ = 0;
                return false;
            }
            this.progress_ = 0.0;
            this.max_progress_ = 30000 / farming_speed_percent;
            boolean dirty = false;
            int range_ref = MathHelper.func_76125_a((int)(hoe instanceof TieredItem ? ((TieredItem)hoe).func_200891_e().func_200925_d() : 0), (int)0, (int)4);
            int range_rad = range_ref + 1;
            Auxiliaries.BlockPosRange range = Auxiliaries.BlockPosRange.of(this.workingRange(range_rad, 1, 0));
            int[] step_sizes = new int[]{5, 13, 31, 47, 71};
            int step_size = step_sizes[range_ref];
            int volume = range.getVolume();
            int max_count = range_ref / 2 + 1;
            int max_search_count = 5;
            ITag fertilizers = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(new ResourceLocation("anthillinside", "fertilizers"));
            int fertilizer_slot = -1;
            if (fertilizers != null) {
                fertilizer_slot = this.left_storage_slot_range_.find((slot, stack) -> stack.func_77973_b().func_206844_a(fertilizers) ? Optional.of(slot) : Optional.empty()).orElse(-1);
            }
            if (fertilizer_slot < 0) {
                fertilizer_slot = this.left_storage_slot_range_.find((slot, stack) -> stack.func_77973_b() == Items.field_196106_bc ? Optional.of(slot) : Optional.empty()).orElse(-1);
            }
            ItemStack fertilizer = fertilizer_slot >= 0 ? this.left_storage_slot_range_.func_70301_a(fertilizer_slot).func_77946_l() : ItemStack.field_190927_a;
            for (int search_count = 5; search_count > 0; --search_count) {
                for (int i = 0; i < max_count; ++i) {
                    this.universal_task_index_ = (this.universal_task_index_ + step_size) % volume;
                    BlockPos pos = range.byXZYIndex(this.universal_task_index_);
                    Optional<List<ItemStack>> drops = ToolActions.harvestCrop((ServerWorld)this.func_145831_w(), pos, true, fertilizer);
                    if (!drops.isPresent()) continue;
                    if (!drops.get().isEmpty()) {
                        this.func_145831_w().func_184133_a(null, pos, SoundEvents.field_219626_bz, SoundCategory.BLOCKS, 0.6f, 1.4f);
                    }
                    for (ItemStack stack2 : drops.get()) {
                        this.right_storage_slot_range_.insert(stack2);
                    }
                    search_count = 0;
                }
            }
            if (fertilizer_slot >= 0) {
                this.left_storage_slot_range_.func_70299_a(fertilizer_slot, fertilizer.func_190926_b() ? ItemStack.field_190927_a : fertilizer);
            }
            return dirty;
        }

        private boolean processBrewing(boolean is_done) {
            this.last_recipe_ = "";
            this.progress_ = -40.0;
            if (is_done) {
                if (!this.getResultSlot().func_190926_b()) {
                    this.cache_slot_range_.func_70299_a(0, this.getResultSlot());
                    this.cache_slot_range_.func_70299_a(1, ItemStack.field_190927_a);
                    this.setResultSlot(ItemStack.field_190927_a);
                }
                this.cache_slot_range_.move(this.right_storage_slot_range_);
                if (this.cache_slot_range_.func_191420_l()) {
                    this.progress_ = 0.0;
                }
                this.state_flags_.nofuel(false);
                this.state_flags_.noingr(false);
                return true;
            }
            Inventories.InventoryRange input_slots = this.left_storage_slot_range_;
            Crafting.BrewingOutput brewing_output = Crafting.BrewingOutput.find(this.field_145850_b, input_slots, input_slots);
            if (brewing_output.item.func_190926_b()) {
                this.state_flags_.noingr(true);
                return false;
            }
            int fuel_time_needed = (int)Math.ceil((1.0 + this.ant_speed_) * (double)brewing_output.brewTime);
            int initial_fuel_left = this.fuel_left_;
            boolean enough_fuel = input_slots.iterate((slot, stack) -> {
                if (this.fuel_left_ >= fuel_time_needed) {
                    return true;
                }
                if (slot == brewing_output.ingredientSlot || slot == brewing_output.potionSlot || stack.func_190926_b()) {
                    return false;
                }
                int t = Crafting.getBrewingFuelBurntime(this.field_145850_b, stack) * brewing_fuel_efficiency_percent / 100;
                if (t <= 0) {
                    return false;
                }
                while (stack.func_190916_E() > 0 && this.fuel_left_ < fuel_time_needed) {
                    ItemStack consumed = stack.func_77979_a(1);
                    Tuple<Integer, ItemStack> bt_and_rem = Crafting.consumeBrewingFuel(this.func_145831_w(), consumed);
                    this.fuel_left_ += ((Integer)bt_and_rem.func_76341_a()).intValue();
                    if (((ItemStack)bt_and_rem.func_76340_b()).func_190926_b()) continue;
                    ItemStack container_item = (ItemStack)bt_and_rem.func_76340_b();
                    if (stack.func_190926_b()) {
                        stack = container_item;
                        continue;
                    }
                    if (this.right_storage_slot_range_.insert(container_item).func_190926_b()) continue;
                    this.cache_slot_range_.insert(container_item);
                }
                if (stack.func_190926_b()) {
                    stack = ItemStack.field_190927_a;
                }
                input_slots.func_70299_a((int)slot, (ItemStack)stack);
                return false;
            });
            if (!enough_fuel) {
                this.state_flags_.nofuel(true);
                return this.fuel_left_ != initial_fuel_left;
            }
            if (this.fuel_left_ < fuel_time_needed) {
                return true;
            }
            this.state_flags_.nofuel(false);
            this.state_flags_.norecipe(false);
            this.setResultSlot(brewing_output.item);
            this.fuel_left_ -= fuel_time_needed;
            this.max_progress_ = brewing_output.brewTime;
            this.progress_ = 0.0;
            this.cache_slot_range_.func_70299_a(0, input_slots.func_70301_a(brewing_output.potionSlot).func_77979_a(1));
            this.cache_slot_range_.func_70299_a(1, input_slots.func_70301_a(brewing_output.ingredientSlot).func_77979_a(1));
            return true;
        }

        private boolean itemPassThroughBrewing() {
            if (!this.cache_slot_range_.func_191420_l()) {
                return false;
            }
            boolean changed = false;
            for (int i = 0; i < this.left_storage_slot_range_.size(); ++i) {
                ItemStack stack = this.left_storage_slot_range_.func_70301_a(i);
                if (stack.func_190926_b() || stack.func_77973_b() == RED_SUGAR_ITEM || Crafting.isBrewingFuel(this.field_145850_b, stack) || Crafting.isBrewingIngredient(this.field_145850_b, stack) || Crafting.isBrewingInput(this.field_145850_b, stack) || !this.left_storage_slot_range_.move(i, this.right_storage_slot_range_)) continue;
                if (this.left_storage_slot_range_.func_70301_a(i).func_190926_b()) {
                    return true;
                }
                changed = true;
            }
            return changed;
        }

        private boolean processGrindstone(boolean is_done) {
            this.last_recipe_ = "";
            this.progress_ = -40.0;
            this.fuel_left_ = 0;
            if (is_done) {
                if (!this.getResultSlot().func_190926_b()) {
                    ItemStack input_stack = this.cache_slot_range_.func_70301_a(0);
                    this.cache_slot_range_.func_70299_a(0, this.getResultSlot());
                    this.setResultSlot(ItemStack.field_190927_a);
                    List enchanted_books = Crafting.removeEnchantmentsOnItem(this.field_145850_b, input_stack, (e, l) -> true).entrySet().stream().filter(e -> !((Enchantment)e.getKey()).func_190936_d()).sorted(Comparator.comparingInt(e -> (Integer)e.getValue())).map(e -> Crafting.getEnchantmentBook(this.field_145850_b, (Enchantment)e.getKey(), (Integer)e.getValue())).filter(e -> !e.func_190926_b()).limit(this.cache_slot_range_.size() - 1).collect(Collectors.toList());
                    for (int i = 0; i < this.cache_slot_range_.size(); ++i) {
                        if (this.cache_slot_range_.func_70301_a(i).func_77973_b() != Items.field_151122_aG) continue;
                        if (enchanted_books.isEmpty()) break;
                        this.cache_slot_range_.func_70299_a(i, (ItemStack)enchanted_books.remove(0));
                    }
                }
                this.cache_slot_range_.move(this.right_storage_slot_range_);
                if (this.cache_slot_range_.func_191420_l()) {
                    this.progress_ = 0.0;
                }
                this.state_flags_.nofuel(false);
                this.state_flags_.noingr(false);
                return true;
            }
            Inventories.InventoryRange input_slots = this.left_storage_slot_range_;
            int input_slot = -1;
            ItemStack input_stack = ItemStack.field_190927_a;
            ItemStack output_stack = ItemStack.field_190927_a;
            ArrayList<ItemStack> secondary_output_stacks = new ArrayList<ItemStack>();
            int additional_processing_time = 0;
            Optional match = input_slots.find((slot, stack) -> Crafting.getEnchantmentsOnItem(this.field_145850_b, stack).isEmpty() ? Optional.empty() : Optional.of(new Tuple(slot, stack)));
            if (match.isPresent()) {
                input_slot = (Integer)((Tuple)match.get()).func_76341_a();
                input_stack = (ItemStack)((Tuple)match.get()).func_76340_b();
                output_stack = input_stack.func_77946_l();
                List enchanted_books = Crafting.removeEnchantmentsOnItem(this.field_145850_b, output_stack, (e, l) -> true).entrySet().stream().filter(e -> !((Enchantment)e.getKey()).func_190936_d()).sorted(Comparator.comparingInt(e -> (Integer)e.getValue())).map(e -> Crafting.getEnchantmentBook(this.field_145850_b, (Enchantment)e.getKey(), (Integer)e.getValue())).filter(e -> !e.func_190926_b()).limit(this.cache_slot_range_.size() - 1).collect(Collectors.toList());
                for (ItemStack enchanted_book : enchanted_books) {
                    if (input_slots.extract(new ItemStack((IItemProvider)Items.field_151122_aG, 1)).func_190926_b()) break;
                    secondary_output_stacks.add(new ItemStack((IItemProvider)Items.field_151122_aG));
                    additional_processing_time += (Crafting.getEnchantmentRepairCost(this.field_145850_b, Crafting.getEnchantmentsOnItem(this.field_145850_b, enchanted_book)) + 1) * 160;
                }
            }
            if (input_slot < 0 || input_stack.func_190926_b()) {
                this.state_flags_.noingr(true);
                return false;
            }
            this.state_flags_.nofuel(false);
            this.state_flags_.norecipe(false);
            this.setResultSlot(output_stack);
            this.max_progress_ = 60 + additional_processing_time;
            this.progress_ = 0.0;
            this.cache_slot_range_.func_70299_a(0, input_slots.func_70301_a(input_slot).func_77979_a(1));
            for (int i = 0; i < secondary_output_stacks.size() && i < this.cache_slot_range_.size() - 1; ++i) {
                this.cache_slot_range_.func_70299_a(1 + i, (ItemStack)secondary_output_stacks.get(i));
            }
            return true;
        }

        private boolean itemPassThroughGrindstone() {
            if (!this.cache_slot_range_.func_191420_l()) {
                return false;
            }
            boolean changed = false;
            for (int i = 0; i < this.left_storage_slot_range_.size(); ++i) {
                ItemStack stack = this.left_storage_slot_range_.func_70301_a(i);
                if (stack.func_190926_b() || stack.func_77973_b() == RED_SUGAR_ITEM || stack.func_77973_b() == Items.field_151122_aG || !Crafting.getEnchantmentsOnItem(this.field_145850_b, stack).isEmpty() || !this.left_storage_slot_range_.move(i, this.right_storage_slot_range_)) continue;
                if (this.left_storage_slot_range_.func_70301_a(i).func_190926_b()) {
                    return true;
                }
                changed = true;
            }
            return changed;
        }

        public static class StateFlags
        extends IntegralBitSet {
            public static final long mask_powered = 1L;
            public static final long mask_sugared = 2L;
            public static final long mask_nofuel = 4L;
            public static final long mask_norecipe = 8L;
            public static final long mask_noingr = 16L;
            public static final long mask_nopassthrough = 32L;
            public static final long mask_filteredinsert = 64L;
            public static final long mask_noants = 128L;

            public StateFlags(int v) {
                super(v);
            }

            public boolean powered() {
                return this.bit(0);
            }

            public boolean sugared() {
                return this.bit(1);
            }

            public boolean nofuel() {
                return this.bit(2);
            }

            public boolean norecipe() {
                return this.bit(3);
            }

            public boolean noingr() {
                return this.bit(4);
            }

            public boolean nopassthrough() {
                return this.bit(5);
            }

            public boolean filteredinsert() {
                return this.bit(6);
            }

            public boolean noants() {
                return this.bit(7);
            }

            public void powered(boolean v) {
                this.bit(0, v);
            }

            public void sugared(boolean v) {
                this.bit(1, v);
            }

            public void nofuel(boolean v) {
                this.bit(2, v);
            }

            public void norecipe(boolean v) {
                this.bit(3, v);
            }

            public void noingr(boolean v) {
                this.bit(4, v);
            }

            public void nopassthrough(boolean v) {
                this.bit(5, v);
            }

            public void filteredinsert(boolean v) {
                this.bit(6, v);
            }

            public void noants(boolean v) {
                this.bit(7, v);
            }
        }
    }

    public static class RedAntHiveBlock
    extends StandardBlocks.DirectedWaterLoggable {
        public static final IntegerProperty VARIANT = IntegerProperty.func_177719_a((String)"variant", (int)0, (int)2);

        public RedAntHiveBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB[] aabbs) {
            super(config, builder, aabbs);
            this.func_180632_j((BlockState)((BlockState)super.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.DOWN)).func_206870_a((Property)VARIANT, (Comparable)Integer.valueOf(0)));
        }

        @Override
        public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
            return VoxelShapes.func_197868_b();
        }

        @Override
        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a((StateContainer.Builder<Block, BlockState>)builder.func_206894_a(new Property[]{VARIANT}));
        }

        @Override
        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            BlockState state = super.func_196258_a(context);
            if (state == null) {
                return null;
            }
            if (!context.func_195999_j().func_225608_bj_()) {
                state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.DOWN);
            }
            double[] variant_votes = new double[VARIANT.func_177700_c().size()];
            int reference_weight = 0;
            World world = context.func_195991_k();
            BlockPos placement_pos = context.func_195995_a();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        Vector3i dirv = new Vector3i(x, y, z);
                        BlockPos adj_pos = placement_pos.func_177971_a(dirv);
                        double adj_scaler = Math.abs(x) + Math.abs(y) + Math.abs(z) == 1 ? 1.3 : 1.0;
                        double weight = (x == 0 ? 1.7 : 1.0) * (y == 0 ? 1.7 : 1.0) * (z == 0 ? 1.7 : 1.0) * adj_scaler;
                        BlockState adj_state = world.func_180495_p(adj_pos);
                        if (!adj_state.func_200015_d((IBlockReader)world, adj_pos)) continue;
                        reference_weight = (int)((double)reference_weight + weight);
                        String name = adj_state.func_177230_c().getRegistryName().func_110623_a();
                        if (name.contains("sand")) {
                            variant_votes[2] = variant_votes[2] + weight;
                            continue;
                        }
                        if (name.contains("dirt") || name.contains("grass")) {
                            variant_votes[1] = variant_votes[1] + weight;
                            continue;
                        }
                        variant_votes[0] = variant_votes[0] + weight;
                    }
                }
            }
            int best_variant = 0;
            double max_vote = variant_votes[0];
            for (int i = 0; i < variant_votes.length; ++i) {
                if (!(variant_votes[i] > max_vote)) continue;
                best_variant = i;
                max_vote = variant_votes[i];
            }
            if ((max_vote /= Math.max(1.0, (double)reference_weight)) >= 0.2) {
                state = (BlockState)state.func_206870_a((Property)VARIANT, (Comparable)Integer.valueOf(best_variant));
            }
            return state;
        }

        public boolean func_149740_M(BlockState state) {
            return true;
        }

        public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
            TileEntity te = world.func_175625_s(pos);
            return te instanceof RedAntHiveTileEntity ? ((RedAntHiveTileEntity)te).comparatorValue() : 0;
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new RedAntHiveTileEntity();
        }

        public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            if (world.func_201670_d()) {
                return;
            }
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("tedata")) {
                return;
            }
            CompoundNBT te_nbt = stack.func_77978_p().func_74775_l("tedata");
            if (te_nbt.isEmpty()) {
                return;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof RedAntHiveTileEntity)) {
                return;
            }
            ((RedAntHiveTileEntity)te).readnbt(te_nbt, false);
            ((RedAntHiveTileEntity)te).func_70296_d();
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, World world, TileEntity te, boolean explosion) {
            if (world.func_201670_d() || !(te instanceof RedAntHiveTileEntity)) {
                return Collections.emptyList();
            }
            CompoundNBT te_nbt = ((RedAntHiveTileEntity)te).clear_getnbt();
            ItemStack stack = new ItemStack((IItemProvider)this.func_199767_j());
            if (!te_nbt.isEmpty()) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_218657_a("tedata", (INBT)te_nbt);
                stack.func_77982_d(nbt);
            }
            return Collections.singletonList(stack);
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
            if (world.func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof RedAntHiveTileEntity)) {
                return ActionResultType.FAIL;
            }
            if (!(player instanceof ServerPlayerEntity) && !(player instanceof FakePlayer)) {
                return ActionResultType.FAIL;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te));
            return ActionResultType.CONSUME;
        }

        public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean unused) {
            if (!(world instanceof World) || world.field_72995_K) {
                return;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof RedAntHiveTileEntity)) {
                return;
            }
            ((RedAntHiveTileEntity)te).block_updated();
        }

        public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
            return false;
        }

        public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
            return true;
        }

        public boolean func_149744_f(BlockState state) {
            return true;
        }

        public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
            TileEntity te = world.func_175625_s(pos);
            return te instanceof RedAntHiveTileEntity ? ((RedAntHiveTileEntity)te).getRedstonePower(state, side, false) : 0;
        }

        public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
            TileEntity te = world.func_175625_s(pos);
            return te instanceof RedAntHiveTileEntity ? ((RedAntHiveTileEntity)te).getRedstonePower(state, side, true) : 0;
        }
    }

    private static class ProcessingHandler {
        public final Item item;
        public final BiFunction<RedAntHiveTileEntity, Boolean, Boolean> handler;
        public final Function<RedAntHiveTileEntity, Boolean> passthrough_handler;

        public ProcessingHandler(Item item, BiFunction<RedAntHiveTileEntity, Boolean, Boolean> handler, Function<RedAntHiveTileEntity, Boolean> passthrough_handler) {
            this.item = item;
            this.handler = handler;
            this.passthrough_handler = passthrough_handler;
        }
    }
}

