/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside.blocks;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import wile.anthillinside.ModContent;
import wile.anthillinside.libmc.blocks.StandardBlocks;
import wile.anthillinside.libmc.detail.Auxiliaries;
import wile.anthillinside.libmc.detail.Inventories;

public class RedAntTrail {
    private static double speed_modifier = 1.0;

    public static void on_config(int speed_percent) {
        speed_modifier = (double)MathHelper.func_76125_a((int)speed_percent, (int)25, (int)200) / 100.0;
    }

    public static class RedAntTrailBlock
    extends StandardBlocks.HorizontalWaterLoggable
    implements StandardBlocks.IBlockItemFactory {
        public static final BooleanProperty FRONT = BooleanProperty.func_177716_a((String)"front");
        public static final BooleanProperty LEFT = BooleanProperty.func_177716_a((String)"left");
        public static final BooleanProperty RIGHT = BooleanProperty.func_177716_a((String)"right");
        public static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");

        public RedAntTrailBlock(long config, AbstractBlock.Properties builder) {
            super(config, builder, (List<BlockState> states) -> {
                HashMap<BlockState, VoxelShape> shapes = new HashMap<BlockState, VoxelShape>();
                AxisAlignedBB base_aabb = Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 0.2, 16.0);
                AxisAlignedBB up_aabb = Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 16.0, 0.2);
                for (BlockState state : states) {
                    Direction facing = (Direction)state.func_177229_b((Property)HORIZONTAL_FACING);
                    VoxelShape shape = VoxelShapes.func_197880_a();
                    if (((Boolean)state.func_177229_b((Property)UP)).booleanValue()) {
                        shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)Auxiliaries.getRotatedAABB(up_aabb, facing, true)), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                    }
                    if (((Boolean)state.func_177229_b((Property)FRONT)).booleanValue() || !((Boolean)state.func_177229_b((Property)UP)).booleanValue()) {
                        shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)Auxiliaries.getRotatedAABB(base_aabb, facing, true)), (IBooleanFunction)IBooleanFunction.field_223244_o_);
                    }
                    shapes.putIfAbsent(state, shape);
                }
                return shapes;
            });
            this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)super.func_176223_P().func_206870_a((Property)FRONT, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LEFT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)RIGHT, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        public BlockItem getBlockItem(Block block, Item.Properties builder) {
            return ModContent.ANTS_ITEM;
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        public Item func_199767_j() {
            return ModContent.ANTS_ITEM;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, World world, TileEntity te, boolean explosion) {
            return Collections.singletonList(new ItemStack((IItemProvider)this.func_199767_j()));
        }

        @Override
        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{FRONT, LEFT, RIGHT, UP});
        }

        @Override
        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            BlockState state = super.func_196258_a(context);
            if (state == null) {
                return state;
            }
            if (!((Boolean)state.func_177229_b((Property)UP)).booleanValue() && context.func_196000_l().func_176740_k().func_200128_b() && !Block.func_220064_c((IBlockReader)context.func_195991_k(), (BlockPos)context.func_195995_a().func_177977_b())) {
                return null;
            }
            return this.updatedState(state, (IWorld)context.func_195991_k(), context.func_195995_a());
        }

        public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            Direction block_facing = (Direction)state.func_177229_b((Property)HORIZONTAL_FACING);
            for (Direction facing : Direction.values()) {
                Direction diagonal_facing;
                BlockPos diagonal_pos;
                BlockState diagonal_state;
                if (!facing.func_176740_k().func_176722_c() || facing == block_facing || !(diagonal_state = world.func_180495_p(diagonal_pos = pos.func_177972_a(facing).func_177977_b())).func_203425_a((Block)this) || ((Boolean)diagonal_state.func_177229_b((Property)UP)).booleanValue() || (diagonal_facing = (Direction)diagonal_state.func_177229_b((Property)HORIZONTAL_FACING)) != facing.func_176734_d()) continue;
                world.func_180501_a(diagonal_pos, (BlockState)diagonal_state.func_206870_a((Property)UP, (Comparable)Boolean.valueOf(true)), 2);
            }
        }

        @Override
        public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
            if (!(world instanceof World)) {
                return state;
            }
            if (this.func_196260_a(state, (IWorldReader)world, pos)) {
                return this.updatedState(state, world, pos);
            }
            return Blocks.field_150350_a.func_176223_P();
        }

        public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
            if (Block.func_208061_a((VoxelShape)world.func_180495_p(pos.func_177977_b()).func_196954_c((IBlockReader)world, pos.func_177977_b()), (Direction)Direction.UP)) {
                return true;
            }
            if (!((Boolean)state.func_177229_b((Property)UP)).booleanValue()) {
                return false;
            }
            Direction facing = (Direction)state.func_177229_b((Property)HORIZONTAL_FACING);
            return Block.func_208061_a((VoxelShape)world.func_180495_p(pos.func_177972_a(facing)).func_196954_c((IBlockReader)world, pos.func_177972_a(facing)), (Direction)facing.func_176734_d());
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rtr) {
            Direction dir = rtr.func_216354_b().func_176734_d();
            return world.func_180495_p(pos.func_177972_a(dir)).func_227031_a_(world, player, hand, new BlockRayTraceResult(rtr.func_216347_e(), rtr.func_216354_b(), pos.func_177972_a(dir), false));
        }

        public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
            if (entity instanceof ItemEntity) {
                this.moveEntity(state, world, pos, entity);
                if (((Boolean)state.func_177229_b((Property)UP)).booleanValue() && !world.func_205220_G_().func_205359_a(pos, (Object)this)) {
                    world.func_205220_G_().func_205360_a(pos, (Object)this, 60);
                }
            } else if (entity instanceof LivingEntity) {
                this.itchEntity(state, world, pos, entity);
            }
        }

        @Override
        public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
            if (!((Boolean)state.func_177229_b((Property)UP)).booleanValue()) {
                return;
            }
            BlockState st = world.func_180495_p(pos.func_177984_a());
            if (st == null || st.func_203425_a((Block)this)) {
                return;
            }
            List entities = world.func_175647_a(ItemEntity.class, new AxisAlignedBB(pos.func_177984_a()).func_72321_a(0.0, -0.2, 0.0), Entity::func_70089_S);
            Vector3d v = Vector3d.func_237491_b_((Vector3i)((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)).func_176730_m()).func_72441_c(0.0, 1.0, 0.0).func_186678_a(0.1);
            for (ItemEntity entity : entities) {
                entity.func_213317_d(v);
            }
        }

        public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean unused) {
            world.func_180501_a(pos, this.updatedState(state, (IWorld)world, pos), 2);
        }

        public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
            return false;
        }

        public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
            return true;
        }

        @Override
        public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
            return (Boolean)state.func_177229_b((Property)UP) == false || super.func_196266_a(state, world, pos, type);
        }

        public BlockState updatedState(@Nullable BlockState state, IWorld world, BlockPos pos) {
            if (state == null || !(world instanceof World)) {
                return state;
            }
            Direction facing = (Direction)state.func_177229_b((Property)HORIZONTAL_FACING);
            boolean down_solid = Block.func_220064_c((IBlockReader)world, (BlockPos)pos.func_177977_b());
            boolean up_is_cube = world.func_180495_p(pos.func_177984_a()).func_215686_e((IBlockReader)world, pos.func_177984_a());
            boolean up = RedAntTrailBlock.func_208061_a((VoxelShape)world.func_180495_p(pos.func_177972_a(facing)).func_196954_c((IBlockReader)world, pos.func_177972_a(facing)), (Direction)facing.func_176734_d()) && (!down_solid || world.func_180495_p(pos.func_177984_a()).func_203425_a((Block)this) || !up_is_cube && world.func_180495_p(pos.func_177972_a(facing).func_177984_a()).func_203425_a((Block)this));
            boolean left = false;
            boolean right = false;
            boolean front = down_solid;
            if (((World)world).func_175640_z(pos)) {
                BlockState left_state;
                BlockState right_state = world.func_180495_p(pos.func_177972_a(facing.func_176746_e()));
                if (right_state.func_203425_a((Block)this) && right_state.func_177229_b((Property)HORIZONTAL_FACING) == facing.func_176746_e()) {
                    right = true;
                }
                if ((left_state = world.func_180495_p(pos.func_177972_a(facing.func_176735_f()))).func_203425_a((Block)this) && left_state.func_177229_b((Property)HORIZONTAL_FACING) == facing.func_176735_f()) {
                    left = true;
                }
                if (!right && !left) {
                    front = false;
                }
            } else if (!(right || left || up)) {
                front = true;
            }
            state = (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)FRONT, (Comparable)Boolean.valueOf(front))).func_206870_a((Property)RIGHT, (Comparable)Boolean.valueOf(right))).func_206870_a((Property)LEFT, (Comparable)Boolean.valueOf(left))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(up));
            return state;
        }

        public void moveEntity(BlockState state, World world, BlockPos pos, Entity any_entity) {
            Direction dir;
            Direction facing_left;
            BlockState left_state;
            Direction sorting_direction;
            if (!any_entity.func_70089_S() || !(any_entity instanceof ItemEntity)) {
                return;
            }
            ItemEntity entity = (ItemEntity)any_entity;
            if (entity.func_92059_d().func_190926_b() || entity.func_92059_d().func_77973_b() == ModContent.ANTS_ITEM) {
                return;
            }
            boolean up = (Boolean)state.func_177229_b((Property)UP);
            if (!up && !entity.func_233570_aj_()) {
                return;
            }
            double speed = 0.07 * speed_modifier;
            Vector3d dp = entity.func_213303_ch().func_178786_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5).func_186678_a(2.0);
            if (!up && dp.field_72448_b > 0.0) {
                speed *= 0.2;
            }
            boolean outgoing = false;
            boolean check_insertion_front = false;
            boolean check_insertion_up = false;
            boolean front = (Boolean)state.func_177229_b((Property)FRONT);
            boolean right = (Boolean)state.func_177229_b((Property)RIGHT);
            boolean left = (Boolean)state.func_177229_b((Property)LEFT);
            Direction block_facing = (Direction)state.func_177229_b((Property)HORIZONTAL_FACING);
            Optional sorting_diversion = left || right || !front && !up ? Optional.empty() : this.itemFrameDiversion(world, pos, entity.func_92059_d());
            Vector3d motion = Vector3d.func_237491_b_((Vector3i)block_facing.func_176730_m());
            if (sorting_diversion.isPresent() && (sorting_direction = (Direction)sorting_diversion.get()) != block_facing && sorting_direction != block_facing.func_176734_d() && sorting_direction != Direction.UP) {
                if (sorting_direction == Direction.DOWN) {
                    if (!world.func_201670_d() && this.tryInsertItemEntity(world, pos, Direction.DOWN, entity)) {
                        entity.func_213317_d(entity.func_213322_ci().func_186678_a(0.7));
                        return;
                    }
                } else {
                    motion = Vector3d.func_237491_b_((Vector3i)sorting_direction.func_176730_m());
                    right = false;
                    left = false;
                    outgoing = true;
                }
            }
            if (right) {
                Direction dir2;
                Direction facing_right = block_facing.func_176746_e();
                BlockState right_state = world.func_180495_p(pos.func_177972_a(facing_right));
                if (right_state.func_203425_a((Block)this) && (dir2 = (Direction)right_state.func_177229_b((Property)HORIZONTAL_FACING)) == facing_right) {
                    motion = Vector3d.func_237491_b_((Vector3i)facing_right.func_176730_m());
                    outgoing = true;
                }
            } else if (left && (left_state = world.func_180495_p(pos.func_177972_a(facing_left = block_facing.func_176735_f()))).func_203425_a((Block)this) && (dir = (Direction)left_state.func_177229_b((Property)HORIZONTAL_FACING)) == facing_left) {
                motion = Vector3d.func_237491_b_((Vector3i)facing_left.func_176730_m());
                outgoing = true;
            }
            if (!(outgoing || front || up)) {
                motion = motion.func_186678_a(0.0);
            } else {
                if (!outgoing) {
                    Vector3d centering_motion = new Vector3d(block_facing.func_176740_k() == Direction.Axis.X ? 0.0 : -0.2 * Math.signum(dp.field_72450_a), 0.0, block_facing.func_176740_k() == Direction.Axis.Z ? 0.0 : -0.1 * Math.signum(dp.field_72449_c));
                    if (up) {
                        centering_motion.func_186678_a(2.0);
                    }
                    motion = motion.func_178787_e(centering_motion);
                }
                BlockState ahead_state = world.func_180495_p(pos.func_177972_a(block_facing));
                if (!outgoing && ahead_state.func_203425_a((Block)this)) {
                    Direction dir3 = (Direction)ahead_state.func_177229_b((Property)HORIZONTAL_FACING);
                    if (dir3 == block_facing) {
                        motion = motion.func_186678_a(2.0);
                    } else if (dir3 == block_facing.func_176734_d()) {
                        motion = motion.func_186678_a(0.5);
                    } else if (((Boolean)ahead_state.func_177229_b((Property)UP)).booleanValue()) {
                        motion = motion.func_186678_a(2.0);
                    }
                }
                double progress = dp.func_216370_a(block_facing.func_176740_k()) * Vector3d.func_237491_b_((Vector3i)block_facing.func_176730_m()).func_216370_a(block_facing.func_176740_k());
                double y_speed = -0.1 * Math.min(dp.field_72448_b, 0.5);
                if (!up) {
                    if (progress > 0.7 && front) {
                        check_insertion_front = true;
                    }
                } else {
                    if (front && dp.field_72448_b < 0.3 && progress < 0.6) {
                        y_speed = 0.08;
                    } else if (progress > 0.7 && world.func_180495_p(pos.func_177984_a().func_177972_a(block_facing)).func_203425_a((Block)this)) {
                        motion = motion.func_186678_a(1.2);
                        y_speed = 0.14;
                    } else {
                        y_speed = 0.1;
                    }
                    if (dp.field_72448_b >= 0.4 && !world.func_180495_p(pos.func_177984_a()).func_203425_a((Block)this)) {
                        check_insertion_up = true;
                    }
                }
                if (motion.field_72448_b < -0.1) {
                    motion = new Vector3d(motion.field_72450_a, -0.1, motion.field_72449_c);
                }
                motion = motion.func_186678_a(speed).func_72441_c(0.0, y_speed, 0.0);
            }
            if ((check_insertion_front || check_insertion_up) && !world.func_201670_d() && !entity.func_92059_d().func_190926_b()) {
                Direction insertion_facing = check_insertion_up ? Direction.UP : block_facing;
                this.tryInsertItemEntity(world, pos, insertion_facing, entity);
            }
            if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                motion.func_72441_c(0.0, -0.1, 0.0);
            }
            motion = entity.func_213322_ci().func_186678_a(0.5).func_178787_e(motion);
            entity.func_213317_d(motion);
        }

        public void itchEntity(BlockState state, World world, BlockPos pos, Entity entity) {
            if (world.func_201674_k().nextDouble() > 0.008 || !entity.func_70089_S() || !entity.func_233570_aj_() || world.func_201670_d() || entity.func_225608_bj_() || !entity.func_184222_aU() || entity.func_70026_G() || entity.field_70160_al || !(entity instanceof LivingEntity)) {
                return;
            }
            if (entity instanceof MonsterEntity) {
                entity.func_70097_a(DamageSource.field_76367_g, 2.0f);
            } else if (entity instanceof PlayerEntity) {
                if (world.func_201674_k().nextDouble() > 0.1) {
                    return;
                }
                entity.func_70097_a(DamageSource.field_76367_g, 0.1f);
            } else {
                entity.func_70097_a(DamageSource.field_76367_g, 0.0f);
                if (entity instanceof VillagerEntity) {
                    ((VillagerEntity)entity).func_213375_cj().func_218202_a(Activity.field_221371_g);
                } else if (entity instanceof AnimalEntity) {
                    ((AnimalEntity)entity).func_213375_cj().func_218202_a(Activity.field_221371_g);
                }
            }
        }

        private Optional<Direction> itemFrameDiversion(World world, BlockPos pos, ItemStack match_stack) {
            List frames = world.func_217357_a(ItemFrameEntity.class, new AxisAlignedBB(pos));
            if (frames.isEmpty()) {
                return Optional.empty();
            }
            for (ItemFrameEntity frame : frames) {
                if (!frame.func_82335_i().func_185136_b(match_stack)) continue;
                return Optional.of(frame.func_174811_aO());
            }
            return Optional.empty();
        }

        private boolean tryInsertItemEntity(World world, BlockPos pos, Direction insertion_facing, ItemEntity entity) {
            IItemHandler ih = Inventories.itemhandler(world, pos.func_177972_a(insertion_facing), insertion_facing.func_176734_d());
            if (ih == null) {
                return false;
            }
            ItemStack stack = entity.func_92059_d().func_77946_l();
            ItemStack remaining = Inventories.insert(ih, stack, false);
            if (remaining.func_190916_E() >= stack.func_190916_E()) {
                return false;
            }
            if (stack.func_190926_b()) {
                entity.func_70106_y();
                return true;
            }
            entity.func_92058_a(remaining);
            return false;
        }
    }
}

