/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside.libmc.detail;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.ComposterBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.BlastingRecipe;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.SmokingRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import wile.anthillinside.libmc.detail.Inventories;

public class Crafting {
    public static final Optional<ICraftingRecipe> getCraftingRecipe(World world, ResourceLocation recipe_id) {
        IRecipe recipe = world.func_199532_z().func_215367_a(recipe_id).orElse(null);
        return recipe instanceof ICraftingRecipe ? Optional.of((ICraftingRecipe)recipe) : Optional.empty();
    }

    public static final List<ICraftingRecipe> get3x3CraftingRecipes(World world, IInventory crafting_grid_slots) {
        return CraftingGrid.instance3x3.getRecipes(world, crafting_grid_slots);
    }

    public static final Optional<ICraftingRecipe> get3x3CraftingRecipe(World world, IInventory crafting_grid_slots) {
        return Crafting.get3x3CraftingRecipes(world, crafting_grid_slots).stream().findFirst();
    }

    public static final ItemStack get3x3CraftingResult(World world, IInventory grid, ICraftingRecipe recipe) {
        return CraftingGrid.instance3x3.getCraftingResult(world, grid, recipe);
    }

    public static final List<ItemStack> get3x3RemainingItems(World world, IInventory grid, ICraftingRecipe recipe) {
        return CraftingGrid.instance3x3.getRemainingItems(world, grid, recipe);
    }

    public static final List<ItemStack> get3x3Placement(World world, ICraftingRecipe recipe, IInventory item_inventory, @Nullable IInventory crafting_grid) {
        int i;
        int width = 3;
        int height = 3;
        if (!recipe.func_194133_a(3, 3)) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> used = new ArrayList<ItemStack>();
        for (int i2 = 9; i2 > 0; --i2) {
            used.add(ItemStack.field_190927_a);
        }
        IInventory check_inventory = Inventories.copyOf(item_inventory);
        Inventories.InventoryRange source = new Inventories.InventoryRange(check_inventory);
        NonNullList ingredients = recipe.func_192400_c();
        ArrayList<ItemStack> preferred = new ArrayList<ItemStack>(9);
        if (crafting_grid != null) {
            for (i = 0; i < crafting_grid.func_70302_i_(); ++i) {
                ItemStack stack = crafting_grid.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                stack = stack.func_77946_l();
                stack.func_190920_e(1);
                if (source.extract(stack).func_190926_b()) continue;
                preferred.add(stack);
            }
        }
        for (i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            if (ingredient == Ingredient.field_193370_a) continue;
            ItemStack stack = preferred.stream().filter(ingredient).findFirst().orElse(ItemStack.field_190927_a);
            if (!stack.func_190926_b()) {
                preferred.remove(stack);
            } else {
                stack = source.stream().filter((Predicate<ItemStack>)ingredient).findFirst().orElse(ItemStack.field_190927_a);
                if (stack.func_190926_b()) {
                    return Collections.emptyList();
                }
                stack = stack.func_77946_l();
                stack.func_190920_e(1);
                if (source.extract(stack).func_190926_b()) {
                    return Collections.emptyList();
                }
            }
            used.set(i, stack);
        }
        if (recipe instanceof ShapedRecipe) {
            NonNullList placement = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            for (int row = 0; row < shaped.getRecipeHeight(); ++row) {
                for (int col = 0; col < shaped.getRecipeWidth(); ++col) {
                    placement.set(3 * row + col, used.get(row * shaped.getRecipeWidth() + col));
                }
            }
            return placement;
        }
        return used;
    }

    public static final <T extends IRecipe<?>> Optional<AbstractCookingRecipe> getFurnaceRecipe(IRecipeType<T> recipe_type, World world, ItemStack input_stack) {
        if (input_stack.func_190926_b()) {
            return Optional.empty();
        }
        if (recipe_type == IRecipeType.field_222150_b) {
            Inventory inventory = new Inventory(3);
            inventory.func_70299_a(0, input_stack);
            FurnaceRecipe recipe = world.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)inventory, world).orElse(null);
            return recipe == null ? Optional.empty() : Optional.of(recipe);
        }
        if (recipe_type == IRecipeType.field_222151_c) {
            Inventory inventory = new Inventory(3);
            inventory.func_70299_a(0, input_stack);
            BlastingRecipe recipe = world.func_199532_z().func_215371_a(IRecipeType.field_222151_c, (IInventory)inventory, world).orElse(null);
            return recipe == null ? Optional.empty() : Optional.of(recipe);
        }
        if (recipe_type == IRecipeType.field_222152_d) {
            Inventory inventory = new Inventory(3);
            inventory.func_70299_a(0, input_stack);
            SmokingRecipe recipe = world.func_199532_z().func_215371_a(IRecipeType.field_222152_d, (IInventory)inventory, world).orElse(null);
            return recipe == null ? Optional.empty() : Optional.of(recipe);
        }
        return Optional.empty();
    }

    public static final int getFuelBurntime(World world, ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int t = ForgeHooks.getBurnTime((ItemStack)stack);
        return t < 0 ? 0 : t;
    }

    public static final boolean isFuel(World world, ItemStack stack) {
        return Crafting.getFuelBurntime(world, stack) > 0 || stack.func_77973_b() == Items.field_151129_at;
    }

    public static final Tuple<Integer, ItemStack> consumeFuel(World world, ItemStack stack) {
        if (stack.func_190926_b()) {
            return new Tuple((Object)0, (Object)stack);
        }
        int burnime = Crafting.getFuelBurntime(world, stack);
        if (stack.func_77973_b() == Items.field_151129_at) {
            if (burnime <= 0) {
                burnime = 20000;
            }
            return new Tuple((Object)burnime, (Object)new ItemStack((IItemProvider)Items.field_151133_ar));
        }
        if (burnime <= 0) {
            return new Tuple((Object)0, (Object)stack);
        }
        ItemStack left_over = stack.func_77946_l();
        left_over.func_190918_g(1);
        return new Tuple((Object)burnime, (Object)left_over);
    }

    public static final boolean isBrewingFuel(World world, ItemStack stack) {
        return stack.func_77973_b() == Items.field_151065_br || stack.func_77973_b() == Items.field_151072_bj;
    }

    public static final boolean isBrewingIngredient(World world, ItemStack stack) {
        return BrewingRecipeRegistry.isValidIngredient((ItemStack)stack);
    }

    public static final boolean isBrewingInput(World world, ItemStack stack) {
        return BrewingRecipeRegistry.isValidInput((ItemStack)stack);
    }

    public static final int getBrewingFuelBurntime(World world, ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b() == Items.field_151065_br) {
            return 8000;
        }
        if (stack.func_77973_b() == Items.field_151072_bj) {
            return 16000;
        }
        return 0;
    }

    public static final Tuple<Integer, ItemStack> consumeBrewingFuel(World world, ItemStack stack) {
        int burntime = Crafting.getBrewingFuelBurntime(world, stack);
        if (burntime <= 0) {
            return new Tuple((Object)0, (Object)stack.func_77946_l());
        }
        stack = stack.func_77946_l();
        stack.func_190918_g(1);
        return new Tuple((Object)burntime, (Object)(stack.func_190926_b() ? ItemStack.field_190927_a : stack));
    }

    public static final double getCompostingChance(ItemStack stack) {
        return ComposterBlock.field_220299_b.getOrDefault((Object)stack.func_77973_b(), 0.0f);
    }

    public static final Map<Enchantment, Integer> getEnchantmentsOnItem(World world, ItemStack stack) {
        return stack.func_190926_b() || stack.func_77978_p() == null ? Collections.emptyMap() : EnchantmentHelper.func_82781_a((ItemStack)stack);
    }

    public static final ItemStack getEnchantmentBook(World world, Enchantment enchantment, int level) {
        return !enchantment.isAllowedOnBooks() || level <= 0 ? ItemStack.field_190927_a : EnchantedBookItem.func_92111_a((EnchantmentData)new EnchantmentData(enchantment, level));
    }

    public static final int getEnchantmentRepairCost(World world, Map<Enchantment, Integer> enchantments) {
        int repair_cost = 0;
        for (Map.Entry<Enchantment, Integer> e : enchantments.entrySet()) {
            repair_cost = repair_cost * 2 + 1;
        }
        return repair_cost;
    }

    public static final boolean addEnchantmentOnItem(World world, ItemStack stack, Enchantment enchantment, int level) {
        if (stack.func_190926_b() || level <= 0 || !stack.func_77956_u() || level >= enchantment.func_77325_b()) {
            return false;
        }
        Map<Enchantment, Integer> on_item = Crafting.getEnchantmentsOnItem(world, stack);
        if (on_item.keySet().stream().anyMatch(ench -> ench.func_191560_c(enchantment))) {
            return false;
        }
        ItemStack book = EnchantedBookItem.func_92111_a((EnchantmentData)new EnchantmentData(enchantment, level));
        if (!(stack.isBookEnchantable(book) && enchantment.isAllowedOnBooks() || stack.canApplyAtEnchantingTable(enchantment) || enchantment.func_92089_a(stack))) {
            return false;
        }
        int existing_level = on_item.getOrDefault(enchantment, 0);
        if (existing_level == 0) {
            on_item.put(enchantment, level);
        } else {
            level = MathHelper.func_76125_a((int)(level + existing_level), (int)1, (int)enchantment.func_77325_b());
            on_item.put(enchantment, level);
        }
        EnchantmentHelper.func_82782_a(on_item, (ItemStack)stack);
        stack.func_82841_c(Crafting.getEnchantmentRepairCost(world, on_item));
        return true;
    }

    public static final Map<Enchantment, Integer> removeEnchantmentsOnItem(World world, ItemStack stack, BiPredicate<Enchantment, Integer> filter) {
        if (stack.func_190926_b()) {
            return Collections.emptyMap();
        }
        Map<Enchantment, Integer> on_item = Crafting.getEnchantmentsOnItem(world, stack);
        HashMap<Enchantment, Integer> removed = new HashMap<Enchantment, Integer>();
        for (Map.Entry<Enchantment, Integer> entry : on_item.entrySet()) {
            if (!filter.test(entry.getKey(), entry.getValue())) continue;
            removed.put(entry.getKey(), entry.getValue());
        }
        for (Enchantment enchantment : removed.keySet()) {
            on_item.remove(enchantment);
        }
        EnchantmentHelper.func_82782_a(on_item, (ItemStack)stack);
        stack.func_82841_c(Crafting.getEnchantmentRepairCost(world, on_item));
        return removed;
    }

    public static final class BrewingOutput {
        public static final int DEFAULT_BREWING_TIME = 400;
        public static final BrewingOutput EMPTY = new BrewingOutput(ItemStack.field_190927_a, (IInventory)new Inventory(1), (IInventory)new Inventory(1), 0, 0, 400);
        public final ItemStack item;
        public final IInventory potionInventory;
        public final IInventory ingredientInventory;
        public final int potionSlot;
        public final int ingredientSlot;
        public final int brewTime;

        public BrewingOutput(ItemStack output_potion, IInventory potion_inventory, IInventory ingredient_inventory, int potion_slot, int ingredient_slot, int time_needed) {
            this.item = output_potion;
            this.potionInventory = potion_inventory;
            this.ingredientInventory = ingredient_inventory;
            this.potionSlot = potion_slot;
            this.ingredientSlot = ingredient_slot;
            this.brewTime = time_needed;
        }

        public static BrewingOutput find(World world, IInventory potion_inventory, IInventory ingredient_inventory) {
            for (int potion_slot = 0; potion_slot < potion_inventory.func_70302_i_(); ++potion_slot) {
                ItemStack pstack = potion_inventory.func_70301_a(potion_slot);
                if (!Crafting.isBrewingInput(world, pstack)) continue;
                for (int ingredient_slot = 0; ingredient_slot < ingredient_inventory.func_70302_i_(); ++ingredient_slot) {
                    ItemStack result;
                    ItemStack istack = ingredient_inventory.func_70301_a(ingredient_slot);
                    if (!Crafting.isBrewingIngredient(world, istack) || ingredient_slot == potion_slot || Crafting.isBrewingFuel(world, istack) || (result = BrewingRecipeRegistry.getOutput((ItemStack)pstack, (ItemStack)istack)).func_190926_b()) continue;
                    return new BrewingOutput(result, potion_inventory, ingredient_inventory, potion_slot, ingredient_slot, 400);
                }
            }
            return EMPTY;
        }
    }

    public static final class CraftingGrid
    extends CraftingInventory {
        protected static final CraftingGrid instance3x3 = new CraftingGrid(3, 3);

        protected CraftingGrid(int width, int height) {
            super(new Container(null, 0){

                public boolean func_75145_c(PlayerEntity player) {
                    return false;
                }
            }, width, height);
        }

        protected void fill(IInventory grid) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                this.func_70299_a(i, i >= grid.func_70302_i_() ? ItemStack.field_190927_a : grid.func_70301_a(i));
            }
        }

        public List<ICraftingRecipe> getRecipes(World world, IInventory grid) {
            this.fill(grid);
            return world.func_199532_z().func_215370_b(IRecipeType.field_222149_a, (IInventory)this, world);
        }

        public List<ItemStack> getRemainingItems(World world, IInventory grid, ICraftingRecipe recipe) {
            this.fill(grid);
            return recipe.func_179532_b((IInventory)this);
        }

        public ItemStack getCraftingResult(World world, IInventory grid, ICraftingRecipe recipe) {
            this.fill(grid);
            return recipe.func_77572_b((IInventory)this);
        }
    }
}

