/*
 * Decompiled with CFR 0.152.
 */
package wile.anthillinside.libmc.detail;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IForgeShearable;

public class ToolActions {
    public static boolean shearEntity(LivingEntity entity) {
        if (entity.field_70170_p.func_201670_d() || !(entity instanceof IForgeShearable)) {
            return false;
        }
        IForgeShearable target = (IForgeShearable)entity;
        ItemStack tool = new ItemStack((IItemProvider)Items.field_151097_aZ);
        BlockPos pos = new BlockPos((Vector3i)entity.func_233580_cy_());
        if (target.isShearable(tool, entity.field_70170_p, pos)) {
            List drops = target.onSheared(null, tool, entity.field_70170_p, pos, 1);
            Random rand = new Random();
            drops.forEach(d -> {
                ItemEntity ent = entity.func_70099_a(d, 1.0f);
                if (ent == null) {
                    return;
                }
                ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)((rand.nextFloat() - rand.nextFloat()) * 0.05f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.05f)));
            });
            entity.field_70170_p.func_184133_a(null, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 0.8f, 1.1f);
        }
        return true;
    }

    public static boolean shearEntities(World world, AxisAlignedBB range, int max_count) {
        if (max_count <= 0) {
            return false;
        }
        List entities = world.func_175647_a(LivingEntity.class, range, e -> e instanceof IForgeShearable);
        boolean snipped = false;
        for (LivingEntity e2 : entities) {
            if (!ToolActions.shearEntity(e2)) continue;
            snipped = true;
            if (--max_count != 0) continue;
            break;
        }
        return snipped;
    }

    public static boolean shearPlant(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!block.func_203417_a((ITag)BlockTags.field_206952_E) && block != Blocks.field_196553_aF && block != Blocks.field_150349_c & block != Blocks.field_196804_gh && block != Blocks.field_196554_aH && block != Blocks.field_196555_aI && block != Blocks.field_150395_bd && block != Blocks.field_150473_bD && !block.func_203417_a((ITag)BlockTags.field_199897_a)) {
            return false;
        }
        ItemEntity ie = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack((IItemProvider)block.func_199767_j()));
        ie.func_174869_p();
        world.func_217376_c((Entity)ie);
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
        if (!world.func_201670_d()) {
            world.func_184133_a(null, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 0.8f, 1.1f);
        }
        return true;
    }

    public static Optional<List<ItemStack>> harvestCrop(ServerWorld world, BlockPos pos, boolean try_replant, ItemStack bonemeal) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!(block instanceof CropsBlock)) {
            return Optional.empty();
        }
        CropsBlock crop = (CropsBlock)block;
        if (!crop.func_185525_y(state)) {
            if (!bonemeal.func_190926_b() && crop.func_180670_a((World)world, world.func_201674_k(), pos, state)) {
                bonemeal.func_190918_g(1);
                crop.func_225535_a_(world, world.func_201674_k(), pos, state);
            }
            return Optional.of(Collections.emptyList());
        }
        List drops = state.func_215693_a(new LootContext.Builder(world).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216015_a(LootParameters.field_216287_g, (Object)state).func_216021_b(LootParameters.field_216288_h, (Object)world.func_175625_s(pos)).func_216021_b(LootParameters.field_216281_a, null).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a));
        if (!try_replant) {
            world.func_217377_a(pos, false);
        } else {
            ItemStack seed = crop.func_185473_a((IBlockReader)world, pos, state);
            if (!seed.func_190926_b()) {
                boolean fetched_seed = false;
                for (ItemStack stack : drops) {
                    if (!stack.func_77969_a(seed)) continue;
                    stack.func_190918_g(1);
                    fetched_seed = true;
                    break;
                }
                if (fetched_seed) {
                    int initval = (Integer)crop.func_176223_P().func_177229_b((Property)crop.func_185524_e());
                    world.func_180501_a(pos, crop.func_185528_e(initval), 3);
                }
            }
        }
        return Optional.of(drops);
    }
}

