/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.base.plants;

import com.mystic.atlantis.Main;
import com.mystic.atlantis.init.ModBlocks;
import com.mystic.atlantis.init.ModItems;
import com.mystic.atlantis.tabs.AtlantisTab;
import com.mystic.atlantis.util.IHasModel;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Algae
extends Block
implements IShearable,
IHasModel {
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool[] ALL_FACES = new PropertyBool[]{UP, NORTH, SOUTH, WEST, EAST};
    private static final IProperty<Integer> LEVEL = BlockLiquid.field_176367_b;
    protected static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0);

    public Algae(String name, Material material) {
        super(material);
        this.func_149663_c("atlantis." + name);
        this.setRegistryName(name);
        this.func_149647_a(AtlantisTab.ATLANTIS_TAB);
        this.func_149675_a(true);
        this.func_149647_a(AtlantisTab.ATLANTIS_TAB);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(15)).func_177226_a((IProperty)UP, (Comparable)Boolean.FALSE).func_177226_a((IProperty)NORTH, (Comparable)Boolean.FALSE).func_177226_a((IProperty)EAST, (Comparable)Boolean.FALSE).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.FALSE).func_177226_a((IProperty)WEST, (Comparable)Boolean.FALSE));
        ModBlocks.BLOCKS.add(this);
        ModItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(Objects.requireNonNull(this.getRegistryName())));
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        int i = 0;
        AxisAlignedBB axisalignedbb = field_185505_j;
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            axisalignedbb = UP_AABB;
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            axisalignedbb = NORTH_AABB;
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            axisalignedbb = EAST_AABB;
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            axisalignedbb = SOUTH_AABB;
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            axisalignedbb = WEST_AABB;
            ++i;
        }
        return i == 1 ? axisalignedbb : field_185505_j;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177984_a();
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(worldIn.func_180495_p(blockpos).func_193401_d(worldIn, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.DOWN && side != EnumFacing.UP && this.canAttachTo(worldIn, pos, side);
    }

    public boolean canAttachTo(World world, BlockPos blockPos, EnumFacing enumFacing) {
        Block block = world.func_180495_p(blockPos.func_177984_a()).func_177230_c();
        return this.isAcceptableNeighbor(world, blockPos.func_177972_a(enumFacing.func_176734_d()), enumFacing) && (block == Blocks.field_150355_j || block == ModBlocks.ALGAE || this.isAcceptableNeighbor(world, blockPos.func_177984_a(), EnumFacing.UP));
    }

    private boolean isAcceptableNeighbor(World world, BlockPos blockPos, EnumFacing enumFacing) {
        IBlockState iblockstate = world.func_180495_p(blockPos);
        return iblockstate.func_193401_d((IBlockAccess)world, blockPos, enumFacing) == BlockFaceShape.SOLID && !Algae.isExceptBlockForAttaching(iblockstate.func_177230_c());
    }

    protected static boolean isExceptBlockForAttaching(Block block) {
        return block instanceof BlockShulkerBox || block == Blocks.field_150461_bJ || block == Blocks.field_150383_bp || block == Blocks.field_150359_w || block == Blocks.field_150399_cn || block == Blocks.field_150331_J || block == Blocks.field_150320_F || block == Blocks.field_150332_K || block == Blocks.field_150415_aT;
    }

    private boolean recheckGrownSides(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState iblockstate = state;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate1;
            PropertyBool propertybool = Algae.getPropertyFor(enumfacing);
            if (!((Boolean)state.func_177229_b((IProperty)propertybool)).booleanValue() || this.canAttachTo(worldIn, pos, enumfacing.func_176734_d()) || (iblockstate1 = worldIn.func_180495_p(pos.func_177984_a())).func_177230_c() == this && ((Boolean)iblockstate1.func_177229_b((IProperty)propertybool)).booleanValue()) continue;
            state = state.func_177226_a((IProperty)propertybool, (Comparable)Boolean.FALSE);
        }
        if (Algae.getNumGrownFaces(state) == 0) {
            return false;
        }
        if (iblockstate != state) {
            worldIn.func_180501_a(pos, state, 2);
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K && !this.recheckGrownSides(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            this.setBlockToWater(worldIn, pos);
        }
    }

    public boolean setBlockToWater(World world, BlockPos blockPos) {
        return world.func_180501_a(blockPos, Blocks.field_150355_j.func_176223_P(), 3);
    }

    public boolean isWaterBlock(World worldIn, BlockPos pos) {
        return this.isWater(worldIn.func_180495_p(pos), (IBlockAccess)worldIn, pos);
    }

    public boolean isWater(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_185904_a() == Material.field_151586_h;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && worldIn.field_73012_v.nextInt(4) == 0 && worldIn.func_175697_a(pos, 4)) {
            int i = 4;
            int j = 5;
            boolean flag = false;
            block0: for (int k = -4; k <= 4; ++k) {
                for (int l = -4; l <= 4; ++l) {
                    for (int i1 = -1; i1 <= 1; ++i1) {
                        if (worldIn.func_180495_p(pos.func_177982_a(k, i1, l)).func_177230_c() != this || --j > 0) continue;
                        flag = true;
                        break block0;
                    }
                }
            }
            EnumFacing enumfacing1 = EnumFacing.func_176741_a((Random)rand);
            BlockPos blockpos2 = pos.func_177984_a();
            if (enumfacing1 == EnumFacing.UP && pos.func_177956_o() < 0x7FFFF000 && this.isWaterBlock(worldIn, blockpos2)) {
                IBlockState iblockstate2 = state;
                for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
                    if (rand.nextBoolean() && this.canAttachTo(worldIn, blockpos2, enumfacing2.func_176734_d())) {
                        iblockstate2 = iblockstate2.func_177226_a((IProperty)Algae.getPropertyFor(enumfacing2), (Comparable)Boolean.TRUE);
                        continue;
                    }
                    iblockstate2 = iblockstate2.func_177226_a((IProperty)Algae.getPropertyFor(enumfacing2), (Comparable)Boolean.FALSE);
                }
                if (((Boolean)iblockstate2.func_177229_b((IProperty)NORTH)).booleanValue() || ((Boolean)iblockstate2.func_177229_b((IProperty)EAST)).booleanValue() || ((Boolean)iblockstate2.func_177229_b((IProperty)SOUTH)).booleanValue() || ((Boolean)iblockstate2.func_177229_b((IProperty)WEST)).booleanValue()) {
                    worldIn.func_180501_a(blockpos2, iblockstate2, 2);
                }
            } else if (enumfacing1.func_176740_k().func_176722_c() && !((Boolean)state.func_177229_b((IProperty)Algae.getPropertyFor(enumfacing1))).booleanValue()) {
                if (!flag) {
                    BlockPos blockpos4 = pos.func_177972_a(enumfacing1);
                    IBlockState iblockstate3 = worldIn.func_180495_p(blockpos4);
                    Block block1 = iblockstate3.func_177230_c();
                    if (this.isWater(iblockstate3, (IBlockAccess)worldIn, blockpos4)) {
                        EnumFacing enumfacing3 = enumfacing1.func_176746_e();
                        EnumFacing enumfacing4 = enumfacing1.func_176735_f();
                        boolean flag1 = (Boolean)state.func_177229_b((IProperty)Algae.getPropertyFor(enumfacing3));
                        boolean flag2 = (Boolean)state.func_177229_b((IProperty)Algae.getPropertyFor(enumfacing4));
                        BlockPos blockpos = blockpos4.func_177972_a(enumfacing3);
                        BlockPos blockpos1 = blockpos4.func_177972_a(enumfacing4);
                        if (flag1 && this.canAttachTo(worldIn, blockpos.func_177972_a(enumfacing3), enumfacing3)) {
                            worldIn.func_180501_a(blockpos4, this.func_176223_P().func_177226_a((IProperty)Algae.getPropertyFor(enumfacing3), (Comparable)Boolean.TRUE), 2);
                        } else if (flag2 && this.canAttachTo(worldIn, blockpos1.func_177972_a(enumfacing4), enumfacing4)) {
                            worldIn.func_180501_a(blockpos4, this.func_176223_P().func_177226_a((IProperty)Algae.getPropertyFor(enumfacing4), (Comparable)Boolean.TRUE), 2);
                        } else if (flag1 && this.isWaterBlock(worldIn, blockpos) && this.canAttachTo(worldIn, blockpos, enumfacing1)) {
                            worldIn.func_180501_a(blockpos, this.func_176223_P().func_177226_a((IProperty)Algae.getPropertyFor(enumfacing1.func_176734_d()), (Comparable)Boolean.TRUE), 2);
                        } else if (flag2 && this.isWaterBlock(worldIn, blockpos1) && this.canAttachTo(worldIn, blockpos1, enumfacing1)) {
                            worldIn.func_180501_a(blockpos1, this.func_176223_P().func_177226_a((IProperty)Algae.getPropertyFor(enumfacing1.func_176734_d()), (Comparable)Boolean.TRUE), 2);
                        }
                    } else if (iblockstate3.func_193401_d((IBlockAccess)worldIn, blockpos4, enumfacing1) == BlockFaceShape.SOLID) {
                        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)Algae.getPropertyFor(enumfacing1), (Comparable)Boolean.TRUE), 2);
                    }
                }
            } else if (pos.func_177956_o() > 1) {
                BlockPos blockpos3 = pos.func_177977_b();
                IBlockState iblockstate = worldIn.func_180495_p(blockpos3);
                Block block = iblockstate.func_177230_c();
                if (block.func_149688_o(state) == Material.field_151586_h) {
                    IBlockState iblockstate1 = state;
                    for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                        if (!rand.nextBoolean()) continue;
                        iblockstate1 = iblockstate1.func_177226_a((IProperty)Algae.getPropertyFor(enumfacing), (Comparable)Boolean.FALSE);
                    }
                    if (((Boolean)iblockstate1.func_177229_b((IProperty)NORTH)).booleanValue() || ((Boolean)iblockstate1.func_177229_b((IProperty)EAST)).booleanValue() || ((Boolean)iblockstate1.func_177229_b((IProperty)SOUTH)).booleanValue() || ((Boolean)iblockstate1.func_177229_b((IProperty)WEST)).booleanValue()) {
                        worldIn.func_180501_a(blockpos3, iblockstate1, 2);
                    }
                } else if (block == this) {
                    IBlockState iblockstate4 = iblockstate;
                    for (EnumFacing enumfacing5 : EnumFacing.Plane.HORIZONTAL) {
                        PropertyBool propertybool = Algae.getPropertyFor(enumfacing5);
                        if (!rand.nextBoolean() || !((Boolean)state.func_177229_b((IProperty)propertybool)).booleanValue()) continue;
                        iblockstate4 = iblockstate4.func_177226_a((IProperty)propertybool, (Comparable)Boolean.TRUE);
                    }
                    if (((Boolean)iblockstate4.func_177229_b((IProperty)NORTH)).booleanValue() || ((Boolean)iblockstate4.func_177229_b((IProperty)EAST)).booleanValue() || ((Boolean)iblockstate4.func_177229_b((IProperty)SOUTH)).booleanValue() || ((Boolean)iblockstate4.func_177229_b((IProperty)WEST)).booleanValue()) {
                        worldIn.func_180501_a(blockpos3, iblockstate4, 2);
                    }
                }
            }
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(15)).func_177226_a((IProperty)UP, (Comparable)Boolean.FALSE).func_177226_a((IProperty)NORTH, (Comparable)Boolean.FALSE).func_177226_a((IProperty)EAST, (Comparable)Boolean.FALSE).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.FALSE).func_177226_a((IProperty)WEST, (Comparable)Boolean.FALSE);
        return facing.func_176740_k().func_176722_c() ? iblockstate.func_177226_a((IProperty)Algae.getPropertyFor(facing.func_176734_d()), (Comparable)Boolean.TRUE) : iblockstate;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (!worldIn.field_72995_K && stack.func_77973_b() == Items.field_151097_aZ) {
            player.func_71029_a(Objects.requireNonNull(StatList.func_188055_a((Block)this)));
            Algae.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(ModBlocks.ALGAE, 1, 0));
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(meta)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf((meta & 1) > 0)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf((meta & 2) > 0)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf((meta & 4) > 0)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            return i |= 1;
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            return i |= 2;
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            return i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            return i |= 8;
        }
        return (Integer)state.func_177229_b(LEVEL);
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockLiquid.field_176367_b, UP, NORTH, EAST, SOUTH, WEST});
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)NORTH));
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)SOUTH));
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH));
            }
            case FRONT_BACK: {
                return state.func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    public static PropertyBool getPropertyFor(EnumFacing side) {
        switch (side) {
            case UP: {
                return UP;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
            case EAST: {
                return EAST;
            }
        }
        throw new IllegalArgumentException(side + " is an invalid choice");
    }

    public static int getNumGrownFaces(IBlockState state) {
        int i = 0;
        for (PropertyBool propertybool : ALL_FACES) {
            if (!((Boolean)state.func_177229_b((IProperty)propertybool)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return Arrays.asList(new ItemStack((Block)this, 1));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public void registerModels() {
        Main.proxy.registerModel(Item.func_150898_a((Block)this), 0);
    }
}

