/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.base.plants;

import com.mystic.atlantis.Main;
import com.mystic.atlantis.init.ModBlocks;
import com.mystic.atlantis.init.ModItems;
import com.mystic.atlantis.tabs.AtlantisTab;
import com.mystic.atlantis.util.IHasModel;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UnderwaterFlower
extends Block
implements IPlantable,
IHasModel {
    public static final EnumPlantType UNDERWATERFLOWER = EnumPlantType.getPlantType((String)"UnderwaterFlower");
    protected static final AxisAlignedBB UNDERWATERFLOWER_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public UnderwaterFlower(String name, Material material) {
        super(material);
        this.func_149663_c("atlantis." + name);
        this.setRegistryName(name);
        this.func_149647_a(AtlantisTab.ATLANTIS_TAB);
        ModBlocks.BLOCKS.add(this);
        ModItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(Objects.requireNonNull(this.getRegistryName())));
        this.func_149675_a(true);
        this.func_149647_a(AtlantisTab.ATLANTIS_TAB);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(15)));
    }

    public boolean blockTypes(IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150351_n || blockState.func_177230_c() == Blocks.field_150349_c || blockState.func_177230_c() == Blocks.field_150346_d || blockState.func_177230_c() == Blocks.field_150354_m;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        if (worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() != Material.field_151586_h) {
            return false;
        }
        return this.blockTypes(state);
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockLiquid.field_176367_b});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return Block.field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return UNDERWATERFLOWER_AABB;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public boolean checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (this.canBlockStay(worldIn, pos, state)) {
            return true;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
        return false;
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        return this.func_176196_c(world, pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return UNDERWATERFLOWER;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos);
    }

    @Override
    public void registerModels() {
        Main.proxy.registerModel(Item.func_150898_a((Block)this), 0);
    }
}

