/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.init;

import com.mystic.atlantis.world.biomes.BiomeATLANTIS;
import com.mystic.atlantis.world.dimension.atlantis.ModBiomeAtlantis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBiomes {
    public static final List<ModBiomeEntry> biomeEntryList = new ArrayList<ModBiomeEntry>();
    public static final BiomeATLANTIS BIOME_ATLANTIS = new BiomeATLANTIS();

    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        ModBiomes.registerBiome(event, BIOME_ATLANTIS, BiomeManager.BiomeType.WARM, 2, 6, BiomeDictionary.Type.OCEAN);
    }

    private static void registerBiome(RegistryEvent.Register<Biome> event, ModBiomeAtlantis biome, BiomeManager.BiomeType type, int weight, int weightDimension, BiomeDictionary.Type ... biomeDictTypes) {
        event.getRegistry().register((IForgeRegistryEntry)biome);
        for (BiomeDictionary.Type biomeDictType : biomeDictTypes) {
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{biomeDictType});
        }
        biomeEntryList.add(new ModBiomeEntry(biome, type, weight, weightDimension));
    }

    public static class ModBiomeEntry {
        private final int weight;
        private final int weightDimension;
        private final Biome biome;
        private final BiomeManager.BiomeType type;
        private final BiomeManager.BiomeEntry entry;

        public ModBiomeEntry(ModBiomeAtlantis biome, BiomeManager.BiomeType type, int weight, int weightDimension) {
            this.type = type;
            this.biome = biome;
            this.weight = weight;
            this.weightDimension = weightDimension;
            this.entry = new BiomeManager.BiomeEntry((Biome)biome, weight);
        }

        public ModBiomeAtlantis getBiome() {
            return (ModBiomeAtlantis)this.biome;
        }

        public BiomeManager.BiomeEntry getEntry() {
            return this.entry;
        }

        public BiomeManager.BiomeType getType() {
            return this.type;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getDimensionWeight() {
            return this.weightDimension;
        }
    }
}

