/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.util.handlers;

import com.mystic.atlantis.init.ModBiomes;
import com.mystic.atlantis.init.ModBlocks;
import com.mystic.atlantis.init.ModItems;
import com.mystic.atlantis.util.IHasModel;
import com.mystic.atlantis.util.handlers.EventHandler.PositionEvent;
import com.mystic.atlantis.world.biomes.WorldTypeAtlantis;
import com.mystic.atlantis.world.dimension.atlantis.Dimension;
import com.mystic.atlantis.world.gen.WorldGenCustomStructures;
import com.mystic.atlantis.world.gen.WorldGenOres;
import com.mystic.atlantis.world.gen.WorldGenSubmarine;
import com.mystic.atlantis.world.gen.WorldGenUnderwaterFlower;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistryHandler {
    public static final WorldType WORLD_TYPE_ATLANTIS = new WorldTypeAtlantis();

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModBlocks.BLOCKS.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        ModBiomes.registerBiomes(event);
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (Item item : ModItems.ITEMS) {
            if (!(item instanceof IHasModel)) continue;
            ((IHasModel)item).registerModels();
        }
        for (Block block : ModBlocks.BLOCKS) {
            if (!(block instanceof IHasModel)) continue;
            ((IHasModel)block).registerModels();
        }
    }

    public static void preInitRegistries(FMLPreInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenOres(), (int)0);
        Dimension.registerDimensions();
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)WorldTypeAtlantis.field_77139_a);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenCustomStructures(), (int)1);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenSubmarine(), (int)2);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenUnderwaterFlower(), (int)3);
        MinecraftForge.EVENT_BUS.register((Object)new PositionEvent());
    }

    public static void initRegistries(FMLInitializationEvent event) {
        for (ModBiomes.ModBiomeEntry biomeEntry : ModBiomes.biomeEntryList) {
            if (biomeEntry.getWeight() <= 0) continue;
            BiomeManager.addBiome((BiomeManager.BiomeType)biomeEntry.getType(), (BiomeManager.BiomeEntry)biomeEntry.getEntry());
            BiomeManager.addStrongholdBiome((Biome)biomeEntry.getBiome());
        }
    }

    public static void postInitRegistries(FMLPostInitializationEvent event) {
    }
}

