/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.world.dimension.atlantis;

import com.mystic.atlantis.config.AtlantisConfig;
import com.mystic.atlantis.util.Math;
import com.mystic.atlantis.world.FastNoiseLite;
import com.mystic.atlantis.world.biomes.WorldTypeAtlantis;
import com.mystic.atlantis.world.dimension.atlantis.NoiseGenEventAtlantis;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.Loader;

public class ChunkGeneratorAtlantis
implements IChunkGenerator {
    protected static final IBlockState SAND = Blocks.field_150354_m.func_176223_P();
    protected static final IBlockState SANDSTONE = Blocks.field_150322_A.func_176223_P();
    private final Random rand;
    private NoiseGeneratorOctaves minLimitPerlinNoise;
    private NoiseGeneratorOctaves maxLimitPerlinNoise;
    private NoiseGeneratorOctaves mainPerlinNoise;
    public NoiseGeneratorOctaves scaleNoise;
    public NoiseGeneratorOctaves depthNoise;
    private final World world;
    private final boolean mapFeaturesEnabled;
    private float[] heightMap;
    private final float[] biomeWeights;
    private boolean useMineShafts = false;
    private boolean useVillages = false;
    private boolean useStrongholds = false;
    private boolean useTemples = false;
    private boolean useMonuments = false;
    private boolean useWaterLakes = false;
    private boolean useLavaLakes = false;
    private boolean useDungeons = false;
    private int waterLakeChance = 4;
    private int dungeonChance = 0;
    private int lavaLakeChance = 80;
    private int seaLevel = 256;
    private IBlockState oceanBlock = Blocks.field_150355_j.func_176223_P();
    private double[] depthBuffer = new double[256];
    private MapGenBase caveGenerator = new MapGenCaves();
    private MapGenStronghold strongholdGenerator = new MapGenStronghold();
    private MapGenVillage villageGenerator = new MapGenVillage();
    private MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private MapGenScatteredFeature scatteredFeatureGenerator = new MapGenScatteredFeature();
    private MapGenBase ravineGenerator = new MapGenRavine();
    private StructureOceanMonument oceanMonumentGenerator = new StructureOceanMonument();
    public static final boolean CC = Loader.isModLoaded((String)"cubicchunks");
    public Biome[] biomesForGeneration = new WorldTypeAtlantis().getAllowedBiomes().toArray(new Biome[0]);
    FastNoiseLite noise;

    public ChunkGeneratorAtlantis(World worldIn, boolean mapFeaturesEnabledIn, long seed) {
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)this.strongholdGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)this.villageGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)this.mineshaftGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)this.scatteredFeatureGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.ravineGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.oceanMonumentGenerator = (StructureOceanMonument)TerrainGen.getModdedMapGen((MapGenBase)this.oceanMonumentGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.OCEAN_MONUMENT);
        this.noise = new FastNoiseLite();
        this.noise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
        this.world = worldIn;
        this.mapFeaturesEnabled = mapFeaturesEnabledIn;
        this.rand = new Random(seed);
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.scaleNoise = new NoiseGeneratorOctaves(this.rand, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.heightMap = new float[25];
        this.biomeWeights = new float[25];
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                this.biomeWeights[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
        NoiseGenEventAtlantis.ContextAtlantis ctx = new NoiseGenEventAtlantis.ContextAtlantis(this.minLimitPerlinNoise, this.maxLimitPerlinNoise, this.mainPerlinNoise, this.scaleNoise, this.depthNoise);
        ctx = (NoiseGenEventAtlantis.ContextAtlantis)TerrainGen.getModdedNoiseGenerators((World)worldIn, (Random)this.rand, (InitNoiseGensEvent.Context)ctx);
        this.minLimitPerlinNoise = ctx.getLPerlin1();
        this.maxLimitPerlinNoise = ctx.getLPerlin2();
        this.mainPerlinNoise = ctx.getPerlin();
        this.scaleNoise = ctx.getScale();
        this.depthNoise = ctx.getDepth();
    }

    private void setBlocksInChunk(int x, int z, ChunkPrimer chunkPrimer, int size) {
        this.generateHeightmap(x * 4, 0, z * 4);
        for (int sectionX = 0; sectionX < size - 1; ++sectionX) {
            for (int sectionZ = 0; sectionZ < size - 1; ++sectionZ) {
                float d00 = this.heightMap[sectionX + sectionZ * size];
                float d01 = this.heightMap[sectionX + (sectionZ + 1) * size];
                float d10 = this.heightMap[sectionX + 1 + sectionZ * size];
                float d11 = this.heightMap[sectionX + 1 + (sectionZ + 1) * size];
                for (x = 0; x < 4; ++x) {
                    int dx0 = (int)Math.lerp((double)x * 0.25, (double)d00, (double)d10);
                    int dx1 = (int)Math.lerp((double)x * 0.25, (double)d01, (double)d11);
                    int dx = sectionX * 4 + x;
                    for (z = 0; z < 4; ++z) {
                        float height = Math.lerp((float)z * 0.25f, dx0, dx1);
                        int dz = sectionZ * 4 + z;
                        for (int dy = 0; dy < 256; ++dy) {
                            float blockY = (float)dy - height;
                            if (blockY < (float)dy) {
                                chunkPrimer.func_177855_a(dx & 0xF, dy & 0xFF, dz & 0xF, SAND);
                            }
                            if (blockY <= 50.0f) {
                                chunkPrimer.func_177855_a(dx & 0xF, dy & 0xFF, dz & 0xF, SANDSTONE);
                                continue;
                            }
                            if (dz > this.seaLevel) continue;
                            chunkPrimer.func_177855_a(dx & 0xF, dy & 0xFF, dz & 0xF, this.oceanBlock);
                        }
                    }
                }
            }
        }
    }

    public void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, Biome[] biomesForGeneration) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)x, (int)z, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        double d0 = 0.03125;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = biomesForGeneration[j + i * 16];
                biome.func_180622_a(this.world, this.rand, primer, x * 16 + i, z * 16 + j, this.depthBuffer[j + i * 16]);
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.setBlocksInChunk(x, z, chunkprimer, 5);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.replaceBiomeBlocks(x, z, chunkprimer, this.biomesForGeneration);
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void generateHeightmap(int xEnd, int yEnd, int zEnd) {
        for (int z = 0; z < 5; ++z) {
            for (int x = 0; x < 5; ++x) {
                float noiseVal = (this.noise.GetNoise(x + xEnd, 0.0f, z + zEnd) + 1.0f) / 2.0f;
                this.heightMap[x + z * 5] = noiseVal * (float)AtlantisConfig.FlatnessToSharpnessTerrainGen + (float)AtlantisConfig.HeightOfTerrainGen;
                if (!CC) continue;
                float noiseVal2 = (this.noise.GetNoise(x + xEnd, 0.0f, z + zEnd) + 1.0f) / 2.0f;
                this.heightMap[x + z * 5] = noiseVal2 * (float)AtlantisConfig.FlatnessToSharpnessTerrainGen + (float)AtlantisConfig.HeightOfTerrainGen;
            }
        }
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * k + (long)z * l ^ this.world.func_72905_C());
        boolean flag = false;
        ChunkPos chunkpos = new ChunkPos(x, z);
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag);
        if (this.mapFeaturesEnabled) {
            if (this.useMineShafts) {
                this.mineshaftGenerator.func_175794_a(this.world, this.rand, chunkpos);
            }
            if (this.useVillages) {
                flag = this.villageGenerator.func_175794_a(this.world, this.rand, chunkpos);
            }
            if (this.useStrongholds) {
                this.strongholdGenerator.func_175794_a(this.world, this.rand, chunkpos);
            }
            if (this.useTemples) {
                this.scatteredFeatureGenerator.func_175794_a(this.world, this.rand, chunkpos);
            }
            if (this.useMonuments) {
                this.oceanMonumentGenerator.func_175794_a(this.world, this.rand, chunkpos);
            }
        }
        if (biome != Biomes.field_76769_d && biome != Biomes.field_76786_s && this.useWaterLakes && !flag && this.rand.nextInt(this.waterLakeChance) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            int i1 = this.rand.nextInt(16) + 8;
            int j1 = this.rand.nextInt(256);
            int k1 = this.rand.nextInt(16) + 8;
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.world, this.rand, blockpos.func_177982_a(i1, j1, k1));
        }
        if (!flag && this.rand.nextInt(this.lavaLakeChance / 10) == 0 && this.useLavaLakes && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA)) {
            int i2 = this.rand.nextInt(16) + 8;
            int l2 = this.rand.nextInt(this.rand.nextInt(248) + 8);
            int k3 = this.rand.nextInt(16) + 8;
            if (l2 < this.world.func_181545_F() || this.rand.nextInt(this.lavaLakeChance / 8) == 0) {
                new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.world, this.rand, blockpos.func_177982_a(i2, l2, k3));
            }
        }
        if (this.useDungeons && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON)) {
            for (int j2 = 0; j2 < this.dungeonChance; ++j2) {
                int i3 = this.rand.nextInt(16) + 8;
                int l3 = this.rand.nextInt(256);
                int l1 = this.rand.nextInt(16) + 8;
                new WorldGenDungeons().func_180709_b(this.world, this.rand, blockpos.func_177982_a(i3, l3, l1));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.rand);
        }
        blockpos = blockpos.func_177982_a(8, 0, 8);
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            for (int k2 = 0; k2 < 16; ++k2) {
                for (int j3 = 0; j3 < 16; ++j3) {
                    BlockPos blockpos1 = this.world.func_175725_q(blockpos.func_177982_a(k2, 0, j3));
                    BlockPos blockpos2 = blockpos1.func_177977_b();
                    if (this.world.func_175675_v(blockpos2)) {
                        this.world.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 2);
                    }
                    if (!this.world.func_175708_f(blockpos1, true)) continue;
                    this.world.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 2);
                }
            }
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        boolean flag = false;
        if (this.useMonuments && this.mapFeaturesEnabled && chunkIn.func_177416_w() < 3600L) {
            flag |= this.oceanMonumentGenerator.func_175794_a(this.world, this.rand, new ChunkPos(x, z));
        }
        return flag;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_180494_b(pos);
        if (this.mapFeaturesEnabled) {
            if (creatureType == EnumCreatureType.MONSTER && this.scatteredFeatureGenerator.func_175798_a(pos)) {
                return this.scatteredFeatureGenerator.func_82667_a();
            }
            if (creatureType == EnumCreatureType.MONSTER && this.useMonuments && this.oceanMonumentGenerator.func_175796_a(this.world, pos)) {
                return this.oceanMonumentGenerator.func_175799_b();
            }
        }
        return biome.func_76747_a(creatureType);
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        if (!this.mapFeaturesEnabled) {
            return false;
        }
        if ("Stronghold".equals(structureName) && this.strongholdGenerator != null) {
            return this.strongholdGenerator.func_175795_b(pos);
        }
        if ("Monument".equals(structureName) && this.oceanMonumentGenerator != null) {
            return this.oceanMonumentGenerator.func_175795_b(pos);
        }
        if ("Village".equals(structureName) && this.villageGenerator != null) {
            return this.villageGenerator.func_175795_b(pos);
        }
        if ("Mineshaft".equals(structureName) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_175795_b(pos);
        }
        return "Temple".equals(structureName) && this.scatteredFeatureGenerator != null ? this.scatteredFeatureGenerator.func_175795_b(pos) : false;
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        if (!this.mapFeaturesEnabled) {
            return null;
        }
        if ("Stronghold".equals(structureName) && this.strongholdGenerator != null) {
            return this.strongholdGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Monument".equals(structureName) && this.oceanMonumentGenerator != null) {
            return this.oceanMonumentGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Village".equals(structureName) && this.villageGenerator != null) {
            return this.villageGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        if ("Mineshaft".equals(structureName) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        return "Temple".equals(structureName) && this.scatteredFeatureGenerator != null ? this.scatteredFeatureGenerator.func_180706_b(worldIn, position, findUnexplored) : null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
        if (this.mapFeaturesEnabled) {
            if (this.useMineShafts) {
                this.mineshaftGenerator.func_186125_a(this.world, x, z, (ChunkPrimer)null);
            }
            if (this.useVillages) {
                this.villageGenerator.func_186125_a(this.world, x, z, (ChunkPrimer)null);
            }
            if (this.useStrongholds) {
                this.strongholdGenerator.func_186125_a(this.world, x, z, (ChunkPrimer)null);
            }
            if (this.useTemples) {
                this.scatteredFeatureGenerator.func_186125_a(this.world, x, z, (ChunkPrimer)null);
            }
            if (this.useMonuments) {
                this.oceanMonumentGenerator.func_186125_a(this.world, x, z, (ChunkPrimer)null);
            }
        }
    }
}

