/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.world.gen;

import com.mystic.atlantis.config.AtlantisConfig;
import com.mystic.atlantis.world.biomes.BiomeATLANTIS;
import com.mystic.atlantis.world.gen.WorldGenStructure;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenCustomStructures
implements IWorldGenerator {
    public final WorldGenStructure ATLANTEAN_FOUNTAIN = new WorldGenStructure("atlantean_fountain");
    public final WorldGenStructure BIG_OYSTER = new WorldGenStructure("big_oyster");
    public final WorldGenStructure ATLANTEAN_SHIP_WRECK = new WorldGenStructure("atlantean_ship_wreck");
    public final WorldGenStructure BLACK_SHELL_STRUCTURE = new WorldGenStructure("black_shell_structure");
    public final WorldGenStructure BLUE_SHELL_STRUCTURE = new WorldGenStructure("blue_shell_structure");
    public final WorldGenStructure BROWN_SHELL_STRUCTURE = new WorldGenStructure("brown_shell_structure");
    public final WorldGenStructure CYAN_SHELL_STRUCTURE = new WorldGenStructure("cyan_shell_structure");
    public final WorldGenStructure GRAY_SHELL_STRUCTURE = new WorldGenStructure("gray_shell_structure");
    public final WorldGenStructure GREEN_SHELL_STRUCTURE = new WorldGenStructure("green_shell_structure");
    public final WorldGenStructure LIGHT_BLUE_SHELL_STRUCTURE = new WorldGenStructure("light_blue_shell_structure");
    public final WorldGenStructure LIGHT_GRAY_SHELL_STRUCTURE = new WorldGenStructure("light_gray_shell_structure");
    public final WorldGenStructure LIME_SHELL_STRUCTURE = new WorldGenStructure("lime_shell_structure");
    public final WorldGenStructure MAGENTA_SHELL_STRUCTURE = new WorldGenStructure("magenta_shell_structure");
    public final WorldGenStructure ORANGE_SHELL_STRUCTURE = new WorldGenStructure("orange_shell_structure");
    public final WorldGenStructure PINK_SHELL_STRUCTURE = new WorldGenStructure("pink_shell_structure");
    public final WorldGenStructure PURPLE_SHELL_STRUCTURE = new WorldGenStructure("purple_shell_structure");
    public final WorldGenStructure RED_SHELL_STRUCTURE = new WorldGenStructure("red_shell_structure");
    public final WorldGenStructure WHITE_SHELL_STRUCTURE = new WorldGenStructure("white_shell_structure");
    public final WorldGenStructure YELLOW_SHELL_STRUCTURE = new WorldGenStructure("yellow_shell_structure");

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == AtlantisConfig.dimensionId) {
            this.generateStructure(this.ATLANTEAN_FOUNTAIN, world, random, chunkX, chunkZ, 55);
            this.generateStructure(this.BIG_OYSTER, world, random, chunkX, chunkZ, 45);
            this.generateStructure(this.ATLANTEAN_SHIP_WRECK, world, random, chunkX, chunkZ, 35);
            this.generateStructure(this.BLACK_SHELL_STRUCTURE, world, random, chunkX, chunkZ, 3);
            this.generateStructure(this.CYAN_SHELL_STRUCTURE, world, random, chunkX, chunkZ, 3);
            this.generateStructure(this.BLUE_SHELL_STRUCTURE, world, random, chunkX, chunkZ, 3);
            this.generateStructure(this.BROWN_SHELL_STRUCTURE, world, random, chunkX, chunkZ, 3);
            this.generateStructure(this.GRAY_SHELL_STRUCTURE, world, random, chunkX, chunkZ, 3);
            this.generateStructure(this.GREEN_SHELL_STRUCTURE, world, random, chunkX, chunkZ, 3);
            this.generateStructure(this.LIGHT_BLUE_SHELL_STRUCTURE, world, random, chunkX, chunkZ, 3);
            this.generateStructure(this.LIGHT_GRAY_SHELL_STRUCTURE, world, random, chunkX, chunkZ, 3);
            this.generateStructure(this.LIME_SHELL_STRUCTURE, world, random, chunkX, chunkZ, 3);
            this.generateStructure(this.MAGENTA_SHELL_STRUCTURE, world, random, chunkX, chunkZ, 3);
            this.generateStructure(this.ORANGE_SHELL_STRUCTURE, world, random, chunkX, chunkZ, 3);
            this.generateStructure(this.PINK_SHELL_STRUCTURE, world, random, chunkX, chunkZ, 3);
            this.generateStructure(this.PURPLE_SHELL_STRUCTURE, world, random, chunkX, chunkZ, 3);
            this.generateStructure(this.RED_SHELL_STRUCTURE, world, random, chunkX, chunkZ, 3);
            this.generateStructure(this.WHITE_SHELL_STRUCTURE, world, random, chunkX, chunkZ, 3);
            this.generateStructure(this.YELLOW_SHELL_STRUCTURE, world, random, chunkX, chunkZ, 3);
        }
    }

    private void generateStructure(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int chance) {
        int x = chunkX * 16 + random.nextInt(15) + 8;
        int z = chunkZ * 16 + random.nextInt(15) + 8;
        int y = this.calculateGenerationHeight(world, x, z);
        BlockPos pos = new BlockPos(x, y, z);
        world.field_73011_w.getBiomeForCoords(pos);
        BiomeATLANTIS.func_150568_d((int)10);
        if (world.func_175624_G() != WorldType.field_77138_c && BiomeDictionary.hasType((Biome)BiomeATLANTIS.func_150568_d((int)10), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && random.nextInt(chance) == 0) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private int calculateGenerationHeight(World world, int x, int z) {
        for (int y = 0; y < 300; ++y) {
            if (world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != Blocks.field_150355_j) continue;
            return y;
        }
        return 3000;
    }
}

