/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.world.gen;

import com.mystic.atlantis.config.AtlantisConfig;
import com.mystic.atlantis.world.biomes.BiomeATLANTIS;
import com.mystic.atlantis.world.gen.WorldGenStructure;
import java.util.Objects;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenSubmarine
implements IWorldGenerator {
    public final WorldGenStructure ATLANTEAN_SUBMARINE = new WorldGenStructure("atlantean_submarine");

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == AtlantisConfig.dimensionId) {
            this.generateStructure(this.ATLANTEAN_SUBMARINE, world, random, chunkX, chunkZ, 35);
        }
    }

    private void generateStructure(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int chance) {
        int x = chunkX * 16 + random.nextInt(15) + 8;
        int z = chunkZ * 16 + random.nextInt(15) + 8;
        int y = this.calculateGenerationHeight(world, x, z);
        BlockPos pos = new BlockPos(x, y, z);
        world.field_73011_w.getBiomeForCoords(pos);
        BiomeATLANTIS.func_150568_d((int)10);
        if (world.func_175624_G() != WorldType.field_77138_c && BiomeDictionary.hasType((Biome)Objects.requireNonNull(BiomeATLANTIS.func_150568_d((int)10)), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && random.nextInt(chance) == 0) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private int calculateGenerationHeight(World world, int x, int z) {
        Random random = world.field_73012_v;
        int y = random.nextInt(250);
        if (world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == Blocks.field_150355_j) {
            return y;
        }
        return 260;
    }
}

