/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.biomes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mystic.atlantis.biomes.AtlantisBiomeLayer;
import com.mystic.atlantis.mixin.LayerAccessor;
import java.util.Map;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3625;
import net.minecraft.class_3627;
import net.minecraft.class_3628;
import net.minecraft.class_3631;
import net.minecraft.class_3642;
import net.minecraft.class_3660;
import net.minecraft.class_5321;
import net.minecraft.class_5504;
import net.minecraft.class_5505;

public class AtlantisBiomeSource
extends class_1966 {
    public static final Codec<AtlantisBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5505.method_31148((class_5321)class_2378.field_25114).forGetter(biomeSource -> biomeSource.BIOME_REGISTRY), (App)Codec.LONG.fieldOf("seed").stable().forGetter(biomeSource -> biomeSource.seed)).apply((Applicative)instance, instance.stable(AtlantisBiomeSource::new)));
    public static class_2960 ATLANTIS_BIOME = new class_2960("atlantis", "atlantis_biome");
    private final class_3642 BIOME_SAMPLER;
    private final class_2378<class_1959> BIOME_REGISTRY;
    public static class_2378<class_1959> LAYERS_BIOME_REGISTRY;
    private final long seed;

    protected AtlantisBiomeSource(class_2378<class_1959> biomeRegistry, long seed) {
        super(biomeRegistry.method_29722().stream().filter(entry -> ((class_5321)entry.getKey()).method_29177().method_12836().equals("atlantis")).map(Map.Entry::getValue).collect(Collectors.toList()));
        this.BIOME_REGISTRY = biomeRegistry;
        LAYERS_BIOME_REGISTRY = biomeRegistry;
        this.BIOME_SAMPLER = AtlantisBiomeSource.buildWorldProcedure(seed);
        this.seed = seed;
        AtlantisBiomeLayer.setSeed(seed);
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    public static class_3642 buildWorldProcedure(long seed) {
        class_3627 layerFactory = AtlantisBiomeSource.build(sand -> new class_3631(25, seed, sand));
        return new class_3642(layerFactory);
    }

    public static <T extends class_3625, C extends class_3628<T>> class_3627<T> stack(long seed, class_3660 parent, class_3627<T> incomingArea, int count, LongFunction<C> contextFactory) {
        class_3627 IAreaFactory = incomingArea;
        for (int i = 0; i < count; ++i) {
            IAreaFactory = parent.method_15862((class_3628)contextFactory.apply(seed + (long)i), IAreaFactory);
        }
        return IAreaFactory;
    }

    public static <T extends class_3625, C extends class_3628<T>> class_3627<T> build(LongFunction<C> contextFactory) {
        class_3627 layer = AtlantisBiomeLayer.INSTANCE.method_15854((class_3628)contextFactory.apply(200L));
        return layer;
    }

    public class_1966 method_27985(long seed) {
        return new AtlantisBiomeSource(this.BIOME_REGISTRY, seed);
    }

    public class_1959 sample(class_2378<class_1959> registry, int i, int j) {
        int k = ((LayerAccessor)this.BIOME_SAMPLER).getSampler().method_15825(i, j);
        class_1959 biome = (class_1959)registry.method_10200(k);
        if (biome == null) {
            if (class_155.field_1125) {
                throw (IllegalStateException)class_156.method_22320((Throwable)new IllegalStateException("Unknown biome id: " + k));
            }
            return (class_1959)registry.method_29107(class_5504.method_31144((int)0));
        }
        return biome;
    }

    public class_1959 method_16359(int x, int y, int z) {
        return this.sample(this.BIOME_REGISTRY, x, z);
    }
}

