/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.plants;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2429;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3494;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3614;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class Algae
extends class_2248
implements class_3737 {
    public static final class_2746 UP = class_2429.field_11327;
    public static final class_2746 NORTH = class_2429.field_11332;
    public static final class_2746 EAST = class_2429.field_11335;
    public static final class_2746 SOUTH = class_2429.field_11331;
    public static final class_2746 WEST = class_2429.field_11328;
    public static final Map<class_2350, class_2746> FACING_TO_PROPERTY_MAP = (Map)class_2429.field_11329.entrySet().stream().filter(facingProperty -> facingProperty.getKey() != class_2350.field_11033).collect(class_156.method_664());
    private static final class_265 UP_AABB = class_2248.method_9541((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 EAST_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final class_265 WEST_AABB = class_2248.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 SOUTH_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final class_265 NORTH_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<class_2680, class_265> stateToShapeMap;
    private static final class_2769<Boolean> WATERLOGGED = class_2741.field_12508;

    public Algae(class_4970.class_2251 properties) {
        super(properties.method_9640().method_9629(0.2f, 0.4f).method_9626(class_2498.field_11535).method_29292().method_9634().method_22488());
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)UP, (Comparable)Boolean.FALSE)).method_11657((class_2769)NORTH, (Comparable)Boolean.FALSE)).method_11657((class_2769)EAST, (Comparable)Boolean.FALSE)).method_11657((class_2769)SOUTH, (Comparable)Boolean.FALSE)).method_11657((class_2769)WEST, (Comparable)Boolean.FALSE)).method_11657(WATERLOGGED, (Comparable)Boolean.TRUE));
        this.stateToShapeMap = ImmutableMap.copyOf(this.field_10647.method_11662().stream().collect(Collectors.toMap(Function.identity(), Algae::getShapeForState)));
    }

    private static class_265 getShapeForState(class_2680 state) {
        class_265 voxelshape = class_259.method_1073();
        if (((Boolean)state.method_11654((class_2769)UP)).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (((Boolean)state.method_11654((class_2769)NORTH)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)SOUTH_AABB);
        }
        if (((Boolean)state.method_11654((class_2769)SOUTH)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)NORTH_AABB);
        }
        if (((Boolean)state.method_11654((class_2769)EAST)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)WEST_AABB);
        }
        if (((Boolean)state.method_11654((class_2769)WEST)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)EAST_AABB);
        }
        return voxelshape;
    }

    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return this.stateToShapeMap.get(state);
    }

    public boolean method_9558(class_2680 state, class_4538 worldIn, class_2338 pos) {
        if (this.OnlyWater(worldIn, pos, state)) {
            return this.getBlocksAttachedTo(this.func_196545_h(state, (class_1922)worldIn, pos));
        }
        return false;
    }

    public boolean OnlyWater(class_4538 worldReader, class_2338 pos, class_2680 state) {
        return !worldReader.method_8320(pos).method_26164(this.getAir()) || !this.canBlockStay(worldReader, pos, state);
    }

    public class_3494<class_2248> getAir() {
        class_3494<class_2248> air = new class_3494<class_2248>(){

            public boolean contains(class_2248 element) {
                return true;
            }

            public List<class_2248> method_15138() {
                ArrayList<class_2248> air2 = new ArrayList<class_2248>();
                air2.add(class_2246.field_10124);
                return air2;
            }
        };
        return air;
    }

    public boolean canBlockStay(class_4538 worldReader, class_2338 pos, class_2680 state) {
        return this.canPlaceBlockAt(worldReader, pos);
    }

    public boolean canPlaceBlockAt(class_4538 worldReader, class_2338 pos) {
        return worldReader.method_8320(pos.method_10084()).method_26207() != class_3614.field_15920;
    }

    private boolean getBlocksAttachedTo(class_2680 state) {
        return this.countBlocksAlgaeIsAttachedTo(state) > 0;
    }

    private int countBlocksAlgaeIsAttachedTo(class_2680 state) {
        int i = 0;
        for (class_2746 booleanproperty : FACING_TO_PROPERTY_MAP.values()) {
            if (!((Boolean)state.method_11654((class_2769)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private boolean hasAttachment(class_1922 blockReader, class_2338 pos, class_2350 direction) {
        if (direction == class_2350.field_11033) {
            return false;
        }
        class_2338 blockpos = pos.method_10093(direction);
        if (Algae.canAttachTo(blockReader, blockpos, direction)) {
            return true;
        }
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            return false;
        }
        class_2746 booleanproperty = FACING_TO_PROPERTY_MAP.get(direction);
        class_2680 blockstate = blockReader.method_8320(pos.method_10084());
        return blockstate.method_27852((class_2248)this) && (Boolean)blockstate.method_11654((class_2769)booleanproperty) != false;
    }

    public static boolean canAttachTo(class_1922 blockReader, class_2338 worldIn, class_2350 neighborPos) {
        class_2680 blockstate = blockReader.method_8320(worldIn);
        return class_2248.method_9501((class_265)blockstate.method_26220(blockReader, worldIn), (class_2350)neighborPos.method_10153());
    }

    private class_2680 func_196545_h(class_2680 state, class_1922 blockReader, class_2338 pos) {
        class_2338 blockpos = pos.method_10084();
        if (((Boolean)state.method_11654((class_2769)UP)).booleanValue()) {
            state = (class_2680)state.method_11657((class_2769)UP, (Comparable)Boolean.valueOf(Algae.canAttachTo(blockReader, blockpos, class_2350.field_11033)));
        }
        class_2680 blockstate = null;
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2746 booleanproperty = Algae.getPropertyFor(direction);
            if (!((Boolean)state.method_11654((class_2769)booleanproperty)).booleanValue()) continue;
            boolean flag = this.hasAttachment(blockReader, pos, direction);
            if (!flag) {
                if (blockstate == null) {
                    blockstate = blockReader.method_8320(blockpos);
                }
                flag = blockstate.method_27852((class_2248)this) && (Boolean)blockstate.method_11654((class_2769)booleanproperty) != false;
            }
            state = (class_2680)state.method_11657((class_2769)booleanproperty, (Comparable)Boolean.valueOf(flag));
        }
        return state;
    }

    public class_2680 method_9559(class_2680 stateIn, class_2350 facing, class_2680 facingState, class_1936 worldIn, class_2338 currentPos, class_2338 facingPos) {
        if (facing == class_2350.field_11033) {
            return super.method_9559(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        class_2680 blockstate = this.func_196545_h(stateIn, (class_1922)worldIn, currentPos);
        return !this.getBlocksAttachedTo(blockstate) ? class_2246.field_10382.method_9564() : blockstate;
    }

    public void method_9514(class_2680 state, class_3218 worldIn, class_2338 pos, Random random) {
        if (worldIn.field_9229.nextInt(4) == 0 && worldIn.method_22340(pos)) {
            class_2350 direction = class_2350.method_10162((Random)random);
            class_2338 blockpos = pos.method_10084();
            if (direction.method_10166().method_10179() && !((Boolean)state.method_11654((class_2769)Algae.getPropertyFor(direction))).booleanValue()) {
                if (this.hasAlgaeBelow((class_1922)worldIn, pos)) {
                    class_2338 blockpos4 = pos.method_10093(direction);
                    class_2680 blockstate4 = worldIn.method_8320(blockpos4);
                    if (Algae.isWater(blockstate4, blockpos4)) {
                        class_2350 direction3 = direction.method_10170();
                        class_2350 direction4 = direction.method_10160();
                        boolean flag = (Boolean)state.method_11654((class_2769)Algae.getPropertyFor(direction3));
                        boolean flag1 = (Boolean)state.method_11654((class_2769)Algae.getPropertyFor(direction4));
                        class_2338 blockpos2 = blockpos4.method_10093(direction3);
                        class_2338 blockpos3 = blockpos4.method_10093(direction4);
                        if (flag && Algae.canAttachTo((class_1922)worldIn, blockpos2, direction3)) {
                            worldIn.method_8652(blockpos4, (class_2680)this.method_9564().method_11657((class_2769)Algae.getPropertyFor(direction3), (Comparable)Boolean.TRUE), 2);
                        } else if (flag1 && Algae.canAttachTo((class_1922)worldIn, blockpos3, direction4)) {
                            worldIn.method_8652(blockpos4, (class_2680)this.method_9564().method_11657((class_2769)Algae.getPropertyFor(direction4), (Comparable)Boolean.TRUE), 2);
                        } else {
                            class_2350 direction1 = direction.method_10153();
                            if (flag && Algae.isWaterBlock((class_1937)worldIn, blockpos2) && Algae.canAttachTo((class_1922)worldIn, pos.method_10093(direction3), direction1)) {
                                worldIn.method_8652(blockpos2, (class_2680)this.method_9564().method_11657((class_2769)Algae.getPropertyFor(direction1), (Comparable)Boolean.TRUE), 2);
                            } else if (flag1 && Algae.isWaterBlock((class_1937)worldIn, blockpos3) && Algae.canAttachTo((class_1922)worldIn, pos.method_10093(direction4), direction1)) {
                                worldIn.method_8652(blockpos3, (class_2680)this.method_9564().method_11657((class_2769)Algae.getPropertyFor(direction1), (Comparable)Boolean.TRUE), 2);
                            } else if ((double)worldIn.field_9229.nextFloat() < 0.05 && Algae.canAttachTo((class_1922)worldIn, blockpos4.method_10084(), class_2350.field_11036)) {
                                worldIn.method_8652(blockpos4, (class_2680)this.method_9564().method_11657((class_2769)UP, (Comparable)Boolean.TRUE), 2);
                            }
                        }
                    } else if (Algae.canAttachTo((class_1922)worldIn, blockpos4, direction)) {
                        worldIn.method_8652(pos, (class_2680)state.method_11657((class_2769)Algae.getPropertyFor(direction), (Comparable)Boolean.TRUE), 2);
                    }
                }
            } else {
                class_2680 blockstate2;
                class_2680 blockstate1;
                class_2338 blockpos1;
                class_2680 blockstate;
                boolean isWater;
                if (direction == class_2350.field_11036 && pos.method_10264() < 255) {
                    if (this.hasAttachment((class_1922)worldIn, pos, direction)) {
                        worldIn.method_8652(pos, (class_2680)state.method_11657((class_2769)UP, (Comparable)Boolean.TRUE), 2);
                        return;
                    }
                    if (Algae.isWaterBlock((class_1937)worldIn, blockpos)) {
                        if (!this.hasAlgaeBelow((class_1922)worldIn, pos)) {
                            return;
                        }
                        class_2680 blockstate3 = state;
                        for (class_2350 direction2 : class_2350.class_2353.field_11062) {
                            if (!random.nextBoolean() && Algae.canAttachTo((class_1922)worldIn, blockpos.method_10093(direction2), class_2350.field_11036)) continue;
                            blockstate3 = (class_2680)blockstate3.method_11657((class_2769)Algae.getPropertyFor(direction2), (Comparable)Boolean.FALSE);
                        }
                        if (this.isFacingCardinal(blockstate3)) {
                            worldIn.method_8652(blockpos, blockstate3, 2);
                        }
                        return;
                    }
                }
                if (pos.method_10264() > 0 && ((isWater = Algae.isWater(blockstate = worldIn.method_8320(blockpos1 = pos.method_10074()), blockpos1)) || blockstate.method_27852((class_2248)this)) && (blockstate1 = isWater ? this.method_9564() : blockstate) != (blockstate2 = this.func_196544_a(state, blockstate1, random)) && this.isFacingCardinal(blockstate2)) {
                    worldIn.method_8652(blockpos1, blockstate2, 2);
                }
            }
        }
    }

    public static boolean isWaterBlock(class_1937 worldIn, class_2338 pos) {
        return Algae.isWater(worldIn.method_8320(pos), pos);
    }

    public static boolean isWater(class_2680 state, class_2338 pos) {
        return state.method_26207() == class_3614.field_15920;
    }

    private class_2680 func_196544_a(class_2680 state, class_2680 state2, Random rand) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2746 booleanproperty;
            if (!rand.nextBoolean() || !((Boolean)state.method_11654((class_2769)(booleanproperty = Algae.getPropertyFor(direction)))).booleanValue()) continue;
            state2 = (class_2680)state2.method_11657((class_2769)booleanproperty, (Comparable)Boolean.TRUE);
        }
        return state2;
    }

    private boolean isFacingCardinal(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)NORTH) != false || (Boolean)state.method_11654((class_2769)EAST) != false || (Boolean)state.method_11654((class_2769)SOUTH) != false || (Boolean)state.method_11654((class_2769)WEST) != false;
    }

    private boolean hasAlgaeBelow(class_1922 blockReader, class_2338 pos) {
        int i = 4;
        Iterable iterable = class_2338.method_10094((int)(pos.method_10263() - 4), (int)(pos.method_10264() - 1), (int)(pos.method_10260() - 4), (int)(pos.method_10263() + 4), (int)(pos.method_10264() + 1), (int)(pos.method_10260() + 4));
        int j = 5;
        for (class_2338 blockpos : iterable) {
            if (!blockReader.method_8320(blockpos).method_27852((class_2248)this) || --j > 0) continue;
            return false;
        }
        return true;
    }

    public boolean method_9616(class_2680 state, class_1750 useContext) {
        class_2680 blockstate = useContext.method_8045().method_8320(useContext.method_8037());
        if (blockstate.method_27852((class_2248)this)) {
            return this.countBlocksAlgaeIsAttachedTo(blockstate) < FACING_TO_PROPERTY_MAP.size();
        }
        return super.method_9616(state, useContext);
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2680 blockstate = context.method_8045().method_8320(context.method_8037());
        boolean flag = blockstate.method_27852((class_2248)this);
        class_2680 blockstate1 = flag ? blockstate : this.method_9564();
        for (class_2350 direction : context.method_7718()) {
            boolean flag1;
            if (direction == class_2350.field_11033) continue;
            class_2746 booleanproperty = Algae.getPropertyFor(direction);
            boolean bl = flag1 = flag && (Boolean)blockstate.method_11654((class_2769)booleanproperty) != false;
            if (flag1 || !this.hasAttachment((class_1922)context.method_8045(), context.method_8037(), direction)) continue;
            return (class_2680)blockstate1.method_11657((class_2769)booleanproperty, (Comparable)Boolean.TRUE);
        }
        return flag ? blockstate1 : null;
    }

    public int method_9505(class_2680 state, class_1922 worldIn, class_2338 pos) {
        return 255;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654(WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{UP, NORTH, EAST, SOUTH, WEST, WATERLOGGED});
    }

    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        switch (rot) {
            case field_11464: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            }
            case field_11465: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            }
            case field_11463: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)));
            }
        }
        return state;
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirrorIn) {
        switch (mirrorIn) {
            case field_11300: {
                return (class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            }
            case field_11301: {
                return (class_2680)((class_2680)state.method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            }
        }
        return super.method_9569(state, mirrorIn);
    }

    public static class_2746 getPropertyFor(class_2350 side) {
        return FACING_TO_PROPERTY_MAP.get(side);
    }
}

