/*
 * Decompiled with CFR 0.152.
 */
package com.loucaskreger.breedingtimevisualizer.client;

import com.loucaskreger.breedingtimevisualizer.config.ClientConfig;
import com.loucaskreger.breedingtimevisualizer.config.Config;
import com.loucaskreger.breedingtimevisualizer.networking.Networking;
import com.loucaskreger.breedingtimevisualizer.networking.packet.EntityPositionRequestPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="breedingtimevisualizer", value={Dist.CLIENT})
public class EventSubscriber {
    public static final String TEAM_NAME = "breedingcolor";
    public static List<AnimalEntity> entities = new ArrayList<AnimalEntity>();
    public static Map<Integer, Integer> entityBreedingTimers = new HashMap<Integer, Integer>();
    public static final KeyBinding key = new KeyBinding("breedingtimevisualizer.key.breedingtimer", 66, "breedingtimevisualizer.key.categories");
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static boolean toggled = false;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == Config.CLIENT_SPEC) {
            Config.bakeConfig();
        }
    }

    @SubscribeEvent
    public static void onRenderLiving(RenderLivingEvent.Pre<LivingEntity, EntityModel<LivingEntity>> event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof AnimalEntity && entities.contains((AnimalEntity)entity)) {
            Scoreboard scoreboard = EventSubscriber.mc.field_71441_e.func_96441_U();
            ScorePlayerTeam team = scoreboard.func_96531_f().contains(TEAM_NAME) ? scoreboard.func_96508_e(TEAM_NAME) : scoreboard.func_96527_f(TEAM_NAME);
            team.func_178774_a(TextFormatting.RED);
            scoreboard.func_197901_a(entity.func_110124_au().toString(), team);
            entity.func_184195_f(true);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (EventSubscriber.mc.field_71441_e != null) {
            if (key.func_151470_d() && ((Boolean)ClientConfig.holdOrToggle.get()).booleanValue()) {
                key.func_225593_a_(false);
                boolean bl = toggled = !toggled;
            }
            if ((Boolean)ClientConfig.holdOrToggle.get() != false ? toggled : key.func_151470_d()) {
                EventSubscriber.removeFromGlowTeam();
                entities = EventSubscriber.mc.field_71441_e.func_225317_b(AnimalEntity.class, EventSubscriber.mc.field_71439_g.func_174813_aQ().func_186662_g(Math.min(25.0, (Double)ClientConfig.viewRange.get())));
                if (!entities.isEmpty()) {
                    entities.forEach(entity -> Networking.INSTANCE.sendToServer((Object)new EntityPositionRequestPacket(entity.func_145782_y())));
                }
                EventSubscriber.addToGlowTeam();
            } else {
                Iterator<AnimalEntity> it = entities.iterator();
                while (it.hasNext()) {
                    AnimalEntity animal = it.next();
                    animal.func_184195_f(false);
                    it.remove();
                }
                entityBreedingTimers.clear();
            }
        }
    }

    private static void addToGlowTeam() {
        for (AnimalEntity animal : entities) {
            Scoreboard scoreboard = EventSubscriber.mc.field_71441_e.func_96441_U();
            ScorePlayerTeam team = scoreboard.func_96531_f().contains(TEAM_NAME) ? scoreboard.func_96508_e(TEAM_NAME) : scoreboard.func_96527_f(TEAM_NAME);
            scoreboard.func_197901_a(animal.func_110124_au().toString(), team);
            animal.func_184195_f(true);
        }
    }

    private static void removeFromGlowTeam() {
        Iterator<AnimalEntity> it = entities.iterator();
        while (it.hasNext()) {
            AnimalEntity animal = it.next();
            Scoreboard scoreboard = EventSubscriber.mc.field_71441_e.func_96441_U();
            if (scoreboard.func_96531_f().contains(TEAM_NAME)) {
                ScorePlayerTeam team = scoreboard.func_96508_e(TEAM_NAME);
                scoreboard.func_96512_b(animal.func_110124_au().toString(), team);
            }
            animal.func_184195_f(false);
            if (EventSubscriber.mc.field_71441_e.func_225317_b(AnimalEntity.class, EventSubscriber.mc.field_71439_g.func_174813_aQ().func_186662_g(Math.max(25.0, (Double)ClientConfig.viewRange.get()))).contains(animal)) continue;
            it.remove();
            entityBreedingTimers.remove(animal.func_145782_y());
        }
    }
}

