/*
 * Decompiled with CFR 0.152.
 */
package cech12.brickfurnace;

import cech12.brickfurnace.api.block.BrickFurnaceBlocks;
import cech12.brickfurnace.api.crafting.RecipeTypes;
import cech12.brickfurnace.config.ServerConfig;
import cech12.brickfurnace.crafting.BrickBlastingRecipe;
import cech12.brickfurnace.crafting.BrickSmeltingRecipe;
import cech12.brickfurnace.crafting.BrickSmokingRecipe;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="brickfurnace")
@Mod.EventBusSubscriber(modid="brickfurnace", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BrickFurnaceMod {
    public static final String MOD_ID = "brickfurnace";

    public BrickFurnaceMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ServerConfig.SERVER_CONFIG);
        ServerConfig.loadConfig(ServerConfig.SERVER_CONFIG, FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath()).resolve("brickfurnace-server.toml"));
    }

    @SubscribeEvent
    public static void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        RecipeTypes.BLASTING = (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)RecipeTypes.BLASTING_ID, (Object)new IRecipeType<BrickBlastingRecipe>(){});
        ForgeRegistries.RECIPE_SERIALIZERS.register(BrickBlastingRecipe.SERIALIZER);
        RecipeTypes.SMELTING = (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)RecipeTypes.SMELTING_ID, (Object)new IRecipeType<BrickSmeltingRecipe>(){});
        ForgeRegistries.RECIPE_SERIALIZERS.register(BrickSmeltingRecipe.SERIALIZER);
        RecipeTypes.SMOKING = (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)RecipeTypes.SMOKING_ID, (Object)new IRecipeType<BrickSmokingRecipe>(){});
        ForgeRegistries.RECIPE_SERIALIZERS.register(BrickSmokingRecipe.SERIALIZER);
    }

    @SubscribeEvent
    public static void registerVillagerWorkstations(RegistryEvent.Register<PointOfInterestType> event) {
        BrickFurnaceMod.addBlockStatesToPOIType(PointOfInterestType.field_221055_c, BrickFurnaceBlocks.BRICK_BLAST_FURNACE);
        BrickFurnaceMod.addBlockStatesToPOIType(PointOfInterestType.field_221056_d, BrickFurnaceBlocks.BRICK_SMOKER);
    }

    private static void addBlockStatesToPOIType(PointOfInterestType poiType, Block block) {
        HashSet poiTypeStates = new HashSet(poiType.field_221075_w);
        HashSet blockStates = new HashSet(block.func_176194_O().func_177619_a());
        poiTypeStates.addAll(blockStates);
        poiType.field_221075_w = ImmutableSet.copyOf(poiTypeStates);
        for (BlockState state : blockStates) {
            PointOfInterestType.field_221073_u.put(state, poiType);
        }
    }
}

