/*
 * Decompiled with CFR 0.152.
 */
package cech12.brickfurnace.jei;

import cech12.brickfurnace.api.block.BrickFurnaceBlocks;
import cech12.brickfurnace.api.crafting.RecipeTypes;
import cech12.brickfurnace.config.ServerConfig;
import cech12.brickfurnace.crafting.BrickBlastingRecipe;
import cech12.brickfurnace.crafting.BrickSmeltingRecipe;
import cech12.brickfurnace.crafting.BrickSmokingRecipe;
import cech12.brickfurnace.jei.BrickBlastingCategory;
import cech12.brickfurnace.jei.BrickSmeltingCategory;
import cech12.brickfurnace.jei.BrickSmokingCategory;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class BrickFurnaceJEIPlugin
implements IModPlugin {
    @Nonnull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("brickfurnace", "plugin_brickfurnace");
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            RecipeManager manager = player.field_71174_a.func_199526_e();
            registration.addRecipes((Collection)manager.func_241447_a_(RecipeTypes.SMELTING), RecipeTypes.SMELTING_ID);
            registration.addRecipes((Collection)manager.func_241447_a_(RecipeTypes.SMOKING), RecipeTypes.SMOKING_ID);
            registration.addRecipes((Collection)manager.func_241447_a_(RecipeTypes.BLASTING), RecipeTypes.BLASTING_ID);
            if (((Boolean)ServerConfig.VANILLA_RECIPES_ENABLED.get()).booleanValue()) {
                registration.addRecipes((Collection)manager.func_241447_a_(IRecipeType.field_222150_b).stream().filter(recipe -> ServerConfig.isRecipeNotBlacklisted(recipe.func_199560_c())).map(BrickSmeltingRecipe::convert).collect(Collectors.toList()), RecipeTypes.SMELTING_ID);
                registration.addRecipes((Collection)manager.func_241447_a_(IRecipeType.field_222152_d).stream().filter(recipe -> ServerConfig.isRecipeNotBlacklisted(recipe.func_199560_c())).map(BrickSmokingRecipe::convert).collect(Collectors.toList()), RecipeTypes.SMOKING_ID);
                registration.addRecipes((Collection)manager.func_241447_a_(IRecipeType.field_222151_c).stream().filter(recipe -> ServerConfig.isRecipeNotBlacklisted(recipe.func_199560_c())).map(BrickBlastingRecipe::convert).collect(Collectors.toList()), RecipeTypes.BLASTING_ID);
            }
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new BrickSmeltingCategory(guiHelper), new BrickSmokingCategory(guiHelper), new BrickBlastingCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BrickFurnaceBlocks.BRICK_FURNACE), new ResourceLocation[]{RecipeTypes.SMELTING_ID, VanillaRecipeCategoryUid.FUEL});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BrickFurnaceBlocks.BRICK_SMOKER), new ResourceLocation[]{RecipeTypes.SMOKING_ID, VanillaRecipeCategoryUid.FUEL});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BrickFurnaceBlocks.BRICK_BLAST_FURNACE), new ResourceLocation[]{RecipeTypes.BLASTING_ID, VanillaRecipeCategoryUid.FUEL});
    }
}

