/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.items.ImageItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public class ImageData {
    private UUID id;
    private long time;
    private String owner;
    @Nullable
    private ResourceLocation biome;
    @Nullable
    private List<ResourceLocation> entities;

    private ImageData() {
    }

    public UUID getId() {
        return this.id;
    }

    public long getTime() {
        return this.time;
    }

    public String getOwner() {
        return this.owner;
    }

    @Nullable
    public ResourceLocation getBiome() {
        return this.biome;
    }

    @Nullable
    public List<ResourceLocation> getEntities() {
        return this.entities;
    }

    @Nullable
    public static ImageData fromStack(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ImageItem)) {
            return null;
        }
        ImageData data = new ImageData();
        UUID id = ImageData.getImageID(stack);
        if (id == null) {
            return null;
        }
        data.id = id;
        data.time = ImageData.getTime(stack);
        data.owner = ImageData.getOwner(stack);
        if (((Boolean)Main.SERVER_CONFIG.advancedImageData.get()).booleanValue()) {
            data.biome = ImageData.getBiome(stack);
            data.entities = ImageData.getEntities(stack);
        }
        return data;
    }

    public static ImageData create(ServerPlayerEntity player, UUID imageID) {
        ImageData data = new ImageData();
        data.id = imageID;
        data.time = System.currentTimeMillis();
        data.owner = player.func_200200_C_().func_150261_e();
        if (((Boolean)Main.SERVER_CONFIG.advancedImageData.get()).booleanValue()) {
            data.biome = player.field_70170_p.func_226691_t_(player.func_233580_cy_()).getRegistryName();
            data.entities = player.field_70170_p.func_175647_a(LivingEntity.class, player.func_174813_aQ().func_186662_g(128.0), e -> ImageData.canEntityBeSeen(player, (Entity)e)).stream().sorted(Comparator.comparingDouble(arg_0 -> ((ServerPlayerEntity)player).func_70032_d(arg_0))).map(livingEntity -> livingEntity.func_200600_R().getRegistryName()).distinct().limit(((Integer)Main.SERVER_CONFIG.advancedDataMaxEntities.get()).intValue()).collect(Collectors.toList());
        }
        return data;
    }

    private static boolean canEntityBeSeen(ServerPlayerEntity player, Entity entity) {
        Vector3d lookVec;
        if (player == entity) {
            return false;
        }
        Vector3d playerVec = new Vector3d(player.func_226277_ct_(), player.func_226280_cw_(), player.func_226281_cx_());
        Vector3d entityVec = new Vector3d(entity.func_226277_ct_(), entity.func_226280_cw_(), entity.func_226281_cx_());
        Vector3d lookVecToEntity = entityVec.func_178788_d(playerVec).func_72432_b();
        if (ImageData.angle(lookVecToEntity, lookVec = player.func_70040_Z().func_72432_b()) > 90.0) {
            return false;
        }
        return player.field_70170_p.func_217299_a(new RayTraceContext(playerVec, entityVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player)).func_216346_c() == RayTraceResult.Type.MISS;
    }

    private static double angle(Vector3d vec1, Vector3d vec2) {
        return Math.toDegrees(Math.acos(vec1.func_72430_b(vec2) / (vec1.func_72433_c() * vec2.func_72433_c())));
    }

    public static ImageData dummy() {
        ImageData data = new ImageData();
        data.id = new UUID(0L, 0L);
        data.time = System.currentTimeMillis();
        data.owner = "Steve";
        return data;
    }

    public void addToImage(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ImageItem)) {
            return;
        }
        ImageData.setImageID(stack, this.id);
        ImageData.setTime(stack, this.time);
        ImageData.setOwner(stack, this.owner);
        if (this.biome != null) {
            ImageData.setBiome(stack, this.biome);
        }
        if (this.entities != null) {
            ImageData.setEntities(stack, this.entities);
        }
    }

    private static CompoundNBT getImageTag(ItemStack stack) {
        CompoundNBT compound = stack.func_196082_o();
        if (!compound.func_150297_b("image", 10)) {
            compound.func_218657_a("image", (INBT)new CompoundNBT());
        }
        return compound.func_74775_l("image");
    }

    private static void setImageID(ItemStack stack, UUID uuid) {
        CompoundNBT compound = ImageData.getImageTag(stack);
        compound.func_74772_a("image_id_most", uuid.getMostSignificantBits());
        compound.func_74772_a("image_id_least", uuid.getLeastSignificantBits());
    }

    @Nullable
    public static UUID getImageID(ItemStack stack) {
        CompoundNBT compound = ImageData.getImageTag(stack);
        if (!compound.func_150297_b("image_id_most", 4) || !compound.func_150297_b("image_id_least", 4)) {
            return null;
        }
        long most = compound.func_74763_f("image_id_most");
        long least = compound.func_74763_f("image_id_least");
        return new UUID(most, least);
    }

    private static void setTime(ItemStack stack, long time) {
        CompoundNBT compound = ImageData.getImageTag(stack);
        compound.func_74772_a("image_time", time);
    }

    private static long getTime(ItemStack stack) {
        CompoundNBT compound = ImageData.getImageTag(stack);
        if (!compound.func_150297_b("image_time", 4)) {
            return 0L;
        }
        return compound.func_74763_f("image_time");
    }

    private static void setOwner(ItemStack stack, String name) {
        CompoundNBT compound = ImageData.getImageTag(stack);
        compound.func_74778_a("owner", name);
    }

    private static String getOwner(ItemStack stack) {
        CompoundNBT compound = ImageData.getImageTag(stack);
        if (!compound.func_150297_b("owner", 8)) {
            return "";
        }
        return compound.func_74779_i("owner");
    }

    private static void setBiome(ItemStack stack, ResourceLocation biome) {
        CompoundNBT compound = ImageData.getImageTag(stack);
        compound.func_74778_a("biome", biome.toString());
    }

    @Nullable
    private static ResourceLocation getBiome(ItemStack stack) {
        CompoundNBT compound = ImageData.getImageTag(stack);
        if (!compound.func_150297_b("biome", 8)) {
            return null;
        }
        return new ResourceLocation(compound.func_74779_i("biome"));
    }

    private static void setEntities(ItemStack stack, List<ResourceLocation> entities) {
        CompoundNBT compound = ImageData.getImageTag(stack);
        ListNBT list = new ListNBT();
        for (ResourceLocation entity : entities) {
            list.add((Object)StringNBT.func_229705_a_((String)entity.toString()));
        }
        compound.func_218657_a("entities", (INBT)list);
    }

    @Nullable
    private static List<ResourceLocation> getEntities(ItemStack stack) {
        CompoundNBT compound = ImageData.getImageTag(stack);
        if (!compound.func_150297_b("entities", 9)) {
            return null;
        }
        ListNBT entities = compound.func_150295_c("entities", 8);
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (INBT e : entities) {
            list.add(new ResourceLocation(e.func_150285_a_()));
        }
        return list;
    }
}

