/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import de.maxhenkel.camera.Main;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="camera")
public class ServerEvents {
    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.player.func_184614_ca().func_77973_b().equals((Object)Main.CAMERA) || event.player.func_184592_cb().func_77973_b().equals((Object)Main.CAMERA)) {
            return;
        }
        this.disableCamera(event.player.field_71071_by.func_70448_g());
        for (ItemStack stack : event.player.field_71071_by.field_70462_a) {
            this.disableCamera(stack);
        }
        for (ItemStack stack : event.player.field_71071_by.field_184439_c) {
            this.disableCamera(stack);
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        for (Hand hand : Hand.values()) {
            ItemStack item = player.func_184586_b(hand);
            if (!item.func_77973_b().equals((Object)Main.CAMERA) || !Main.CAMERA.isActive(item)) continue;
            event.setUseBlock(Event.Result.DENY);
            event.setCanceled(true);
            break;
        }
    }

    @SubscribeEvent
    public void onLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        this.handleLeftClick((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        this.handleLeftClick((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public void onLeftClick(PlayerInteractEvent.EntityInteract event) {
        this.handleLeftClick((PlayerInteractEvent)event);
    }

    public void handleLeftClick(PlayerInteractEvent event) {
        for (Hand hand : Hand.values()) {
            ItemStack stack = event.getPlayer().func_184586_b(hand);
            if (!stack.func_77973_b().equals((Object)Main.CAMERA) || !Main.CAMERA.isActive(stack)) continue;
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            event.setCancellationResult(ActionResultType.PASS);
            break;
        }
    }

    @SubscribeEvent
    public void onHit(LivingAttackEvent event) {
        Entity source = event.getSource().func_76364_f();
        if (!(source instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)source;
        for (Hand hand : Hand.values()) {
            ItemStack stack = player.func_184586_b(hand);
            if (!stack.func_77973_b().equals((Object)Main.CAMERA) || !Main.CAMERA.isActive(stack)) continue;
            event.setCanceled(true);
            break;
        }
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        this.disableCamera(event.getEntityItem().func_92059_d());
    }

    private void disableCamera(ItemStack stack) {
        if (stack.func_77973_b().equals((Object)Main.CAMERA)) {
            Main.CAMERA.setActive(stack, false);
        }
    }
}

