/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.corelib.helpers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.camera.corelib.client.RenderUtils;
import de.maxhenkel.camera.corelib.helpers.AbstractStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class WrappedFluidStack
extends AbstractStack<FluidStack> {
    public WrappedFluidStack(FluidStack stack) {
        super(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(MatrixStack matrixStack, int x, int y) {
        TextureAtlasSprite texture = Minecraft.func_71410_x().func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(((FluidStack)this.stack).getFluid().getAttributes().getStillTexture());
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture.func_229241_m_().func_229223_g_());
        WrappedFluidStack.fluidBlit(matrixStack, x, y, 16, 16, texture, ((FluidStack)this.stack).getFluid().getAttributes().getColor());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<ITextComponent> getTooltip(Screen screen) {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        tooltip.add(this.getDisplayName());
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            ResourceLocation registryName = ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)((FluidStack)this.stack).getFluid());
            if (registryName != null) {
                tooltip.add((ITextComponent)new StringTextComponent(registryName.toString()).func_240699_a_(TextFormatting.DARK_GRAY));
            }
            if (((FluidStack)this.stack).hasTag()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.nbt_tags", new Object[]{((FluidStack)this.stack).getTag().func_150296_c().size()}).func_240699_a_(TextFormatting.DARK_GRAY));
            }
        }
        return tooltip;
    }

    @Override
    public ITextComponent getDisplayName() {
        return new StringTextComponent("").func_230529_a_(((FluidStack)this.stack).getDisplayName()).func_240699_a_(((FluidStack)this.stack).getFluid().getAttributes().getRarity().field_77937_e);
    }

    @Override
    public boolean isEmpty() {
        return ((FluidStack)this.stack).isEmpty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void fluidBlit(MatrixStack matrixStack, int x, int y, int width, int height, TextureAtlasSprite sprite, int color) {
        WrappedFluidStack.innerBlit(matrixStack.func_227866_c_().func_227870_a_(), x, x + width, y, y + height, sprite.func_94209_e(), sprite.func_94212_f(), sprite.func_94206_g(), (sprite.func_94210_h() - sprite.func_94206_g()) * (float)height / 16.0f + sprite.func_94206_g(), color);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void innerBlit(Matrix4f matrix, int x1, int x2, int y1, int y2, float minU, float maxU, float minV, float maxV, int color) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_227888_a_(matrix, (float)x1, (float)y2, 0.0f).func_225583_a_(minU, maxV).func_225586_a_(RenderUtils.getRed(color), RenderUtils.getGreen(color), RenderUtils.getBlue(color), 255).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x2, (float)y2, 0.0f).func_225583_a_(maxU, maxV).func_225586_a_(RenderUtils.getRed(color), RenderUtils.getGreen(color), RenderUtils.getBlue(color), 255).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x2, (float)y1, 0.0f).func_225583_a_(maxU, minV).func_225586_a_(RenderUtils.getRed(color), RenderUtils.getGreen(color), RenderUtils.getBlue(color), 255).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x1, (float)y1, 0.0f).func_225583_a_(minU, minV).func_225586_a_(RenderUtils.getRed(color), RenderUtils.getGreen(color), RenderUtils.getBlue(color), 255).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }
}

