/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.camera.ClientImageUploadManager;
import de.maxhenkel.camera.ImageTools;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.Shaders;
import de.maxhenkel.camera.corelib.inventory.ScreenBase;
import de.maxhenkel.camera.gui.DummyContainer;
import de.maxhenkel.camera.net.MessageRequestUploadCustomImage;
import de.maxhenkel.camera.net.MessageSetShader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class CameraScreen
extends ScreenBase<Container> {
    private static final ResourceLocation CAMERA_TEXTURE = new ResourceLocation("camera", "textures/gui/camera.png");
    private static final int FONT_COLOR = 0x404040;
    private static final int PADDING = 10;
    private static final int BUTTON_WIDTH = 70;
    private static final int BUTTON_HEIGHT = 20;
    private int index = 0;
    private Button upload;

    public CameraScreen(String currentShader) {
        super(CAMERA_TEXTURE, new DummyContainer(), null, (ITextComponent)new TranslationTextComponent("gui.camera.title"));
        this.field_146999_f = 248;
        this.field_147000_g = 109;
        for (int i = 0; i < Shaders.SHADER_LIST.size(); ++i) {
            String s = Shaders.SHADER_LIST.get(i);
            if (currentShader == null) {
                if (!s.equals("none")) continue;
                this.index = i;
                break;
            }
            if (!s.equals(currentShader)) continue;
            this.index = i;
            break;
        }
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        this.field_230712_o_.getClass();
        this.func_230480_a_((Widget)new Button(this.field_147003_i + 10, this.field_147009_r + 10 + 9 + 10, 70, 20, (ITextComponent)new TranslationTextComponent("button.camera.prev"), button -> {
            --this.index;
            if (this.index < 0) {
                this.index = Shaders.SHADER_LIST.size() - 1;
            }
            this.sendShader();
        }));
        this.field_230712_o_.getClass();
        this.func_230480_a_((Widget)new Button(this.field_147003_i + this.field_146999_f - 70 - 10, this.field_147009_r + 10 + 9 + 10, 70, 20, (ITextComponent)new TranslationTextComponent("button.camera.next"), button -> {
            ++this.index;
            if (this.index >= Shaders.SHADER_LIST.size()) {
                this.index = 0;
            }
            this.sendShader();
        }));
        if (((Boolean)Main.SERVER_CONFIG.allowImageUpload.get()).booleanValue()) {
            this.upload = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + this.field_146999_f / 2 - 35, this.field_147009_r + this.field_147000_g - 20 - 10, 70, 20, (ITextComponent)new TranslationTextComponent("button.camera.upload"), button -> ImageTools.chooseImage(file -> {
                try {
                    UUID uuid = UUID.randomUUID();
                    BufferedImage image = ImageTools.loadImage(file);
                    ClientImageUploadManager.addImage(uuid, image);
                    Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageRequestUploadCustomImage(uuid));
                }
                catch (IOException e) {
                    this.field_230706_i_.field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("message.upload_error", new Object[]{e.getMessage()}), true);
                    e.printStackTrace();
                }
                this.field_230706_i_.field_71462_r = null;
            })));
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.upload.field_230693_o_ = !ImageTools.isFileChooserOpen();
    }

    private void sendShader() {
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageSetShader(Shaders.SHADER_LIST.get(this.index)));
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        TranslationTextComponent chooseFilter = new TranslationTextComponent("gui.camera.choose_filter");
        int chooseFilterWidth = this.field_230712_o_.func_238414_a_((ITextProperties)chooseFilter);
        this.field_230712_o_.func_238422_b_(matrixStack, chooseFilter.func_241878_f(), (float)(this.field_146999_f / 2 - chooseFilterWidth / 2), 10.0f, 0x404040);
        TranslationTextComponent shaderName = new TranslationTextComponent("shader." + Shaders.SHADER_LIST.get(this.index));
        int shaderWidth = this.field_230712_o_.func_238414_a_((ITextProperties)shaderName);
        IReorderingProcessor iReorderingProcessor = shaderName.func_241878_f();
        float f = this.field_146999_f / 2 - shaderWidth / 2;
        this.field_230712_o_.getClass();
        this.field_230712_o_.getClass();
        this.field_230712_o_.func_238422_b_(matrixStack, iReorderingProcessor, f, (float)(10 + 9 + 10 + 10 - 9 / 2), TextFormatting.WHITE.func_211163_e().intValue());
        TranslationTextComponent uploadImage = new TranslationTextComponent("gui.camera.upload_image");
        int uploadImageWidth = this.field_230712_o_.func_238414_a_((ITextProperties)uploadImage);
        IReorderingProcessor iReorderingProcessor2 = uploadImage.func_241878_f();
        float f2 = this.field_146999_f / 2 - uploadImageWidth / 2;
        this.field_230712_o_.getClass();
        this.field_230712_o_.func_238422_b_(matrixStack, iReorderingProcessor2, f2, (float)(this.field_147000_g - 10 - 20 - 10 - 9), 0x404040);
    }
}

