/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.integration.waila;

import de.maxhenkel.camera.ImageData;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.entities.ImageEntity;
import java.util.Date;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITaggableList;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class HUDHandlerImageFrame
implements IEntityComponentProvider {
    static final ResourceLocation OBJECT_NAME_TAG = new ResourceLocation("waila", "object_name");
    static final ResourceLocation CONFIG_SHOW_REGISTRY = new ResourceLocation("waila", "show_registry");
    static final ResourceLocation REGISTRY_NAME_TAG = new ResourceLocation("waila", "registry_name");
    static final HUDHandlerImageFrame INSTANCE = new HUDHandlerImageFrame();

    public void appendHead(List<ITextComponent> t, IEntityAccessor accessor, IPluginConfig config) {
        ITaggableList tooltip = (ITaggableList)t;
        tooltip.setTag((Object)OBJECT_NAME_TAG, (Object)new StringTextComponent(String.format(((WailaConfig)Waila.CONFIG.get()).getFormatting().getEntityName(), accessor.getEntity().func_145748_c_().getString())));
        if (config.get(CONFIG_SHOW_REGISTRY)) {
            tooltip.setTag((Object)REGISTRY_NAME_TAG, (Object)new StringTextComponent(accessor.getEntity().func_200600_R().getRegistryName().toString()).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public void appendBody(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (!(accessor.getEntity() instanceof ImageEntity)) {
            return;
        }
        ImageEntity image = (ImageEntity)accessor.getEntity();
        ImageData imageData = ImageData.fromStack(image.getItem());
        if (imageData == null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.image_frame_empty"));
            return;
        }
        if (!imageData.getOwner().isEmpty()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.image_owner", new Object[]{TextFormatting.DARK_GRAY + imageData.getOwner()}).func_240699_a_(TextFormatting.GRAY));
        }
        if (imageData.getTime() > 0L) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.image_time", new Object[]{TextFormatting.DARK_GRAY + Main.CLIENT_CONFIG.imageDateFormat.format(new Date(imageData.getTime()))}).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public void appendTail(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        tooltip.add((ITextComponent)new StringTextComponent(String.format(((WailaConfig)Waila.CONFIG.get()).getFormatting().getModName(), ModIdentification.getModInfo((Entity)accessor.getEntity()).getName())));
    }
}

