/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.items;

import de.maxhenkel.camera.ImageData;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.gui.ImageScreen;
import de.maxhenkel.camera.items.render.ImageItemRenderer;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ImageItem
extends Item {
    public ImageItem() {
        super(new Item.Properties().func_200917_a(1).setISTER(() -> ImageItemRenderer::new));
        this.setRegistryName(new ResourceLocation("camera", "image"));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.field_70170_p.field_72995_K) {
            this.openClientGui(stack);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openClientGui(ItemStack stack) {
        Minecraft.func_71410_x().func_147108_a((Screen)new ImageScreen(stack));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ImageData data = ImageData.fromStack(stack);
        if (data != null) {
            long time;
            String name = data.getOwner();
            if (!name.isEmpty()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.image_owner", new Object[]{TextFormatting.DARK_GRAY + name}).func_240699_a_(TextFormatting.GRAY));
            }
            if ((time = data.getTime()) > 0L) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.image_time", new Object[]{TextFormatting.DARK_GRAY + Main.CLIENT_CONFIG.imageDateFormat.format(new Date(time))}).func_240699_a_(TextFormatting.GRAY));
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

