/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.ImageData;
import de.maxhenkel.camera.ImageTools;
import de.maxhenkel.camera.Main;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

public class PacketManager {
    private Map<UUID, byte[]> clientDataMap = new HashMap<UUID, byte[]>();
    private Map<UUID, BufferedImage> imageCache = new HashMap<UUID, BufferedImage>();
    private Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();

    public void addBytes(ServerPlayerEntity playerMP, UUID imagegID, int offset, int length, byte[] bytes) {
        byte[] data = !this.clientDataMap.containsKey(imagegID) ? new byte[length] : this.clientDataMap.get(imagegID);
        System.arraycopy(bytes, 0, data, offset, bytes.length);
        this.clientDataMap.put(imagegID, data);
        if (offset + bytes.length >= data.length) {
            try {
                BufferedImage image = this.completeImage(imagegID);
                if (image == null) {
                    throw new IOException("Image incomplete");
                }
                this.imageCache.put(imagegID, image);
                new Thread(() -> {
                    try {
                        ImageTools.saveImage(playerMP, imagegID, image);
                        playerMP.func_184102_h().func_213165_a(() -> {
                            ItemStack stack = new ItemStack((IItemProvider)Main.IMAGE);
                            ImageData imageData = ImageData.create(playerMP, imagegID);
                            imageData.addToImage(stack);
                            if (!playerMP.func_191521_c(stack)) {
                                InventoryHelper.func_180173_a((World)playerMP.field_70170_p, (double)playerMP.func_226277_ct_(), (double)playerMP.func_226278_cu_(), (double)playerMP.func_226281_cx_(), (ItemStack)stack);
                            }
                        });
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }, "SaveImageThread").start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public BufferedImage getExistingImage(ServerPlayerEntity playerMP, UUID uuid) throws IOException {
        if (this.imageCache.containsKey(uuid)) {
            return this.imageCache.get(uuid);
        }
        BufferedImage image = ImageTools.loadImage(playerMP, uuid);
        this.imageCache.put(uuid, image);
        return image;
    }

    public BufferedImage completeImage(UUID imgUUID) {
        byte[] data = this.clientDataMap.get(imgUUID);
        if (data == null) {
            return null;
        }
        try {
            BufferedImage image = ImageTools.fromBytes(data);
            this.clientDataMap.remove(imgUUID);
            return image;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean canTakeImage(UUID player) {
        if (this.cooldowns.containsKey(player)) {
            if (System.currentTimeMillis() - this.cooldowns.get(player) < (long)((Integer)Main.SERVER_CONFIG.imageCooldown.get()).intValue()) {
                return false;
            }
            this.cooldowns.put(player, System.currentTimeMillis());
            return true;
        }
        this.cooldowns.put(player, System.currentTimeMillis());
        return true;
    }
}

