/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.blocks.BlockAsphalt;
import de.maxhenkel.car.blocks.BlockAsphaltSlab;
import de.maxhenkel.car.blocks.BlockAsphaltSlope;
import de.maxhenkel.car.blocks.BlockAsphaltSlopeFlat;
import de.maxhenkel.car.blocks.BlockBackmixReactor;
import de.maxhenkel.car.blocks.BlockBlastFurnace;
import de.maxhenkel.car.blocks.BlockCable;
import de.maxhenkel.car.blocks.BlockCanolaCrop;
import de.maxhenkel.car.blocks.BlockCarPressurePlate;
import de.maxhenkel.car.blocks.BlockCarWorkshop;
import de.maxhenkel.car.blocks.BlockCarWorkshopOutter;
import de.maxhenkel.car.blocks.BlockCrank;
import de.maxhenkel.car.blocks.BlockDynamo;
import de.maxhenkel.car.blocks.BlockFluidExtractor;
import de.maxhenkel.car.blocks.BlockFluidPipe;
import de.maxhenkel.car.blocks.BlockGasStation;
import de.maxhenkel.car.blocks.BlockGasStationTop;
import de.maxhenkel.car.blocks.BlockGenerator;
import de.maxhenkel.car.blocks.BlockGuardRail;
import de.maxhenkel.car.blocks.BlockOilMill;
import de.maxhenkel.car.blocks.BlockPaint;
import de.maxhenkel.car.blocks.BlockSign;
import de.maxhenkel.car.blocks.BlockSignPost;
import de.maxhenkel.car.blocks.BlockSplitTank;
import de.maxhenkel.car.blocks.BlockSplitTankTop;
import de.maxhenkel.car.blocks.BlockTank;
import de.maxhenkel.car.blocks.fluid.CarFluidBlock;
import de.maxhenkel.car.corelib.block.IItemBlock;
import de.maxhenkel.car.corelib.reflection.ReflectionUtils;
import de.maxhenkel.car.fluids.ModFluids;
import de.maxhenkel.tools.NoRegister;
import de.maxhenkel.tools.OnlyBlock;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;

public class ModBlocks {
    public static final BlockAsphalt ASPHALT;
    public static final BlockAsphaltSlope ASPHALT_SLOPE;
    public static final BlockAsphaltSlopeFlat ASPHALT_SLOPE_FLAT_UPPER;
    public static final BlockAsphaltSlopeFlat ASPHALT_SLOPE_FLAT_LOWER;
    public static final BlockAsphaltSlab ASPHALT_SLAB;
    public static final BlockGasStation GAS_STATION;
    @OnlyBlock
    public static final BlockGasStationTop GAS_STATION_TOP;
    @OnlyBlock
    public static final BlockCanolaCrop CANOLA_CROP;
    public static final BlockOilMill OIL_MILL;
    public static final BlockBlastFurnace BLAST_FURNACE;
    public static final BlockBackmixReactor BACKMIX_REACTOR;
    public static final BlockGenerator GENERATOR;
    public static final BlockSplitTank SPLIT_TANK;
    @OnlyBlock
    public static final BlockSplitTankTop SPLIT_TANK_TOP;
    public static final BlockTank TANK;
    @OnlyBlock
    public static final BlockGuardRail GUARD_RAIL;
    public static final BlockCarWorkshop CAR_WORKSHOP;
    public static final BlockCarWorkshopOutter CAR_WORKSHOP_OUTTER;
    public static final BlockCable CABLE;
    public static final BlockFluidExtractor FLUID_EXTRACTOR;
    public static final BlockFluidPipe FLUID_PIPE;
    public static final BlockDynamo DYNAMO;
    public static final BlockCrank CRANK;
    public static final BlockSign SIGN;
    public static final BlockSignPost SIGN_POST;
    public static final BlockCarPressurePlate CAR_PRESSURE_PLATE;
    public static final LiquidBlock BIO_DIESEL;
    public static final LiquidBlock CANOLA_METHANOL_MIX;
    public static final LiquidBlock CANOLA_OIL;
    public static final LiquidBlock GLYCERIN;
    public static final LiquidBlock METHANOL;
    public static final BlockPaint[] PAINTS;
    public static final BlockPaint[] YELLOW_PAINTS;

    public static List<IItemBlock> getBlocksWithItems() {
        ArrayList<IItemBlock> blocks = new ArrayList<IItemBlock>();
        for (Field field : ModBlocks.class.getFields()) {
            if (ReflectionUtils.hasAnnotation(field, NoRegister.class) || ReflectionUtils.hasAnnotation(field, OnlyBlock.class)) continue;
            try {
                Object obj = field.get(null);
                if (!(obj instanceof IItemBlock)) continue;
                blocks.add((IItemBlock)obj);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        blocks.addAll(Arrays.asList(PAINTS));
        blocks.addAll(Arrays.asList(YELLOW_PAINTS));
        return blocks;
    }

    public static List<Block> getAll() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Field field : ModBlocks.class.getFields()) {
            if (ReflectionUtils.hasAnnotation(field, NoRegister.class)) continue;
            try {
                Object obj = field.get(null);
                if (!(obj instanceof Block)) continue;
                blocks.add((Block)obj);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        blocks.addAll(Arrays.asList(PAINTS));
        blocks.addAll(Arrays.asList(YELLOW_PAINTS));
        return blocks;
    }

    static {
        int i;
        ASPHALT = new BlockAsphalt();
        ASPHALT_SLOPE = new BlockAsphaltSlope();
        ASPHALT_SLOPE_FLAT_UPPER = new BlockAsphaltSlopeFlat(true);
        ASPHALT_SLOPE_FLAT_LOWER = new BlockAsphaltSlopeFlat(false);
        ASPHALT_SLAB = new BlockAsphaltSlab();
        GAS_STATION = new BlockGasStation();
        GAS_STATION_TOP = new BlockGasStationTop();
        CANOLA_CROP = new BlockCanolaCrop();
        OIL_MILL = new BlockOilMill();
        BLAST_FURNACE = new BlockBlastFurnace();
        BACKMIX_REACTOR = new BlockBackmixReactor();
        GENERATOR = new BlockGenerator();
        SPLIT_TANK = new BlockSplitTank();
        SPLIT_TANK_TOP = new BlockSplitTankTop();
        TANK = new BlockTank();
        GUARD_RAIL = new BlockGuardRail();
        CAR_WORKSHOP = new BlockCarWorkshop();
        CAR_WORKSHOP_OUTTER = new BlockCarWorkshopOutter();
        CABLE = new BlockCable();
        FLUID_EXTRACTOR = new BlockFluidExtractor();
        FLUID_PIPE = new BlockFluidPipe();
        DYNAMO = new BlockDynamo();
        CRANK = new BlockCrank();
        SIGN = new BlockSign();
        SIGN_POST = new BlockSignPost();
        CAR_PRESSURE_PLATE = new BlockCarPressurePlate();
        BIO_DIESEL = new CarFluidBlock(() -> ModFluids.BIO_DIESEL);
        CANOLA_METHANOL_MIX = new CarFluidBlock(() -> ModFluids.CANOLA_METHANOL_MIX);
        CANOLA_OIL = new CarFluidBlock(() -> ModFluids.CANOLA_OIL);
        GLYCERIN = new CarFluidBlock(() -> ModFluids.GLYCERIN);
        METHANOL = new CarFluidBlock(() -> ModFluids.METHANOL);
        PAINTS = new BlockPaint[BlockPaint.EnumPaintType.values().length];
        for (i = 0; i < PAINTS.length; ++i) {
            ModBlocks.PAINTS[i] = new BlockPaint(BlockPaint.EnumPaintType.values()[i], false);
        }
        YELLOW_PAINTS = new BlockPaint[BlockPaint.EnumPaintType.values().length];
        for (i = 0; i < YELLOW_PAINTS.length; ++i) {
            ModBlocks.YELLOW_PAINTS[i] = new BlockPaint(BlockPaint.EnumPaintType.values()[i], true);
        }
    }
}

